/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.edit.ui.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.ui.hyperlink.HyperlinkUtil;
import oracle.eclipse.tools.xml.edit.ui.Activator;
import oracle.eclipse.tools.xml.edit.ui.common.IControllerContext;
import oracle.eclipse.tools.xml.edit.ui.common.IRefreshListener;
import oracle.eclipse.tools.xml.edit.ui.common.Messages;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.provider.TagEditContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeAdapterEStoreEObjectImpl;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreDOMAdapter;
import oracle.eclipse.tools.xml.model.util.NamespaceContextManager;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public abstract class AbstractControllerContext
implements IControllerContext,
IDependencyModelListener {
    protected WidgetAdapter _widgetAdapter;
    protected DataBindingContext _dataBindingContext;
    protected IFile _baseFile;
    protected ArtifactController _artifactController = ArtifactControllerFactory.getController();
    protected CopyOnWriteArrayList<IRefreshListener> _refreshListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private final UpdateEObjectViewerJob _job;
    private static final List<IHyperlink> NO_HYPERLINKS = Collections.emptyList();

    public AbstractControllerContext(WidgetAdapter widgetAdapter) {
        Assert.isNotNull((Object)widgetAdapter, (String)"widgetAdapter parameter cannot be null");
        this._widgetAdapter = widgetAdapter;
        this._artifactController.addListener((IDependencyModelListener)this);
        this._job = new UpdateEObjectViewerJob(this._isDisposed, this._refreshListeners);
        this._job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event_) {
                IStatus result = event_.getResult();
                if (result.getSeverity() != 0) {
                    Activator.getDefault().getLog().log(result);
                }
            }
        });
    }

    public AbstractControllerContext(WidgetAdapter widgetAdapter, IFile baseFile) {
        this(widgetAdapter);
        this.setBaseFile(baseFile);
    }

    @Override
    public WidgetAdapter getWidgetAdapter() {
        return this._widgetAdapter;
    }

    @Override
    public DataBindingContext getDataBindingContext() {
        if (this._dataBindingContext == null) {
            this._dataBindingContext = new EMFDataBindingContext();
        }
        return this._dataBindingContext;
    }

    protected final DataBindingContext internalGetDataBindingContext() {
        return this._dataBindingContext;
    }

    protected final void disposeDataBindingContext() {
        if (this._dataBindingContext != null) {
            this._dataBindingContext.dispose();
            this._dataBindingContext = null;
        }
    }

    @Override
    public IFile getBaseFile() {
        return this._baseFile;
    }

    @Override
    public void setBaseFile(IFile baseFile) {
        this._baseFile = baseFile;
    }

    protected ArtifactController getArtifactController() {
        return this._artifactController;
    }

    @Override
    public List<IHyperlink> getHyperlinks(EObject object, EAttribute feature) {
        IFile baseFile = this.getBaseFile();
        if (baseFile == null || !baseFile.isAccessible()) {
            return NO_HYPERLINKS;
        }
        ResourceArtifact artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)baseFile);
        INamespaceContext namespaceContext = NamespaceContextManager.getNamespaceContext((IFile)baseFile);
        if (!(object instanceof NodeAdapterEStoreEObjectImpl)) {
            return NO_HYPERLINKS;
        }
        List boundFeature = NodeEStoreDOMAdapter.INSTANCE.getBoundFeature((NodeAdapterEStoreEObjectImpl)object, feature, namespaceContext);
        if (boundFeature.size() == 0) {
            return NO_HYPERLINKS;
        }
        Node node = (Node)boundFeature.get(0);
        if (!(node instanceof IDOMAttr)) {
            return NO_HYPERLINKS;
        }
        IDOMAttr domAttr = (IDOMAttr)node;
        StructuredDocumentResourceLocationFactory fsdrlFactory = new StructuredDocumentResourceLocationFactory(baseFile);
        ResourceLocation resourceLocation = fsdrlFactory.createForAttributeValue(domAttr);
        Range range = resourceLocation.getRange();
        long offset = range.getOffset();
        IDOMModel structuredModel = domAttr.getModel();
        if (structuredModel.isDirty()) {
            return NO_HYPERLINKS;
        }
        IHyperlink[] hyperlinks = HyperlinkUtil.getLinksFromArtifact((IFile)baseFile, (IArtifact)artifact, (int)((int)offset), (IStructuredModel)structuredModel, (Node)domAttr, (ArtifactController)this.getArtifactController(), (boolean)false);
        return hyperlinks == null ? NO_HYPERLINKS : Arrays.asList(hyperlinks);
    }

    public final void modelChanged(DependencyModelEvent event) {
        switch (event.getType()) {
            case UPDATED: 
            case REFRESHED: {
                if (this._baseFile == null) break;
                this._job.schedule();
            }
        }
    }

    public void projectClosed(IProject project) {
    }

    @Override
    public void addRefreshListener(IRefreshListener listener) {
        Assert.isTrue((listener != null ? 1 : 0) != 0, (String)"listener cannot be null!");
        if (!this._refreshListeners.contains(listener)) {
            this._refreshListeners.add(listener);
        }
    }

    @Override
    public void removeRefreshListener(IRefreshListener listener) {
        Assert.isTrue((listener != null ? 1 : 0) != 0, (String)"listener cannot be null!");
        this._refreshListeners.remove(listener);
    }

    @Override
    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this._baseFile = null;
            this._refreshListeners.clear();
            this._artifactController.removeListener((IDependencyModelListener)this);
            this._widgetAdapter = null;
            this.disposeDataBindingContext();
        }
    }

    @Override
    public void selectionChanged(ISelection selection) {
    }

    @Override
    public abstract void afterUIUpdate();

    @Override
    public abstract void hookUpValidation(DataBindingContext var1);

    @Override
    public abstract void setErrorMessage(String var1);

    @Override
    public abstract boolean enableHyperlinks();

    @Override
    public abstract TagEditContext getTagEditContext();

    private static class UpdateEObjectViewerJob
    extends UIJob {
        private final AtomicBoolean _isDisposed;
        private final List<IRefreshListener> _listeners;

        public UpdateEObjectViewerJob(AtomicBoolean isDisposed, List<IRefreshListener> listeners) {
            super(Messages.AbstractControllerContext_0);
            this.setSystem(true);
            this._isDisposed = isDisposed;
            this._listeners = listeners;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!this._isDisposed.get()) {
                for (IRefreshListener listener : this._listeners) {
                    listener.refresh();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

