/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.model.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Scope implements Enumerator
{
    ROW(0, "row", "row"),
    COL(1, "col", "col"),
    ROWGROUP(2, "rowgroup", "rowgroup"),
    COLGROUP(3, "colgroup", "colgroup");

    public static final int ROW_VALUE = 0;
    public static final int COL_VALUE = 1;
    public static final int ROWGROUP_VALUE = 2;
    public static final int COLGROUP_VALUE = 3;
    private static final Scope[] VALUES_ARRAY;
    public static final List<Scope> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Scope[]{ROW, COL, ROWGROUP, COLGROUP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Scope get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Scope result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Scope getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Scope result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Scope get(int value) {
        switch (value) {
            case 0: {
                return ROW;
            }
            case 1: {
                return COL;
            }
            case 2: {
                return ROWGROUP;
            }
            case 3: {
                return COLGROUP;
            }
        }
        return null;
    }

    private Scope(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

