/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.html.model.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MethodType implements Enumerator
{
    GET(0, "get", "get"),
    POST(1, "post", "post");

    public static final int GET_VALUE = 0;
    public static final int POST_VALUE = 1;
    private static final MethodType[] VALUES_ARRAY;
    public static final List<MethodType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MethodType[]{GET, POST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MethodType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MethodType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MethodType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MethodType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MethodType get(int value) {
        switch (value) {
            case 0: {
                return GET;
            }
            case 1: {
                return POST;
            }
        }
        return null;
    }

    private MethodType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

