/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util.logger;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.TextFileWriter;

public class Logger
extends TextFileWriter {
    public static final String DEFAULT_ALLOWED = LOG_MESSAGE_TYPES.HINT.toString() + "|" + LOG_MESSAGE_TYPES.TIP.toString() + LOG_MESSAGE_TYPES.INFO.toString() + "|" + LOG_MESSAGE_TYPES.WARNING.toString() + "|" + LOG_MESSAGE_TYPES.ERROR.toString();
    private String allowed = DEFAULT_ALLOWED;
    private boolean silent = false;
    private static Logger DEFAULT = null;
    private int wrapLength = 89;
    private boolean wrapEnabled = true;
    private int prefixIndex = 9;

    public Logger() throws UnsupportedEncodingException {
        super(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true), true);
    }

    public Logger(PrintWriter pr, boolean autoCommit) throws UnsupportedEncodingException {
        super(pr, autoCommit);
    }

    public static Logger getDEFAULT() {
        return DEFAULT;
    }

    public static void setDEFAULT(Logger logger) {
        DEFAULT = logger;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public int tab(int to) {
        int diff = to - this.prefixIndex;
        this.prefixIndex = to;
        return diff;
    }

    public void shiftTab(int lastDiff) {
        this.prefixIndex -= lastDiff;
    }

    public void tab() {
        ++this.prefixIndex;
    }

    public void shiftTab() {
        --this.prefixIndex;
    }

    private String getPrefix(LOG_MESSAGE_TYPES type) {
        return CloudUtil.padChar(this.prefixIndex, ' ', "[" + type.toString() + "]", this.prefixIndex, false);
    }

    public void close() {
        this.flush();
        super.close();
    }

    public void printlnDebug(String s) {
        this.println(s, LOG_MESSAGE_TYPES.DEBUG);
    }

    public void printlnDebugI18n(String id) {
        this.printlnDebug(NLSUtil.localizeMessage(id));
    }

    public void printlnDebugI18n(String id, Object obj) {
        this.printlnDebug(NLSUtil.localizeMessage(id, obj));
    }

    public void printlnDebugI18n(String id, Object[] obj) {
        this.printlnDebug(NLSUtil.localizeMessage(id, obj));
    }

    public void addAllowed(LOG_MESSAGE_TYPES newType) {
        if (newType != null) {
            this.allowed = this.allowed + "|" + newType.toString();
        }
    }

    public void printlnWarningI18n(String id, Object[] vals) {
        this.printlnWarning(NLSUtil.localizeMessage(id, vals));
    }

    public void printlnWarningI18n(String id, Object val) {
        this.printlnWarning(NLSUtil.localizeMessage(id, val));
    }

    public void printlnWarningI18n(String id) {
        this.printlnWarning(NLSUtil.localizeMessage(id));
    }

    public void printlnInfoI18n(String id) {
        this.printlnInfo(NLSUtil.localizeMessage(id));
    }

    public void printlnI18n(String id, Object obj) {
        this.println(NLSUtil.localizeMessage(id, obj));
    }

    public void printlnI18n(String id, Object[] obj) {
        this.println(NLSUtil.localizeMessage(id, obj));
    }

    public void printlnInfoI18n(String id, Object obj) {
        this.printlnInfo(NLSUtil.localizeMessage(id, obj));
    }

    public void printlnInfoI18n(String id, Object obj0, Object obj1) {
        this.printlnInfo(NLSUtil.localizeMessage(id, new Object[]{obj0, obj1}));
    }

    public void printlnInfoI18n(String id, Object[] objs) {
        this.printlnInfo(NLSUtil.localizeMessage(id, objs));
    }

    public void printlnWarning(String s) {
        this.println(s, LOG_MESSAGE_TYPES.WARNING);
    }

    public void printlnTipI18n(String id) {
        this.println(NLSUtil.localizeMessage(id), LOG_MESSAGE_TYPES.TIP);
    }

    public void printlnTipI18n(String id, Object val) {
        this.println(NLSUtil.localizeMessage(id, val), LOG_MESSAGE_TYPES.TIP);
    }

    public void printlnTipI18n(String id, Object[] vals) {
        this.println(NLSUtil.localizeMessage(id, vals), LOG_MESSAGE_TYPES.TIP);
    }

    public void printlnErrorI18n(String id) {
        this.println(NLSUtil.localizeMessage(id), LOG_MESSAGE_TYPES.ERROR);
    }

    public void printlnErrorI18n(String id, Object obj) {
        this.println(NLSUtil.localizeMessage(id, obj), LOG_MESSAGE_TYPES.ERROR);
    }

    public void printlnErrorI18n(String id, Object obj1, Object obj2) {
        this.println(NLSUtil.localizeMessage(id, new Object[]{obj1, obj2}), LOG_MESSAGE_TYPES.ERROR);
    }

    public void printlnHintI18n(String id, Object obj1, Object obj2) {
        this.println(NLSUtil.localizeMessage(id, new Object[]{obj1, obj2}), LOG_MESSAGE_TYPES.HINT);
    }

    public void printlnWarningI18n(String id, Object obj1, Object obj2) {
        this.println(NLSUtil.localizeMessage(id, new Object[]{obj1, obj2}), LOG_MESSAGE_TYPES.WARNING);
    }

    public void printlnErrorI18n(String id, Object[] objs) {
        this.println(NLSUtil.localizeMessage(id, objs), LOG_MESSAGE_TYPES.ERROR);
    }

    public void printlnError(String s) {
        this.println(s, LOG_MESSAGE_TYPES.ERROR);
    }

    public void printlnHighlight() {
        this.printlnInfo("==================================================\n\n");
    }

    public void printlnInfo(String s) {
        this.println(s, LOG_MESSAGE_TYPES.INFO);
    }

    public void printlnFine(String s) {
        this.println(s, LOG_MESSAGE_TYPES.FINE);
    }

    public void printlnTip(String s) {
        this.println(s, LOG_MESSAGE_TYPES.TIP);
    }

    public void printlnHint(String s) {
        this.println(s, LOG_MESSAGE_TYPES.HINT);
    }

    public void printlnThrowable(Throwable t) {
        if (this.silent) {
            return;
        }
        if (this.allowed.contains(LOG_MESSAGE_TYPES.TRACE.toString())) {
            if (this.pStream != null) {
                t.printStackTrace(this.pStream);
                this.pStream.flush();
            } else {
                t.printStackTrace(this.pr);
                this.pr.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void println(String content, LOG_MESSAGE_TYPES prefix) {
        if (this.silent) {
            return;
        }
        if (prefix == null) {
            prefix = LOG_MESSAGE_TYPES.DEBUG;
        }
        if (!this.allowed.contains(prefix.toString())) {
            return;
        }
        if (this.wrapEnabled) {
            OrderedMap<String, String> orderedMap = this.initMapText();
            synchronized (orderedMap) {
                this.addMapText(this.getPrefix(prefix), content);
                this.endMapText(this.wrapLength);
            }
        } else {
            String[] lines;
            if (content == null) {
                content = "";
            }
            for (String l : lines = content.split("\n")) {
                this.println(this.getPrefix(prefix) + " : " + l);
            }
        }
        this.flush();
    }

    public void setAllowed(String allowed) {
        if (allowed == null) {
            allowed = "";
        }
        this.allowed = allowed;
        if (!allowed.contains(LOG_MESSAGE_TYPES.WARNING.toString())) {
            this.addAllowed(LOG_MESSAGE_TYPES.WARNING);
        }
        if (!allowed.contains(LOG_MESSAGE_TYPES.ERROR.toString())) {
            this.addAllowed(LOG_MESSAGE_TYPES.ERROR);
        }
    }

    public String getAllowed() {
        return this.allowed;
    }

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public int getWrapLength() {
        return this.wrapLength;
    }

    public static void main(String[] s) throws Exception {
        Logger.getDEFAULT().printlnWarning("This is my sample test to verify wrapping in logging. This is2244455 my sample test to verify wrapping in logging.This is my sample test to verify wrapping in logging. This is my sample test to verify wrapping in logging.");
    }

    public void setWrapEnabled(boolean wrapEnabled) {
        this.wrapEnabled = wrapEnabled;
    }

    public boolean isWrapEnabled() {
        return this.wrapEnabled;
    }

    static {
        try {
            DEFAULT = new Logger();
        }
        catch (UnsupportedEncodingException us) {
            throw new RuntimeException(us);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LOG_MESSAGE_TYPES {
        ERROR,
        WARNING,
        INFO,
        TIP,
        HINT,
        FINE,
        DEBUG,
        TRACE;

    }
}

