/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static final String ATTR_LINE_NUMBER = "ATTR_LINE_NUMBER_INTERnal";

    public static List<Element> getAllFirstChildElements(Element parent) {
        NodeList nodelist = null;
        ArrayList<Element> all = new ArrayList<Element>();
        if (parent != null) {
            nodelist = parent.getChildNodes();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                if (nodelist.item(i).getNodeType() != 1) continue;
                all.add((Element)nodelist.item(i));
            }
        }
        return all;
    }

    public static void collectElements(Element Immediateparent, QName name, List<Element> at) {
        List<Element> childs = XMLUtil.getAllFirstChildElements(Immediateparent);
        for (int i = 0; i < childs.size(); ++i) {
            QName childQName = new QName(childs.get(i).getNamespaceURI(), childs.get(i).getLocalName());
            if (childQName.equals(name)) {
                at.add(childs.get(i));
            }
            XMLUtil.collectElements(childs.get(i), name, at);
        }
    }

    public static String findNamespaceForPrefix(Element elem, String prefix) {
        Attr at = elem.getAttributeNode("xmlns:" + prefix);
        if (at != null) {
            return at.getValue();
        }
        if (elem.getParentNode() != null && Element.class.isAssignableFrom(elem.getParentNode().getClass())) {
            return XMLUtil.findNamespaceForPrefix((Element)elem.getParentNode(), prefix);
        }
        return null;
    }

    public static List<Element> getAllChildElements(Element parent, QName[] matches) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (matches != null) {
            for (QName match : matches) {
                XMLUtil.collectElements(parent, match, list);
            }
        }
        return list;
    }

    public static Element getFirstChildElement(Element parent, QName matche) {
        List<Element> list = XMLUtil.getAllFirstChildElements(parent, matche);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static List<Element> getAllFirstChildElements(Element parent, QName[] matches) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (matches != null) {
            for (QName match : matches) {
                list.addAll(XMLUtil.getAllFirstChildElements(parent, match));
            }
        }
        return list;
    }

    public static List<Element> getAllFirstChildElements(Element parent, QName match) {
        ArrayList<Element> list = new ArrayList<Element>();
        List<Element> childs = XMLUtil.getAllFirstChildElements(parent);
        for (Element importNode : childs) {
            if ((match.getNamespaceURI() != null ? !match.getNamespaceURI().equals(importNode.getNamespaceURI()) : importNode.getNamespaceURI() != null) || !importNode.getLocalName().equals(match.getLocalPart())) continue;
            list.add(importNode);
        }
        return list;
    }

    public static byte[] getNodeAs(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document getStreamAsDocument(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Logger.getDEFAULT().printlnDebug("XML Factory Used:" + factory.getClass().getName());
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(stream);
        return doc;
    }

    public static Document getStreamAsDocumentWithLineNumbers(InputStream is) throws Exception {
        Document doc;
        SAXParser parser;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            parser = factory.newSAXParser();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (Exception ParserConfigurationException) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", ParserConfigurationException);
        }
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private Locator locator;

            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element el = doc.createElementNS(uri, qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                el.setAttribute(XMLUtil.ATTR_LINE_NUMBER, String.valueOf(this.locator.getLineNumber()));
                elementStack.push(el);
            }

            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    el.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }

    public static QName findQNameFor(String collonForamt, Element elem) throws Exception {
        int index = collonForamt.indexOf(":");
        if (index < 0) {
            return new QName(elem.getNamespaceURI(), collonForamt);
        }
        String prefix = collonForamt.substring(0, index);
        return new QName(XMLUtil.findNamespaceForPrefix(elem, prefix), collonForamt.substring(index + 1, collonForamt.length()));
    }

    public static Document getFileAsDocument(String path) throws Exception {
        Logger.getDEFAULT().printlnDebug("Accessing:" + path);
        File reportFile = new File(path);
        if (reportFile.exists()) {
            if (reportFile.isFile()) {
                if (!reportFile.getAbsolutePath().startsWith("file:")) {
                    path = reportFile.toURI().toURL().toExternalForm();
                }
            } else {
                throw new Exception("File path should be a file:" + path);
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Logger.getDEFAULT().printlnDebug("XML Factory Used:" + factory.getClass().getName());
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        doc = builder.parse(path);
        return doc;
    }
}

