/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.display;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cloudlogic.javaservice.common.clibase.display.Grid;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell {
    private String content;
    private List<String> contents = null;
    private Grid innderGrid;
    boolean innerGridSerialized = false;
    private List<String> lines = null;
    private boolean centerAlign = false;
    private int verticalAlignExtraLineAdded = 0;

    public void verticalAlign(int maxlines) {
        if (this.lines != null && !this.lines.isEmpty() && this.verticalAlignExtraLineAdded == 0) {
            this.lines = new ArrayList<String>(this.lines);
            int width = this.lines.get(0).length();
            this.verticalAlignExtraLineAdded = maxlines - this.lines.size();
            int top = (maxlines - this.lines.size()) / 2;
            for (int i = 0; i < top; ++i) {
                this.lines.add(0, CloudUtil.padChar(width, ' ', "", width, true));
            }
            while (this.lines.size() < maxlines) {
                this.lines.add(CloudUtil.padChar(width, ' ', "", width, true));
            }
        }
    }

    public int getExtraWidth(int colWidth) {
        if (colWidth == 1) {
            return 0;
        }
        if (this.lines == null) {
            return colWidth - 1;
        }
        int extra = colWidth - 1;
        for (String l : this.lines) {
            int e = colWidth - l.length();
            if (e == 0) {
                return 0;
            }
            if (e >= extra) continue;
            extra = e;
        }
        return extra;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void cutWithWidth(int w, boolean verticalAlign) {
        this.lines = null;
        this.verticalAlignExtraLineAdded = 0;
        if (this.innderGrid != null) {
            this.setCenterAlign(true);
            if (!this.innderGrid.pack(w + 2, verticalAlign)) {
                this.innerGridSerialized = false;
                this.content = this.innderGrid.getRows().size() + " item(s). Grid not serialized inline. See below for details.";
            } else {
                int formedwidth = this.innderGrid.calculateTableWidth();
                int diff = w + 2 - formedwidth;
                if (diff > 0) {
                    HeaderCell hc = this.innderGrid.getColumns().getList().get(this.innderGrid.getColumns().getList().size() - 1).getValue();
                    hc.setWidth(hc.getWidth() + diff);
                    this.innderGrid.resetFormatting(verticalAlign);
                }
                this.lines = this.innderGrid.getAsListOfString(false);
                this.innerGridSerialized = true;
            }
        } else if (this.contents != null && !this.contents.isEmpty()) {
            this.lines = new ArrayList<String>();
            for (int i = 0; i < this.contents.size(); ++i) {
                this.lines.addAll(Arrays.asList(CloudUtil.convertToHelpText(this.contents.get(i), w, 0).split("\\n")));
                if (i == this.contents.size() - 1) continue;
                this.lines.add(CloudUtil.getString("-", w));
            }
        }
        if (this.content != null && this.lines == null) {
            String l = CloudUtil.convertToHelpText(this.content, w, 0);
            this.lines = Arrays.asList(l.split("\\n"));
        }
    }

    public int getLinesCount() {
        if (this.lines == null || this.lines.isEmpty()) {
            return 1;
        }
        return this.lines.size();
    }

    public int getOriginalLinesCount() {
        if (this.innderGrid != null && this.innerGridSerialized) {
            return this.getLinesCount();
        }
        if (this.contents != null && !this.contents.isEmpty()) {
            int count = this.contents.size() - 1;
            for (String s : this.contents) {
                count += Arrays.asList(s.split("\\n")).size();
            }
            return count - 1;
        }
        if (this.content != null) {
            return Arrays.asList(this.content.split("\\n")).size() - 1;
        }
        return 0;
    }

    protected String getJustLine(int l, int w) {
        String ret = "";
        if (this.lines != null && l < this.lines.size()) {
            ret = this.lines.get(l);
        }
        if (this.centerAlign && ret.length() < w - 1) {
            int withleftSpace = ret.length() + (w - ret.length()) / 2;
            ret = CloudUtil.padChar(withleftSpace, ' ', ret, withleftSpace, false);
        }
        return ret;
    }

    public String getLine(int l, int w) {
        String ret = this.getJustLine(l, w);
        return CloudUtil.padChar(w, ' ', ret, w, true);
    }

    public boolean hasLine(int l) {
        return this.lines != null && l < this.lines.size();
    }

    void setInnderGrid(Grid innderGrid) {
        this.innderGrid = innderGrid;
    }

    public Grid getInnderGrid() {
        return this.innderGrid;
    }

    public boolean isInnerGridSerialized() {
        return this.innerGridSerialized;
    }

    public void setCenterAlign(boolean centerAlign) {
        this.centerAlign = centerAlign;
    }

    public boolean isCenterAlign() {
        return this.centerAlign;
    }

    public int getVerticalAlignExtraLineAdded() {
        return this.verticalAlignExtraLineAdded;
    }

    public void setContents(List<String> contents) {
        this.contents = contents;
    }

    public List<String> getContents() {
        return this.contents;
    }
}

