/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.enterprise.deploy.spi.TargetModuleID;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloud.micro.api.impl.DeployJob;
import oracle.cloud.micro.api.impl.JobManager;
import oracle.cloud.paas.exception.UnknownResourceException;
import oracle.cloud.paas.model.ApplicationType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;

public class ReDeployJob
extends DeployJob {
    public ReDeployJob(String url, String user, byte[] pwd, WebLogicDeploymentManager deployManager, String group, String service, String appId, ApplicationType type, InputStream app, JobManager manager, boolean admin, LocalExtensionManager localextension) {
        super(url, user, pwd, deployManager, group, service, appId, type, app, manager, admin, localextension);
    }

    @Override
    public void deployAndSetProgressObject(File tempFile) throws Exception {
        DeploymentOptions options = new DeploymentOptions();
        options.setName(this.appId);
        options.setRemote(true);
        options.setAdminMode(this.adminMode);
        this.deployManager.enableFileUploads();
        List<TargetModuleID> list = ReDeployJob.getAllModulesWithAppId(this.appId, this.deployManager, this.localextension);
        if (list.isEmpty()) {
            throw new UnknownResourceException("Application :" + this.appId + "  not found in the specified target(s).");
        }
        this.progressObject = this.deployManager.redeploy(list.toArray(new TargetModuleID[0]), tempFile, (File)null, options);
    }

    @Override
    public String getJobName() {
        return "redeploy";
    }
}

