/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.ProcessUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class LocalExtensionManagerDefaultImpl
implements LocalExtensionManager {
    public static final String KEY_LOADBALANCER_BASE_URL = "KEY_LOADBALANCER_BASE_URL";
    public static final String KEY_DEPLOY_TARGETS = "KEY_DEPLOY_TARGETS";
    private String url = null;
    private List<String> targets = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalExtensionManagerDefaultImpl() {
        String localHome = System.getProperty("localextension.home");
        if (localHome == null) {
            localHome = ProcessUtil.getUSER_HOME();
        }
        File props = new File(localHome, "localextension.properties");
        FileInputStream fis = null;
        try {
            if (props.exists()) {
                if (!props.isFile()) {
                    throw new Exception("Not a file.");
                }
                fis = new FileInputStream(props);
                Properties p = new Properties();
                p.load(fis);
                this.url = p.getProperty(KEY_LOADBALANCER_BASE_URL);
                String ts = p.getProperty(KEY_DEPLOY_TARGETS);
                if (ts != null) {
                    this.targets = CloudUtil.parseString(ts, ",", true);
                }
            }
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnThrowable(e);
            Logger.getDEFAULT().printlnWarning("Unable to load local deployment configurations from:" + props.getAbsolutePath() + " ->Cause:" + e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    Logger.getDEFAULT().printlnThrowable(e);
                }
            }
        }
    }

    @Override
    public String getLoadbalancerUrl() {
        return this.url;
    }

    @Override
    public List<String> getDeployTargets(String app) {
        return this.targets;
    }
}

