/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.cloud.micro.api.impl.AbstractJob;
import oracle.cloud.paas.exception.ResourceBusyException;
import oracle.cloud.paas.model.Job;

public class JobManager
extends ThreadPoolExecutor {
    private Map<String, AbstractJob> jobs = new HashMap<String, AbstractJob>();
    private Map<String, SoftReference<AbstractJob>> doneJobs = new HashMap<String, SoftReference<AbstractJob>>();
    private static final int INITIAL_JOB_ID = 100;
    private static final int TOTAL_JOBS_ALLOWED = 100;
    private int pointer = 0;

    public JobManager() {
        super(1, 100, 10L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractJob findActiveJob() {
        Map<String, AbstractJob> map = this.jobs;
        synchronized (map) {
            Iterator<AbstractJob> i$ = this.jobs.values().iterator();
            if (i$.hasNext()) {
                AbstractJob job = i$.next();
                return job;
            }
        }
        return null;
    }

    public void lockInstance() {
        AbstractJob job = this.findActiveJob();
        if (job != null) {
            if (job.getJobType().getApplicationName() == null) {
                job.waitWhileRunning();
            } else {
                throw ResourceBusyException.createActiveJobException((String)job.getJobType().getApplicationName(), (Job)job.getJobType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initJob(AbstractJob job) {
        Map<String, AbstractJob> map = this.jobs;
        synchronized (map) {
            this.lockInstance();
            for (int i = 0; i < 100; ++i) {
                String id = String.valueOf(100 + (this.pointer + i) % 100);
                AbstractJob type = this.jobs.get(id);
                if (type != null) continue;
                ++this.pointer;
                Job t = new Job();
                t.setJobId(id);
                job.setType(t);
                this.jobs.put(id, job);
                return;
            }
        }
        throw new RuntimeException("Can't create new job. The system already has allowed number of jobs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDone(AbstractJob job) {
        Map<String, AbstractJob> map = this.jobs;
        synchronized (map) {
            Map<String, SoftReference<AbstractJob>> map2 = this.doneJobs;
            synchronized (map2) {
                String jobId = job.getJobType().getJobId();
                this.doneJobs.put(jobId, new SoftReference<AbstractJob>(this.jobs.remove(jobId)));
            }
        }
    }

    public AbstractJob findJob(String jobId) {
        AbstractJob job = this.jobs.get(jobId);
        if (job == null) {
            SoftReference<AbstractJob> ref = this.doneJobs.get(jobId);
            if (ref == null) {
                return null;
            }
            return ref.get();
        }
        return job;
    }

    public Collection<AbstractJob> getAllRunningJobs() {
        return this.jobs.values();
    }

    public List<Job> getAllFinishedJobTypes() {
        ArrayList<Job> list = new ArrayList<Job>();
        for (SoftReference<AbstractJob> w : this.doneJobs.values()) {
            AbstractJob j = w.get();
            if (j == null) continue;
            list.add(j.getJobType());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getAllJobTypes() {
        Map<String, AbstractJob> map = this.jobs;
        synchronized (map) {
            Map<String, SoftReference<AbstractJob>> map2 = this.doneJobs;
            synchronized (map2) {
                ArrayList<Job> list = new ArrayList<Job>();
                for (AbstractJob j : this.getAllRunningJobs()) {
                    list.add(j.getJobType());
                }
                list.addAll(this.getAllFinishedJobTypes());
                return list;
            }
        }
    }
}

