/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.micro.api.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.enterprise.deploy.spi.Target;
import oracle.cloud.localextension.api.LocalExtensionManager;
import oracle.cloud.micro.api.impl.AbstractJob;
import oracle.cloud.micro.api.impl.JobManager;
import oracle.cloud.micro.api.impl.LogWithContent;
import oracle.cloud.paas.model.ApplicationType;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.common.utils.ApplicationPreProcessor;
import oracle.cloudlogic.javaservice.common.utils.ApplicationValidator;
import oracle.cloudlogic.javaservice.common.utils.RemotePreProcessor;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;

public class DeployJob
extends AbstractJob {
    protected String user;
    protected byte[] pwd;
    protected String url;
    protected WebLogicDeploymentManager deployManager;
    protected InputStream app;
    protected File appFile;
    protected String appId;
    protected ApplicationType applicationType;
    protected boolean adminMode = false;
    protected static ServiceLoader<ApplicationValidator> validatorLoader = null;
    protected static final List<ApplicationValidator> validators = new ArrayList<ApplicationValidator>();
    protected static ServiceLoader<ApplicationPreProcessor> preporocessorLoader = null;
    protected static final List<ApplicationPreProcessor> preporocessors = new ArrayList<ApplicationPreProcessor>();

    public DeployJob(String url, String user, byte[] pwd, WebLogicDeploymentManager deployManager, String group, String service, String appId, ApplicationType type, InputStream app, JobManager manager, boolean admin, LocalExtensionManager extensionManager) {
        super(group, service, manager, extensionManager);
        this.deployManager = deployManager;
        this.appId = appId;
        this.app = app;
        this.applicationType = type;
        this.adminMode = admin;
        this.user = user;
        this.url = url;
        this.pwd = pwd;
        this.type.setApplicationName(appId);
        try {
            this.writeToFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deployAndSetProgressObject(File tempFile) throws Exception {
        Target[] deployTargets = AbstractJob.getDeployableTargets(this.deployManager, this.appId, this.localextension);
        DeploymentOptions options = new DeploymentOptions();
        options.setName(this.appId);
        options.setRemote(true);
        options.setAdminMode(this.adminMode);
        this.deployManager.enableFileUploads();
        this.progressObject = this.deployManager.deploy(deployTargets, tempFile, null, options);
    }

    public void writeToFile() throws Exception {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File dir = new File(tempDir, "cloud");
        dir.mkdirs();
        this.appFile = new File(dir.getCanonicalPath(), this.getApplicationFileName());
        DeployJob.writeToFile(this.appFile, this.app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preProcess() throws Exception {
        for (ApplicationValidator p : validators) {
            LogWithContent log = new LogWithContent();
            log.getLog().setContentType(p.getLogContentType());
            log.getLog().setName(p.getName());
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            FileInputStream file = null;
            try {
                this.addLog(log);
                file = new FileInputStream(this.appFile);
                p.process(file, this.getApplicationFileName(), ba, null);
            }
            catch (Throwable e) {
                throw new Exception("Deployment pre-processing has failed", e);
            }
            finally {
                ba.flush();
                log.setContent(ba.toByteArray());
                if (file == null) continue;
                ((InputStream)file).close();
            }
        }
        String source = this.appFile.getAbsolutePath();
        for (ApplicationPreProcessor pre : preporocessors) {
            if (!RemotePreProcessor.class.isAssignableFrom(pre.getClass())) continue;
            RemotePreProcessor remote = (RemotePreProcessor)((Object)pre);
            remote.setConnectionInfo(this.url, this.user, this.pwd, null);
            LogWithContent log = new LogWithContent();
            log.getLog().setContentType(pre.getLogContentType());
            log.getLog().setName(pre.getName());
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            try {
                this.addLog(log);
                Logger.getDEFAULT().printlnDebug("--> Pre-processer " + pre.getName() + " " + pre.getClass() + " loaded from:" + pre.getClass().getProtectionDomain().getCodeSource().getLocation().toString());
                source = pre.process(source, new File(this.appFile.getParentFile(), "tmp").getAbsolutePath(), ba, null);
            }
            catch (Throwable e) {
                throw new Exception("Deployment pre-processing has failed", e);
            }
            finally {
                ba.flush();
                log.setContent(ba.toByteArray());
            }
        }
        this.appFile = new File(source);
    }

    protected String getApplicationFileName() {
        return this.appId + "." + this.applicationType.toString().toLowerCase();
    }

    @Override
    public void postProcess() {
        Logger.getDEFAULT().printlnDebug("Deleting at:" + this.appFile.getAbsolutePath());
        this.appFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Exception {
        this.deployAndSetProgressObject(this.appFile);
        this.waitUntilProgressObjectDone();
        if (this.progressObject.getDeploymentStatus().isFailed()) {
            throw new Exception("Deployment failed:" + this.progressObject.getDeploymentStatus().getMessage());
        }
    }

    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getJobName() {
        return "deploy";
    }

    static {
        try {
            validatorLoader = ServiceLoader.load(ApplicationValidator.class, ApplicationValidator.class.getClassLoader());
            validatorLoader.reload();
            Iterator<ApplicationValidator> it = validatorLoader.iterator();
            while (it.hasNext()) {
                try {
                    validators.add(it.next());
                }
                catch (Throwable cce) {
                    if (CloudUtil.isCausedBy(cce, ClassCastException.class)) continue;
                    throw new RuntimeException(cce);
                }
            }
            if (validators.isEmpty()) {
                validatorLoader = ServiceLoader.load(ApplicationValidator.class);
                validatorLoader.reload();
                it = validatorLoader.iterator();
                while (it.hasNext()) {
                    try {
                        validators.add(it.next());
                    }
                    catch (Throwable cce) {
                        if (CloudUtil.isCausedBy(cce, ClassCastException.class)) continue;
                        throw new RuntimeException(cce);
                    }
                }
            }
            Collections.sort(validators, new Comparator<ApplicationValidator>(){

                @Override
                public int compare(ApplicationValidator one, ApplicationValidator second) {
                    return new Float(one.getProcessingOrder()).compareTo(new Float(second.getProcessingOrder()));
                }
            });
            preporocessorLoader = ServiceLoader.load(ApplicationPreProcessor.class, ApplicationPreProcessor.class.getClassLoader());
            preporocessorLoader.reload();
            Iterator<ApplicationPreProcessor> itpre = preporocessorLoader.iterator();
            while (itpre.hasNext()) {
                try {
                    preporocessors.add(itpre.next());
                }
                catch (Throwable cce) {
                    if (CloudUtil.isCausedBy(cce, ClassCastException.class)) continue;
                    throw new RuntimeException(cce);
                }
            }
            if (preporocessors.isEmpty()) {
                preporocessorLoader = ServiceLoader.load(ApplicationPreProcessor.class);
                validatorLoader.reload();
                itpre = preporocessors.iterator();
                while (itpre.hasNext()) {
                    try {
                        preporocessors.add(itpre.next());
                    }
                    catch (Throwable cce) {
                        if (CloudUtil.isCausedBy(cce, ClassCastException.class)) continue;
                        throw new RuntimeException(cce);
                    }
                }
            }
            Collections.sort(preporocessors, new Comparator<ApplicationPreProcessor>(){

                @Override
                public int compare(ApplicationPreProcessor one, ApplicationPreProcessor second) {
                    return new Float(one.getProcessingOrder()).compareTo(new Float(second.getProcessingOrder()));
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }
}

