/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.util;

import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowOp;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;

public class UniqueTaskFlowName {
    private static final String UNBOUNDED_TASK_FLOW_NAME = "adfc-config";

    public static String generateUniqueName(CreateWorkspaceFileOp operation) {
        String newFileName;
        String name;
        Path folderPath = (Path)operation.getFolder().content();
        String fileName = operation.getFile().text();
        if (folderPath == null || fileName == null) {
            return null;
        }
        if (operation instanceof ICreateTaskFlowOp) {
            ICreateTaskFlowOp tfOperation = (ICreateTaskFlowOp)operation;
            fileName = tfOperation.getBoundedTaskFlow().content() == null ? UNBOUNDED_TASK_FLOW_NAME : "task-flow-definition";
        }
        fileName = fileName.trim();
        String extension = "";
        if (fileName.indexOf(46) == -1) {
            name = fileName;
            ValueProperty property = operation.property(CreateWorkspaceFileOp.PROP_FILE).definition();
            FileExtensions fileExtensionsAnnotation = (FileExtensions)property.getAnnotation(FileExtensions.class);
            if (fileExtensionsAnnotation != null) {
                extension = fileExtensionsAnnotation.expr();
            }
        } else {
            int pos = fileName.indexOf(46);
            name = fileName.substring(0, pos);
            extension = fileName.substring(pos + 1);
        }
        int index = 2;
        String newName = name;
        while (true) {
            newFileName = String.valueOf(newName) + "." + extension;
            Path newFilePath = folderPath.append(newFileName);
            if (ResourcesPlugin.getWorkspace().getRoot().findMember(PathBridge.create((Path)newFilePath)) == null) break;
            newName = String.valueOf(name) + index++;
        }
        return newFileName;
    }
}

