/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.util;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IStaticTaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowCallComponent;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.model.internal.AvailableActivitiesService;
import oracle.eclipse.tools.adf.controller.model.internal.TemplateService;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.modeling.Path;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class TaskFlowUtil {
    private static final String ADFC_CONFIG_ELEMENT_NAME = "adfc-config";
    private static final String TASK_FLOW_DEFINITION_ELEMENT_NAME = "task-flow-definition";
    private static final String TASK_FLOW_TEMPLATE_ELEMENT_NAME = "task-flow-template";

    private TaskFlowUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TaskFlowType getTaskFlowType(IFile file) {
        if (file == null) return null;
        if (!"xml".equalsIgnoreCase(file.getFileExtension())) return null;
        if (!file.isAccessible()) return null;
        InputStream is = null;
        try {
            try {
                is = file.getContents();
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                SAXParser parser = parserFactory.newSAXParser();
                InputSource source = new InputSource(is);
                TaskFlowHandler taskFlowHandler = new TaskFlowHandler();
                parser.parse(source, (DefaultHandler)taskFlowHandler);
                if (!taskFlowHandler.isTaskFlow()) return null;
                if (taskFlowHandler.isBoundedTaskFlow()) {
                    TaskFlowType taskFlowType = TaskFlowType.Bounded;
                    return taskFlowType;
                }
                if (taskFlowHandler.isTaskFlowTemplate()) {
                    TaskFlowType taskFlowType = TaskFlowType.Template;
                    return taskFlowType;
                }
                TaskFlowType taskFlowType = TaskFlowType.Unbounded;
                return taskFlowType;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LoggingService.traceException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static IFile getReferencedTaskFlowFile(ITaskFlowCallComponent taskFlowCallComponent) {
        IFile file;
        TaskFlowType taskFlowType;
        IPath containerPath;
        IPath path;
        IResource resource;
        IContainer webContainer;
        IProject project;
        IStaticTaskFlowReference reference;
        ITaskFlowReference taskFlowReference;
        if (taskFlowCallComponent != null && (taskFlowReference = (ITaskFlowReference)taskFlowCallComponent.getTaskFlowReference().content()) instanceof IStaticTaskFlowReference && (reference = (IStaticTaskFlowReference)taskFlowReference).getDocument().content() != null && (project = (IProject)taskFlowCallComponent.adapt(IProject.class)) != null && (webContainer = ProjectUtil.getWebContentFolderIResource(project)) != null && (resource = project.findMember(path = (containerPath = webContainer.getProjectRelativePath()).append(((Path)reference.getDocument().content()).toString()))) instanceof IFile && ((taskFlowType = TaskFlowUtil.getTaskFlowType(file = (IFile)resource)) == TaskFlowType.Bounded || taskFlowType == TaskFlowType.Unbounded || taskFlowType == TaskFlowType.Template)) {
            return file;
        }
        return null;
    }

    public static boolean isBoundedTaskFlow(ITaskFlow taskFlow) {
        if (taskFlow == null) {
            throw new IllegalArgumentException();
        }
        ITaskFlowFile tfRoot = (ITaskFlowFile)taskFlow.nearest(ITaskFlowFile.class);
        return tfRoot.getTaskFlowType().content() == TaskFlowType.Bounded;
    }

    public static boolean isUnboundedTaskFlow(ITaskFlow taskFlow) {
        if (taskFlow == null) {
            throw new IllegalArgumentException();
        }
        ITaskFlowFile tfRoot = (ITaskFlowFile)taskFlow.nearest(ITaskFlowFile.class);
        return tfRoot.getTaskFlowType().content() == TaskFlowType.Unbounded;
    }

    public static boolean isTaskFlowTemplate(ITaskFlow taskFlow) {
        if (taskFlow == null) {
            throw new IllegalArgumentException();
        }
        ITaskFlowFile tfRoot = (ITaskFlowFile)taskFlow.nearest(ITaskFlowFile.class);
        return tfRoot.getTaskFlowType().content() == TaskFlowType.Template;
    }

    public static String getNextActivityId(String prefix, ITaskFlow taskFlow) {
        AvailableActivitiesService service = (AvailableActivitiesService)taskFlow.getDefaultActivity().service(AvailableActivitiesService.class);
        Set availableIds = service.values();
        int[] intArr = new int[availableIds.size()];
        int numInts = 0;
        int nextInt = -1;
        for (String id : availableIds) {
            if (id == null || !id.startsWith(prefix)) continue;
            int i = -1;
            if (id.length() == prefix.length()) {
                i = 0;
            } else {
                String suffix = id.substring(prefix.length());
                try {
                    i = Integer.valueOf(suffix);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (i == -1) continue;
            intArr[numInts++] = i;
        }
        Arrays.sort(intArr, 0, numInts);
        int i = 0;
        while (i < numInts) {
            if (intArr[i] != i) {
                nextInt = i;
                break;
            }
            ++i;
        }
        if (nextInt == -1) {
            nextInt = numInts == 0 ? 0 : intArr[numInts - 1] + 1;
        }
        return String.valueOf(prefix) + nextInt;
    }

    public static IFile getActivityFilePath(ITaskFlow taskFlow, String activityId) {
        Set<String> importedIds;
        if (activityId == null || activityId.length() == 0) {
            return null;
        }
        for (IActivity activity : taskFlow.getActivities()) {
            String activityId2 = (String)activity.getActivityId().content();
            if (activityId2 == null || !activityId2.equals(activityId)) continue;
            IFile file = (IFile)taskFlow.adapt(IFile.class);
            return file;
        }
        TemplateService templateService = (TemplateService)taskFlow.getTemplateReference().service(TemplateService.class);
        if (templateService != null && (importedIds = templateService.getImportedActivityIds()) != null && importedIds.contains(activityId)) {
            return templateService.getTemplateActivityFilePath(activityId);
        }
        return null;
    }

    private static final class TaskFlowHandler
    extends DefaultHandler {
        private boolean isTaskFlow = false;
        private boolean isBoundedTaskFlow = false;
        private boolean isTaskFlowTemplate = false;

        private TaskFlowHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals(TaskFlowUtil.ADFC_CONFIG_ELEMENT_NAME) || qName.equals(TaskFlowUtil.ADFC_CONFIG_ELEMENT_NAME)) {
                this.isTaskFlow = true;
            } else if (this.isTaskFlow && (localName.equals(TaskFlowUtil.TASK_FLOW_DEFINITION_ELEMENT_NAME) || qName.equals(TaskFlowUtil.TASK_FLOW_DEFINITION_ELEMENT_NAME))) {
                this.isBoundedTaskFlow = true;
            } else if (this.isTaskFlow && (localName.equals(TaskFlowUtil.TASK_FLOW_TEMPLATE_ELEMENT_NAME) || qName.equals(TaskFlowUtil.TASK_FLOW_TEMPLATE_ELEMENT_NAME))) {
                this.isTaskFlowTemplate = true;
            }
        }

        public boolean isTaskFlow() {
            return this.isTaskFlow;
        }

        public boolean isBoundedTaskFlow() {
            return this.isBoundedTaskFlow;
        }

        public boolean isTaskFlowTemplate() {
            return this.isTaskFlowTemplate;
        }
    }
}

