/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.operations.internal;

import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.operations.IBoundedTaskFlowOp;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowOp;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowTemplateOp;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;

public class TemplateListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        try {
            IBoundedTaskFlowOp boundedOp = null;
            ICreateTaskFlowTemplateOp templateOp = (ICreateTaskFlowTemplateOp)event.property().element().nearest(ICreateTaskFlowTemplateOp.class);
            if (templateOp != null) {
                boundedOp = templateOp;
            } else {
                ICreateTaskFlowOp taskFlowOp = (ICreateTaskFlowOp)event.property().element().nearest(ICreateTaskFlowOp.class);
                if (taskFlowOp.getBoundedTaskFlow().element() != null) {
                    boundedOp = (IBoundedTaskFlowOp)taskFlowOp.getBoundedTaskFlow().content();
                }
            }
            if (boundedOp.getDocument().content() != null) {
                TaskFlowType tfType;
                IFile templateFile;
                Path templatePath = (Path)boundedOp.getDocument().content();
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(templatePath.toPortableString());
                if (resource instanceof IFile && (templateFile = (IFile)resource).exists() && (tfType = TaskFlowUtil.getTaskFlowType(templateFile)) == TaskFlowType.Template) {
                    ITaskFlow referedTaskFlow = TaskFlowFactory.createTaskFlow(templateFile);
                    String referedTaskFlowId = (String)referedTaskFlow.getTaskFlowId().content();
                    boundedOp.setTemplateTaskFlowId(referedTaskFlowId);
                    if (boundedOp != null) {
                        if (((Boolean)referedTaskFlow.isUsePageFragments().content()).booleanValue()) {
                            boundedOp.setCreateWithPageFragments(true);
                        } else {
                            boundedOp.setCreateWithPageFragments(false);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
        }
    }
}

