/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.operations.internal;

import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowOp;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowTemplateOp;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;

public class CreateTaskFlowTemplateOpTemplateValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CreateTaskFlowTemplateOpTemplateValidator.this.refresh();
            }
        };
        CreateWorkspaceFileOp createOp = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
        createOp.attach(this.listener, "Folder");
    }

    protected Status compute() {
        IResource resource;
        Value value = (Value)this.context(Value.class);
        Path path = (Path)value.content();
        Path folderPath = null;
        ICreateTaskFlowTemplateOp createOp = (ICreateTaskFlowTemplateOp)((Element)this.context(Element.class)).nearest(ICreateTaskFlowTemplateOp.class);
        if (createOp != null) {
            folderPath = (Path)createOp.getFolder().content();
        } else {
            ICreateTaskFlowOp createOp2 = (ICreateTaskFlowOp)((Element)this.context(Element.class)).nearest(ICreateTaskFlowOp.class);
            if (createOp2 != null) {
                folderPath = (Path)createOp2.getFolder().content();
            }
        }
        IProject templateProject = null;
        if (folderPath != null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath.toPortableString());
            templateProject = resource.getProject();
        }
        if (path != null) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString());
            if (resource == null) {
                String msg = NLS.bind((String)Resources.templateDoesNotExist, (Object)path.toPortableString());
                return Status.createErrorStatus((String)msg);
            }
            if (resource instanceof IFile) {
                IProject project = resource.getProject();
                if (project != null && templateProject != null && project != templateProject) {
                    return Status.createErrorStatus((String)Resources.differentProject);
                }
                IFile file = (IFile)resource;
                if (TaskFlowUtil.getTaskFlowType(file) != TaskFlowType.Template) {
                    String msg = NLS.bind((String)Resources.templateNotValid, (Object)file.getName());
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            CreateWorkspaceFileOp createOp = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            createOp.detach(this.listener, "Folder");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String differentProject;
        public static String templateNotValid;
        public static String templateDoesNotExist;

        static {
            Resources.initializeMessages((String)CreateTaskFlowTemplateOpTemplateValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

