/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.operations.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.ITemplateReference;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.operations.ICreateTaskFlowTemplateOp;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class CreateTaskFlowTemplateOpMethods {
    public static Status execute(ICreateTaskFlowTemplateOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        try {
            IFile newFileHandle = (IFile)operation.getFile().resolve();
            try {
                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                if (newFileHandle.exists()) {
                    newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                ITaskFlowFile model = TaskFlowFactory.createTaskFlowFile(newFileHandle);
                model.setTaskFlowType(TaskFlowType.Template);
                ((XmlResource)model.adapt(XmlResource.class)).getXmlElement(true);
                ITaskFlow newTf = model.getTaskFlow();
                if (operation.getDocument().content() != null) {
                    TaskFlowType tfType;
                    Path templatePath = (Path)operation.getDocument().content();
                    IFile templateFile = ResourcesPlugin.getWorkspace().getRoot().getFile(PathBridge.create((Path)templatePath));
                    if (templateFile.exists() && (tfType = TaskFlowUtil.getTaskFlowType(templateFile)) == TaskFlowType.Template) {
                        if (((Boolean)operation.isUpdateWhenTemplateChange().content()).booleanValue()) {
                            IProject project = templateFile.getProject();
                            IPath relativePath = templateFile.getProjectRelativePath();
                            IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource(project);
                            if (underlyingFolder != null) {
                                IPath webContentPath = underlyingFolder.getProjectRelativePath();
                                relativePath = relativePath.makeRelativeTo(webContentPath);
                                templatePath = new Path("/" + relativePath.toPortableString());
                            }
                            ITemplateReference newTemplateRef = (ITemplateReference)newTf.getTemplateReference().content(true);
                            newTemplateRef.setDocument(templatePath);
                            newTemplateRef.setId((String)operation.getTemplateTaskFlowId().content());
                            newTf.setUsePageFragments((Boolean)operation.isCreateWithPageFragments().content());
                            newTf.setTrain((Boolean)operation.isCreateTrain().content());
                        } else {
                            ITaskFlow referedTaskFlow = TaskFlowFactory.createTaskFlow(templateFile);
                            newTf.copy(referedTaskFlow);
                        }
                        newTf.setTaskFlowId((String)operation.getId().content());
                    }
                } else {
                    newTf.setTaskFlowId((String)operation.getId().content());
                    newTf.setUsePageFragments((Boolean)operation.isCreateWithPageFragments().content());
                    newTf.setTrain((Boolean)operation.isCreateTrain().content());
                }
                model.resource().save();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateTaskFlowTemplateOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

