/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.operations.internal;

import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class CreateTaskFlowTemplateOpFolderValidator
extends ValidationService {
    protected Status compute() {
        IResource resource;
        Value value = (Value)this.context(Value.class);
        Path path = (Path)value.content();
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString())) != null && resource instanceof IContainer) {
            IPath folderPath;
            IPath webContentPath;
            IProject project = resource.getProject();
            Project oepeProj = (Project)project.getAdapter(Project.class);
            if (oepeProj == null || oepeProj.getTechnologyExtensionById("adf.web") == null) {
                String msg = NLS.bind((String)Resources.projectNotAnADFWeb, (Object)project.getName());
                return Status.createErrorStatus((String)msg);
            }
            IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource(project);
            if (underlyingFolder != null && !(webContentPath = underlyingFolder.getProjectRelativePath()).isPrefixOf(folderPath = resource.getProjectRelativePath())) {
                return Status.createErrorStatus((String)Resources.notContainedInWebContentFolder);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String projectNotAnADFWeb;
        public static String notContainedInWebContentFolder;

        static {
            Resources.initializeMessages((String)CreateTaskFlowTemplateOpFolderValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

