/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITemplateReference;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.Service;

public class TemplateService
extends Service {
    private HashMap<String, IFile> importedActivityMap;
    private HashMap<String, IActivity> importedActivityObjMap;
    private HashSet<IFile> referencedTemplateFiles;
    private IProject project;
    private ResourceChangeListener resourceChangeListener;

    protected void init() {
        super.init();
        this.project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class);
        this.importedActivityMap = new HashMap();
        this.importedActivityObjMap = new HashMap();
        this.referencedTemplateFiles = new HashSet();
        this.refreshImportedActivityIds();
        this.resourceChangeListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
    }

    public Set<String> getImportedActivityIds() {
        return this.importedActivityMap.keySet();
    }

    public IFile getTemplateActivityFilePath(String activityId) {
        return this.importedActivityMap.get(activityId);
    }

    public IActivity getTemplateActivity(String activityId) {
        return this.importedActivityObjMap.get(activityId);
    }

    public void refreshImportedActivityIds() {
        boolean filesChanged;
        boolean changed;
        HashMap<String, IFile> referencedActivityMap = new HashMap<String, IFile>();
        HashMap<String, IActivity> referencedActivityObjMap = new HashMap<String, IActivity>();
        HashSet<IFile> referencedTemplateFiles = new HashSet<IFile>();
        ITaskFlow tf = (ITaskFlow)this.context(Element.class);
        ITemplateReference templateRef = (ITemplateReference)tf.getTemplateReference().content();
        this.addActivityIdsFromTemplate(referencedTemplateFiles, referencedActivityMap, referencedActivityObjMap, templateRef);
        Set<String> oldSet = this.importedActivityMap.keySet();
        Set<String> newSet = referencedActivityMap.keySet();
        boolean bl = changed = !oldSet.containsAll(newSet) || !newSet.containsAll(oldSet);
        if (changed) {
            this.importedActivityMap.clear();
            this.importedActivityMap.putAll(referencedActivityMap);
            this.importedActivityObjMap.clear();
            this.importedActivityObjMap.putAll(referencedActivityObjMap);
            this.broadcast();
        }
        boolean bl2 = filesChanged = !this.referencedTemplateFiles.containsAll(referencedTemplateFiles) || !referencedTemplateFiles.containsAll(this.referencedTemplateFiles);
        if (filesChanged) {
            this.referencedTemplateFiles.clear();
            this.referencedTemplateFiles.addAll(referencedTemplateFiles);
        }
    }

    private void addActivityIdsFromTemplate(Set<IFile> referencedFiles, HashMap<String, IFile> idMap, HashMap<String, IActivity> objMap, ITemplateReference templateRef) {
        IPath path;
        IFolder folder;
        IFile file;
        IContainer underlyingFolder;
        if (this.project == null || templateRef == null || templateRef.getDocument().content() == null) {
            return;
        }
        String pathStr = ((org.eclipse.sapphire.modeling.Path)templateRef.getDocument().content()).toString();
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        if ((underlyingFolder = ProjectUtil.getWebContentFolderIResource(this.project)) != null && (file = (folder = this.project.getFolder(path = underlyingFolder.getProjectRelativePath())).getFile((IPath)new Path(pathStr))).exists()) {
            referencedFiles.add(file);
            ITaskFlow tfTemplate = TaskFlowFactory.createTaskFlow(file);
            if (tfTemplate != null) {
                for (IActivity activity : tfTemplate.getActivities()) {
                    if (activity.getActivityId().content() == null) continue;
                    idMap.put((String)activity.getActivityId().content(), file);
                    objMap.put((String)activity.getActivityId().content(), activity);
                }
                ITemplateReference parentTemplate = (ITemplateReference)tfTemplate.getTemplateReference().content();
                this.addActivityIdsFromTemplate(referencedFiles, idMap, objMap, parentTemplate);
            }
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta docDelta;
            IResourceDelta delta = event.getDelta();
            if (delta == null || TemplateService.this.project == null) {
                return;
            }
            if (event.getType() == 1 && (docDelta = delta.findMember(TemplateService.this.project.getFullPath())) != null) {
                IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 2: 
                                case 4: {
                                    IFile changedFile = (IFile)resource;
                                    if (!TemplateService.this.referencedTemplateFiles.contains(changedFile)) break;
                                    TemplateService.this.refreshImportedActivityIds();
                                }
                            }
                        }
                        return true;
                    }
                };
                try {
                    docDelta.accept(visitor);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (CoreException)e);
                }
            }
        }
    }
}

