/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class TaskFlowTemplateValidator
extends ValidationService {
    protected Status compute() {
        IContainer underlyingFolder;
        IProject project;
        Value value = (Value)this.context(Value.class);
        if (value.content() != null && (project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class)) != null && (underlyingFolder = ProjectUtil.getWebContentFolderIResource(project)) != null) {
            IPath path = underlyingFolder.getProjectRelativePath();
            IPath filePath = path.append(((Path)value.content()).toString());
            IFile file = project.getFile(filePath);
            if (!file.exists()) {
                String msg = NLS.bind((String)Resources.refereceMissingMsg, (Object)((Path)value.content()).toString());
                return Status.createErrorStatus((String)msg);
            }
            TaskFlowType type = TaskFlowUtil.getTaskFlowType(file);
            if (type == null || type != TaskFlowType.Template) {
                String msg = NLS.bind((String)Resources.needsTemplateReference, (Object)((Path)value.content()).toString());
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String refereceMissingMsg;
        public static String needsTemplateReference;

        static {
            Resources.initializeMessages((String)TaskFlowTemplateValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

