/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.TaskFlowProxy;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;

public class TaskFlowMethods {
    private static Map<IFile, ITaskFlowContext> contextMap = new HashMap<IFile, ITaskFlowContext>();

    public static ITaskFlowContext getTaskFlowContext(final ITaskFlowFile tfModel) {
        IProject earProject;
        final IFile tfFile = (IFile)tfModel.adapt(IFile.class);
        ITaskFlowContext context = contextMap.get(tfFile);
        if (context == null && (earProject = DTRTUtil.getEARProject((IResource)tfFile)) != null) {
            TaskFlowProxy taskFlowProxy;
            block4: {
                taskFlowProxy = new TaskFlowProxy(tfModel.getTaskFlow());
                context = (ITaskFlowContext)DTRTUtil.createContext((IResource)tfFile, ITaskFlowContext.class);
                if (context != null) break block4;
                return null;
            }
            try {
                context.initialize(earProject, (ITaskFlowContext.ITaskFlowProxy)taskFlowProxy, null);
                context.addListener((IOEPEContext.IContextListener)new ExecutableContextAdapter(){

                    public void handleExternalChange(IOEPEContext context) {
                        try {
                            context.reset(null);
                            if (tfFile.isAccessible() && !tfModel.disposed()) {
                                for (IActivity activity : tfModel.getTaskFlow().getActivities()) {
                                    if (activity.disposed()) continue;
                                    activity.isHasPageDefinition().refresh();
                                }
                            }
                        }
                        catch (Exception e) {
                            LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
            }
            contextMap.put(tfFile, context);
        }
        return context;
    }

    public static void disposeTaskFlowContext(ITaskFlowFile tfModel) {
        IFile tfFile = (IFile)tfModel.adapt(IFile.class);
        ITaskFlowContext context = contextMap.get(tfFile);
        if (context != null) {
            context.dispose();
            contextMap.remove(tfFile);
        }
    }
}

