/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ElementPropertyBinding;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public class TaskFlowBinding
extends ElementPropertyBinding {
    private static final String TASK_FLOW_DEFINITION_ELEMENT = "task-flow-definition";
    private static final String TASK_FLOW_TEMPLATE_ELEMENT = "task-flow-template";
    private Resource resource;

    public Resource read() {
        if (this.resource == null) {
            XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
            this.resource = new TaskFlowBindingResource(parentXmlResource);
        }
        return this.resource;
    }

    public ElementType type(Resource resource) {
        return this.property().definition().getType();
    }

    private static class TaskFlowBindingResource
    extends XmlResource {
        private XmlPath path;

        public TaskFlowBindingResource(XmlResource parent) {
            super((Resource)parent);
        }

        public void init(Element modelElement) {
            super.init(modelElement);
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    TaskFlowBindingResource.this.removeIfEmpty();
                }
            };
            for (PropertyDef property : modelElement.type().properties()) {
                modelElement.attach((Listener)listener, property.name());
            }
        }

        public XmlElement getXmlElement(boolean createIfNecessary) {
            XmlElement parent = ((XmlResource)this.parent()).getXmlElement(createIfNecessary);
            XmlElement element = null;
            ITaskFlowFile tfFile = (ITaskFlowFile)this.element().nearest(ITaskFlowFile.class);
            this.path = tfFile.getTaskFlowType().content() == TaskFlowType.Bounded ? new XmlPath(TaskFlowBinding.TASK_FLOW_DEFINITION_ELEMENT, ((XmlResource)this.element().resource()).getXmlNamespaceResolver()) : (tfFile.getTaskFlowType().content() == TaskFlowType.Template ? new XmlPath(TaskFlowBinding.TASK_FLOW_TEMPLATE_ELEMENT, ((XmlResource)this.element().resource()).getXmlNamespaceResolver()) : new XmlPath("", ((XmlResource)this.element().resource()).getXmlNamespaceResolver()));
            if (parent != null) {
                element = (XmlElement)parent.getChildNode(this.path, createIfNecessary);
            }
            return element;
        }

        private void removeIfEmpty() {
            XmlElement element;
            XmlElement base = ((XmlResource)this.parent()).getXmlElement(false);
            if (base != null && (element = (XmlElement)base.getChildNode(this.path, false)) != null && element != base && element.isEmpty()) {
                base.removeChildNode(this.path);
            }
        }
    }
}

