/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.OutcomeReentryType;
import oracle.eclipse.tools.adf.controller.model.ReentryType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class OutcomeReentryValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                OutcomeReentryValidator.this.refresh();
            }
        };
        ITaskFlow tf = (ITaskFlow)this.context(ITaskFlow.class);
        tf.attach(this.listener, "TaskFlowReentry");
    }

    protected Status compute() {
        ITaskFlow taskFlow = (ITaskFlow)this.context(ITaskFlow.class);
        Value value = (Value)this.context(Value.class);
        if (value.content() != OutcomeReentryType.NOT_OUTCOME_DEPENDENT) {
            if (taskFlow.getTaskFlowReentry().content() != ReentryType.REENTRY_OUTCOME_DEPENDENT) {
                return Status.createErrorStatus((String)Resources.invalidReentrySettingMsg1);
            }
        } else if (taskFlow.getTaskFlowReentry().content() == ReentryType.REENTRY_OUTCOME_DEPENDENT) {
            return Status.createErrorStatus((String)Resources.invalidReentrySettingMsg2);
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            ITaskFlow tf = (ITaskFlow)this.context(ITaskFlow.class);
            tf.detach(this.listener, "TaskFlowReentry");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String invalidReentrySettingMsg1;
        public static String invalidReentrySettingMsg2;

        static {
            Resources.initializeMessages((String)OutcomeReentryValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

