/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IControlFlowCase;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public class ControlFlowCasesBinding
extends LayeredListPropertyBinding {
    private static final String RULE_NAME = "control-flow-rule";
    private static final String FROM_ACTIVITY_NAME = "from-activity-id";
    private static final String FLOW_CASE_NAME = "control-flow-case";

    protected List<?> readUnderlyingList() {
        ITaskFlow taskFlow = (ITaskFlow)this.property().nearest(ITaskFlow.class);
        IActivity activity = (IActivity)this.property().nearest(IActivity.class);
        XmlResource parentXmlResource = (XmlResource)taskFlow.resource();
        XmlElement parent = parentXmlResource.getXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        List rules = parent.getChildElements(RULE_NAME);
        for (XmlElement rule : rules) {
            XmlElement fromActivityElement = rule.getChildElement(FROM_ACTIVITY_NAME, false);
            if (fromActivityElement == null || !fromActivityElement.getText().equals(activity.getActivityId().content())) continue;
            list.addAll(rule.getChildElements(FLOW_CASE_NAME));
        }
        return list;
    }

    protected Resource resource(Object obj) {
        XmlElement xmlElement = (XmlElement)obj;
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        return new ChildXmlResource((Resource)parentXmlResource, xmlElement);
    }

    public ElementType type(Resource resource) {
        return IControlFlowCase.TYPE;
    }

    protected Object insertUnderlyingObject(ElementType type, int position) {
        Object obj = this.insertUnderlyingObject(type);
        this.move(this.resource(obj), position);
        return obj;
    }

    private Object insertUnderlyingObject(ElementType type) {
        ITaskFlow taskFlow = (ITaskFlow)this.property().nearest(ITaskFlow.class);
        IActivity activity = (IActivity)this.property().nearest(IActivity.class);
        XmlResource tfXmlResource = (XmlResource)taskFlow.resource();
        XmlElement tfElement = tfXmlResource.getXmlElement(true);
        XmlElement ruleElement = null;
        List rules = tfElement.getChildElements(RULE_NAME);
        for (XmlElement rule : rules) {
            XmlElement fromActivityElement = rule.getChildElement(FROM_ACTIVITY_NAME, false);
            if (fromActivityElement == null || !fromActivityElement.getText().equals(activity.getActivityId().content())) continue;
            ruleElement = rule;
            break;
        }
        if (ruleElement == null) {
            ruleElement = tfElement.addChildElement(RULE_NAME);
            XmlElement activityIdElement = ruleElement.addChildElement(FROM_ACTIVITY_NAME);
            activityIdElement.setText((String)activity.getActivityId().content());
        }
        return ruleElement.addChildElement(FLOW_CASE_NAME);
    }

    public void remove(Resource resource) {
        XmlResource xmlResource = (XmlResource)resource;
        XmlElement xmlElement = xmlResource.getXmlElement();
        XmlElement ruleElement = xmlElement.getParent();
        xmlElement.remove();
        if (ruleElement.getChildElements(FLOW_CASE_NAME).isEmpty()) {
            ruleElement.remove();
        }
    }
}

