/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.internal.TemplateService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.ReferenceService;

public class ActivityReferenceResolver
extends ReferenceService {
    private TemplateService templateService;
    private Listener templateServiceListener;
    private Listener activitiesListener;

    protected void init() {
        super.init();
        Element element = (Element)this.context(Element.class);
        ITaskFlow tf = (ITaskFlow)element.nearest(ITaskFlow.class);
        if (tf != null) {
            this.templateService = (TemplateService)tf.getTemplateReference().service(TemplateService.class);
            if (this.templateService != null) {
                this.templateServiceListener = new Listener(){

                    public void handle(Event event) {
                        ActivityReferenceResolver.this.broadcast();
                    }
                };
                this.templateService.attach(this.templateServiceListener);
            }
            this.activitiesListener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    ActivityReferenceResolver.this.broadcast();
                }
            };
            tf.attach(this.activitiesListener, "Activities/ActivityId");
        }
    }

    public IActivity resolve(String reference) {
        if (reference == null) {
            return null;
        }
        ElementList<IActivity> activities = null;
        ITaskFlow taskFlow = (ITaskFlow)this.context(ITaskFlow.class);
        if (taskFlow != null) {
            activities = taskFlow.getActivities();
        }
        if (activities != null) {
            for (IActivity activity : activities) {
                if (!reference.equals(activity.getActivityId().content())) continue;
                return activity;
            }
        }
        if (this.templateService != null) {
            return this.templateService.getTemplateActivity(reference);
        }
        return null;
    }

    public void dispose() {
        ITaskFlow tf;
        if (this.templateService != null && this.templateServiceListener != null) {
            this.templateService.detach(this.templateServiceListener);
        }
        if ((tf = (ITaskFlow)this.context(ITaskFlow.class)) != null) {
            tf.detach(this.activitiesListener, "Activities/ActivityId");
        }
        super.dispose();
    }
}

