/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.HashMap;
import java.util.Set;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.internal.ActivityManager;
import oracle.eclipse.tools.adf.controller.model.internal.AvailableActivitiesService;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ActivityListListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        ITaskFlow taskFlow = (ITaskFlow)event.property().element();
        this.removeObsoleteBreakPoints(taskFlow);
        if (TaskFlowUtil.isBoundedTaskFlow(taskFlow) || TaskFlowUtil.isTaskFlowTemplate(taskFlow)) {
            Set availableIds;
            AvailableActivitiesService service;
            if (taskFlow.getDefaultActivity().content() == null) {
                ElementList<IActivity> activities = taskFlow.getActivities();
                if (activities.size() == 1) {
                    ((IActivity)activities.get(0)).setDefaultActivity(true);
                }
            } else {
                String defaultActivityId = (String)taskFlow.getDefaultActivity().content();
                service = (AvailableActivitiesService)taskFlow.getDefaultActivity().service(AvailableActivitiesService.class);
                availableIds = service.values();
                if (!availableIds.contains(defaultActivityId)) {
                    taskFlow.setDefaultActivity(null);
                    ActivityManager.setDefaultActivity(taskFlow, null);
                }
            }
            String exceptionHandlerId = (String)taskFlow.getExceptionHandler().content();
            service = (AvailableActivitiesService)taskFlow.getExceptionHandler().service(AvailableActivitiesService.class);
            availableIds = service.values();
            if (exceptionHandlerId != null && !availableIds.contains(exceptionHandlerId)) {
                taskFlow.setExceptionHandler(null);
                ActivityManager.setExceptionHandlerActivity(taskFlow, null);
            }
        }
    }

    private void removeObsoleteBreakPoints(ITaskFlow taskFlow) {
        IFile tfFile = (IFile)taskFlow.adapt(IFile.class);
        IBreakpoint[] brkpts = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        HashMap<String, IBreakpoint> brkptIdMap = new HashMap<String, IBreakpoint>();
        IBreakpoint[] iBreakpointArray = brkpts;
        int n = brkpts.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint brkpt = iBreakpointArray[n2];
            if (brkpt.getMarker().getResource().equals((Object)tfFile)) {
                try {
                    String id = brkpt.getMarker().getAttribute("oracle.eclipse.tools.adf.debugger.taskflow.activityid").toString();
                    brkptIdMap.put(id, brkpt);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        for (IActivity act : taskFlow.getActivities()) {
            brkptIdMap.remove(act.getActivityId().content());
        }
        for (IBreakpoint brkpt : brkptIdMap.values()) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(brkpt, true);
            }
            catch (CoreException coreException) {}
        }
    }
}

