/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class ActivityIdBinding
extends XmlValueBindingImpl {
    private String childName;

    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        this.childName = params.length > 0 ? params[0] : property.name();
    }

    public String read() {
        XmlElement el = this.xml(false);
        if (el != null) {
            StringBuffer temp = new StringBuffer(el.getChildNodeText(this.childName));
            String suffix = el.getMetaCommentText("id-suffix");
            if (suffix != null) {
                temp.append(suffix);
            }
            return temp.toString();
        }
        return null;
    }

    public void write(String value) {
        String modifiedVal = value;
        StringBuffer temp = new StringBuffer();
        if (modifiedVal != null) {
            modifiedVal = modifiedVal.trim();
            while (modifiedVal.endsWith("*")) {
                modifiedVal = modifiedVal.substring(0, modifiedVal.length() - 1);
                temp.append("*");
            }
        }
        XmlElement el = this.xml(true);
        el.setChildNodeText(this.childName, modifiedVal, true);
        if (temp.length() > 0) {
            String comment = temp.toString();
            el.setMetaCommentText("id-suffix", comment);
        } else {
            el.setMetaCommentText("id-suffix", null);
        }
    }
}

