/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model.internal;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.RelativePathService;

public class ADFArtifactsPathService
extends RelativePathService {
    public List<Path> roots() {
        IContainer underlyingFolder;
        IProject project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class);
        if (project != null && (underlyingFolder = ProjectUtil.getWebContentFolderIResource(project)) != null) {
            IPath path = underlyingFolder.getProjectRelativePath();
            IFolder folder = project.getFolder(path);
            return Collections.singletonList(new Path(folder.getLocation().toPortableString()));
        }
        return Collections.emptyList();
    }

    public Path convertToRelative(Path path) {
        Path retPath = super.convertToRelative(path);
        if (retPath != null) {
            String newPath = "/" + retPath.toPortableString();
            return new Path(newPath);
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        String pathStr = path.toPortableString();
        if (pathStr != null && pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        return super.convertToAbsolute(new Path(pathStr));
    }
}

