/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.IControlFlowCase;
import oracle.eclipse.tools.adf.controller.model.internal.WildCardRuleBinding;
import oracle.eclipse.tools.adf.controller.model.internal.WildCardRuleValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Image(path="oracle/eclipse/tools/adf/controller/model/wildcard-16.png")
@Documentation(content="Use to specify a control flow rule that can originate from any activities whose ids match a wildcard expression. For example, it can represent a control rule from-activity-id containing a trailing wildcard such as foo* .")
public interface IWildCardRule
extends Element {
    public static final ElementType TYPE = new ElementType(IWildCardRule.class);
    @Label(standard="from activity")
    @Documentation(content="Wildcard control flow rule is used to specify a control flow rule that can originate from any activities whose ids match a wildcard expression. For example, it can represent a control rule from-activity-id containing a trailing wildcard such as foo* .[pbr/][b]From Actitity[/b][pbr/]An ID that references the originating activity in the control flow rule.[pbr/] Wildcard (*) characters are supported in from-activity-id. The rule apply to all activities that match the wildcard pattern. For example, login* matches any logical activity ID beginning with the literal login.")
    @CustomXmlValueBinding(impl=WildCardRuleBinding.class)
    @Service(impl=WildCardRuleValidator.class)
    @XmlBinding(path="from-activity-id")
    public static final ValueProperty PROP_FROM_ACTIVITY = new ValueProperty(TYPE, "FromActivity");
    @Type(base=IControlFlowCase.class)
    @Documentation(content="Defines possible control flows originating at the from-activity-id of the control flow rule.[pbr/][b]From Outcome[/b][pbr/]Limit the application of a control flow case to the specified outcome.[pbr/][b]To Activity[/b][pbr/]Specifies the ID of an activity that is the target of the control flow case.")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="control-flow-case", type=IControlFlowCase.class)})
    public static final ListProperty PROP_CONTROL_FLOW_CASES = new ListProperty(TYPE, "ControlFlowCases");

    public Value<String> getFromActivity();

    public void setFromActivity(String var1);

    public ElementList<IControlFlowCase> getControlFlowCases();
}

