/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IControlFlowRule;
import oracle.eclipse.tools.adf.controller.model.IFinalizer;
import oracle.eclipse.tools.adf.controller.model.IInitializer;
import oracle.eclipse.tools.adf.controller.model.IInputParameterDefinition;
import oracle.eclipse.tools.adf.controller.model.IManagedBean;
import oracle.eclipse.tools.adf.controller.model.IMetadataResource;
import oracle.eclipse.tools.adf.controller.model.IReturnValueDefinition;
import oracle.eclipse.tools.adf.controller.model.ISavePointFinalizer;
import oracle.eclipse.tools.adf.controller.model.ISecurity;
import oracle.eclipse.tools.adf.controller.model.ITemplateReference;
import oracle.eclipse.tools.adf.controller.model.IUiInfoType;
import oracle.eclipse.tools.adf.controller.model.IVisibility;
import oracle.eclipse.tools.adf.controller.model.IWildCardRule;
import oracle.eclipse.tools.adf.controller.model.ReentryType;
import oracle.eclipse.tools.adf.controller.model.TransactionType;
import oracle.eclipse.tools.adf.controller.model.internal.ActivitiesPossibleTypesService;
import oracle.eclipse.tools.adf.controller.model.internal.ActivityListBinding;
import oracle.eclipse.tools.adf.controller.model.internal.ActivityListListener;
import oracle.eclipse.tools.adf.controller.model.internal.ActivityListValidator;
import oracle.eclipse.tools.adf.controller.model.internal.AvailableActivitiesService;
import oracle.eclipse.tools.adf.controller.model.internal.ControlFlowRuleListBinding;
import oracle.eclipse.tools.adf.controller.model.internal.DataControlScopeBinding;
import oracle.eclipse.tools.adf.controller.model.internal.DefaultActivityChangeListener;
import oracle.eclipse.tools.adf.controller.model.internal.DefaultActivityValidator;
import oracle.eclipse.tools.adf.controller.model.internal.ExceptionHandlerListener;
import oracle.eclipse.tools.adf.controller.model.internal.ManagedBeanListBinding;
import oracle.eclipse.tools.adf.controller.model.internal.ReentryBinding;
import oracle.eclipse.tools.adf.controller.model.internal.TaskFlowIdValidator;
import oracle.eclipse.tools.adf.controller.model.internal.TemplateService;
import oracle.eclipse.tools.adf.controller.model.internal.TransactionBinding;
import oracle.eclipse.tools.adf.controller.model.internal.TransactionListener;
import oracle.eclipse.tools.adf.controller.model.internal.WildCardRuleListBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

@Documentation(content="ADF task flows provide a modular approach for defining control flow in an application. Instead of representing an application as a single large JSF page flow, you can break it up into a collection of reusable task flows. Each task flow contains a portion of the application's navigational graph. The nodes in the task flows are activities. An activity node represents a simple logical operation such as displaying a page, executing application logic, or calling another task flow. The transactions between the activities are called control flow cases.")
public interface ITaskFlow
extends IUiInfoType {
    public static final ElementType TYPE = new ElementType(ITaskFlow.class);
    @Type(base=IMetadataResource.class)
    @Enablement(expr="${root().TaskFlowType == 'Unbounded'}")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="metadata-resource", type=IMetadataResource.class)})
    public static final ListProperty PROP_METADATA_RESOURCES = new ListProperty(TYPE, "MetadataResources");
    @Required
    @XmlValueBinding(path="@id", removeNodeOnSetIfNull=false)
    @Label(standard="task flow ID")
    @Service(impl=TaskFlowIdValidator.class)
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ValueProperty PROP_TASK_FLOW_ID = new ValueProperty(TYPE, "TaskFlowId");
    @Type(base=ITemplateReference.class)
    @XmlBinding(path="template-reference")
    @Label(standard="template reference")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Service(impl=TemplateService.class)
    public static final ElementProperty PROP_TEMPLATE_REFERENCE = new ElementProperty(TYPE, "TemplateReference");
    @XmlBinding(path="default-activity")
    @Label(standard="default activity")
    @Services(value={@Service(impl=AvailableActivitiesService.class), @Service(impl=DefaultActivityValidator.class)})
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Listeners(value={DefaultActivityChangeListener.class})
    @Documentation(content="Specifies the first activity in a task flow to execute.")
    public static final ValueProperty PROP_DEFAULT_ACTIVITY = new ValueProperty(TYPE, "DefaultActivity");
    @Type(base=TransactionType.class)
    @Label(standard="transaction")
    @CustomXmlValueBinding(impl=TransactionBinding.class)
    @DefaultValue(text="no-transaction")
    @Listeners(value={TransactionListener.class})
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content="Choose whether a called ADF bounded task flow should join an existing transaction, create a new one, or create a new one only if there is no existing transaction. [pbr/]* [b]requires-existing-transaction:[/b] When called, the ADF bounded task flow participates in an existing transaction, already in progress.[pbr/]* [b]requires-transaction:[/b] When called, the ADF bounded task flow either participates in an existing transaction if one exists, or starts a new transaction upon entry of the ADF bounded task flow if one doesn't exist. [pbr/]* [b]requires-new-transaction:[/b] A new transaction is always started when the ADF bounded task flow is entered, regardless of whether or not a transaction is in progress. The new transaction is completed when the ADF bounded task flow exits. ")
    public static final ValueProperty PROP_TRANSACTION = new ValueProperty(TYPE, "Transaction");
    @Type(base=Boolean.class)
    @Label(standard="no save point on task flow entry")
    @XmlValueBinding(path="no-save-point", mapExistanceToValue="true")
    @Enablement(expr="${(root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template') && Transaction != 'new-transaction' }")
    @DefaultValue(text="false")
    @Documentation(content="Check if an ADF Model save point should not be created on task flow entry. An ADF Model save point is a saved snapshot of the ADF Model state. Selecting true means that overhead associated with a save point is not created for the transaction.[pbr/]This option is valid only if you also choose requires-existing-transaction or requires-transaction from the transaction drop-down list.")
    public static final ValueProperty PROP_NO_SAVE_POINT = new ValueProperty(TYPE, "NoSavePoint");
    @Type(base=Boolean.class)
    @Enablement(expr="${(root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template') && Transaction != 'requires-existing-transaction' }")
    @DefaultValue(text="true")
    @CustomXmlValueBinding(impl=DataControlScopeBinding.class)
    @Label(standard="share data controls with calling task flow")
    @Documentation(content="Choose whether the ADF bounded task flow will run with an isolated or shared Data Control Scope. If an ADF bounded task flow with a shared Data Control Scope is used within an ADF region, the ADF region uses the current DataControlFrame of the parent ADF task flow.")
    public static final ValueProperty PROP_SHARED_DATA_CONTROL_SCOPE = new ValueProperty(TYPE, "SharedDataControlScope");
    @Type(base=ReentryType.class)
    @Label(standard="task flow reentry")
    @CustomXmlValueBinding(impl=ReentryBinding.class)
    @DefaultValue(text="reentry-allowed")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content="Choose whether a page in the calling ADF bounded task flow can be reentered:[pbr/]* [b]reentry-allowed:[/b] Reentry is allowed on any view activity within the ADF bounded task flow.[pbr/]* [b]reentry-not-allowed:[/b] Reentry of the ADF bounded task flow is not allowed. An exception will be thrown indicating the bounded task flow was reentered improperly. [pbr/] You can set up an exception handler to display the exception and route control flow in order to navigate to the default activity of the called task flow definition. If the task flow definition was not called from another task flow definition, a normal web error is posted and handled as specified in the web.xml file. [pbr/]* [b]reentry-outcome-dependent:[/b] Reentry of the calling bounded task flow is dependent on the outcome received when exiting the called bounded Task Flow. If specified, any task flow return activities on the called ADF bounded task flow must also specify either reentry allowed or reentry-not-allowed when returning to the caller.")
    public static final ValueProperty PROP_TASK_FLOW_REENTRY = new ValueProperty(TYPE, "TaskFlowReentry");
    @Type(base=ISecurity.class)
    @Label(standard="security")
    @XmlBinding(path="security")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ElementProperty PROP_SECURITY = new ElementProperty(TYPE, "Security");
    @Type(base=IInputParameterDefinition.class)
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content="A called ADF bounded task flow can accept input parameters.[pbr/]To pass an input parameter to a bounded task flow, you must specify one or more input parameter definitions on the called bounded task flow. These specify where the called bounded task flow can retrieve parameter values.[pbr/][b]Name[/b][pbr/]Name for the input parameter[pbr/][b]Class[/b][pbr/]Java class for the input parameter definition. The class Java type defaults to java.lang.String.[pbr/][b]Value[/b][pbr/]An EL expression that, when evaluated, specifies where the input-parameter-definition value is stored and referenced, for example, #{pageFlowScope.inputValue}. The value on the input-parameter-definition for the called task flow specifies where a value will be retrieved for use within the called task flow definition once it is passed. [pbr/][b]Required[/b][pbr/]Select if a mapping for the input parameter definition must be specified when a task flow call activity is executed. ")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="input-parameter-definition", type=IInputParameterDefinition.class)})
    public static final ListProperty PROP_INPUT_PARAMETERS = new ListProperty(TYPE, "InputParameters");
    @Type(base=IReturnValueDefinition.class)
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content=" A task flow return activity causes the ADF bounded task flow to return to the task flow that called it. The called bounded task flow can pass return values back to the calling task flow.To return a value, you must specify return value definitions on the called bounded task flow. These specify where the return value is to be taken from upon exit of the called bounded task flow.[pbr/][b]Name[/b][pbr/]Name for the return value[pbr/][b]Class[/b][pbr/]Java class for the return value definition. The class Java type defaults to java.lang.String.[pbr/][b]Value[/b][pbr/]Enter an EL expression that, when evaluated, specifies where the return-value-definition value is stored and referenced, for example, #{pageFlowScope.returnValue}. The value on the return-value-definition for the called task flow specifies where a value will be retrieved for use within the calling task flow definition once it is returned. ")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="return-value-definition", type=IReturnValueDefinition.class)})
    public static final ListProperty PROP_RETURN_VALUES = new ListProperty(TYPE, "ReturnValues");
    @Type(base=IManagedBean.class)
    @CustomXmlListBinding(impl=ManagedBeanListBinding.class)
    @Documentation(content="Managed beans are Java classes that you register with the application using various configuration files. When the JSF application starts up, it parses these configuration files, and the beans listed within them are made available. The managed beans can be referenced in an EL expression, allowing access to the beans' properties and methods. Whenever a managed bean is referenced for the first time and it does not already exist, the Managed Bean Creation Facility instantiates the bean by calling the default constructor method on it. If any properties are also declared, they are populated with the declared default values.[pbr/][b]Name[/b][pbr/]Enter a name for the managed bean, for example, managedBean1.[pbr/][b]Class[/b][pbr/]Enter a class for the managed bean, for example, java.lang.String.[pbr/][b]Scope[/b][pbr/]Choose a scope for the managed bean: [ul][li][b]request[/b] - the duration between when an HTTP request is made until a response is sent back to the client.[/li][li][b]view[/b] - The object is available until the view port ID for the current view activity changes. You can use View scope to hold values for a given page. While request scope can be used to store a value needed from one page to the next, anything stored in view scope will be lost once the view ID changes.[/li][li][b]pageFlow[/b] - the duration between when the current task flow was called and when it finishes executing.[/li][li][b]session[/b] - the duration of the current client session.[/li][li][b]application[/b] - the duration of the application.[/li][li][b]none[/b] - the managed scope does not live within any particular scope, but is instead instantiated each time it is referenced.[/li][/ul]")
    public static final ListProperty PROP_MANAGED_BEANS = new ListProperty(TYPE, "ManagedBeans");
    @Type(base=IInitializer.class)
    @XmlBinding(path="initializer")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ImpliedElementProperty PROP_INITIALIZER = new ImpliedElementProperty(TYPE, "Initializer");
    @Type(base=IFinalizer.class)
    @XmlBinding(path="finalizer")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ImpliedElementProperty PROP_FINALIZER = new ImpliedElementProperty(TYPE, "Finalizer");
    @Type(base=ISavePointFinalizer.class)
    @XmlBinding(path="save-point-restore-finalizer")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ImpliedElementProperty PROP_SAVE_POINT_FINALIZER = new ImpliedElementProperty(TYPE, "SavePointFinalizer");
    @Service(impl=AvailableActivitiesService.class)
    @XmlBinding(path="exception-handler")
    @Label(standard="exception handler")
    @Listeners(value={ExceptionHandlerListener.class})
    @Documentation(content="Specifies the activity to execute to handle exceptions.")
    public static final ValueProperty PROP_EXCEPTION_HANDLER = new ValueProperty(TYPE, "ExceptionHandler");
    @Type(base=IActivity.class)
    @CustomXmlListBinding(impl=ActivityListBinding.class)
    @Services(value={@Service(impl=ActivityListValidator.class), @Service(impl=ActivitiesPossibleTypesService.class)})
    @Listeners(value={ActivityListListener.class})
    public static final ListProperty PROP_ACTIVITIES = new ListProperty(TYPE, "Activities");
    @Type(base=IControlFlowRule.class)
    @CustomXmlListBinding(impl=ControlFlowRuleListBinding.class)
    @Documentation(content="Use to specify how control flow passes from one activity to another in an ADF unbounded or bounded task flow. Control flow rules are based on JSF navigation rules, but capture additional information. JSF navigation is always between pages, whereas control flows rules describe transitions between activities. For example, a control flow rule can indicate a transition between a page associated with a view activity and a subsequent method call activity.")
    public static final ListProperty PROP_CONTROL_FLOW_RULES = new ListProperty(TYPE, "ControlFlowRules");
    @Type(base=IWildCardRule.class)
    @CustomXmlListBinding(impl=WildCardRuleListBinding.class)
    public static final ListProperty PROP_WILD_CARD_RULES = new ListProperty(TYPE, "WildCardRules");
    @Type(base=Boolean.class)
    @Label(standard="train")
    @XmlValueBinding(path="train", mapExistanceToValue="true")
    @DefaultValue(text="false")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content="Indicates whether to make the ADF bounded task flow a train. A train represents a progression of related activities that is intended to guide an end user to the completion of a task. The end user clicks a series of train stops, each stop linking to a particular web page")
    public static final ValueProperty PROP_TRAIN = new ValueProperty(TYPE, "Train");
    @Type(base=Boolean.class)
    @Label(standard="critical")
    @XmlValueBinding(path="critical", mapExistanceToValue="true")
    @DefaultValue(text="false")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @Documentation(content="Choose true if you want the task flow definition to perform an implicit save in these situations: [pbr/]* Session timed out by the server due to end user inactivity. For example, an end user enters data and then goes to lunch without saving. While away, their session times out. [pbr/]* Session ended by an explicit logout without saving data. ")
    public static final ValueProperty PROP_CRITICAL = new ValueProperty(TYPE, "Critical");
    @Type(base=Boolean.class)
    @Label(standard="use page fragments")
    @XmlValueBinding(path="use-page-fragments", mapExistanceToValue="true")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    @DefaultValue(text="false")
    @Documentation(content="Indicates that this task flow's view activities must all refer to page fragments.")
    public static final ValueProperty PROP_USE_PAGE_FRAGMENTS = new ValueProperty(TYPE, "UsePageFragments");
    @Type(base=IVisibility.class)
    @XmlBinding(path="visibility")
    @Enablement(expr="${root().TaskFlowType == 'Bounded' || root().TaskFlowType == 'Template'}")
    public static final ImpliedElementProperty PROP_VISIBILITY = new ImpliedElementProperty(TYPE, "Visibility");

    public ElementList<IMetadataResource> getMetadataResources();

    public Value<String> getTaskFlowId();

    public void setTaskFlowId(String var1);

    public ElementHandle<ITemplateReference> getTemplateReference();

    public Value<String> getDefaultActivity();

    public void setDefaultActivity(String var1);

    public Value<TransactionType> getTransaction();

    public void setTransaction(String var1);

    public void setTransaction(TransactionType var1);

    public Value<Boolean> isNoSavePoint();

    public void setNoSavePoint(String var1);

    public void setNoSavePoint(Boolean var1);

    public Value<Boolean> isSharedDataControlScope();

    public void setSharedDataControlScope(String var1);

    public void setSharedDataControlScope(Boolean var1);

    public Value<ReentryType> getTaskFlowReentry();

    public void setTaskFlowReentry(String var1);

    public void setTaskFlowReentry(ReentryType var1);

    public ElementHandle<ISecurity> getSecurity();

    public ElementList<IInputParameterDefinition> getInputParameters();

    public ElementList<IReturnValueDefinition> getReturnValues();

    public ElementList<IManagedBean> getManagedBeans();

    public IInitializer getInitializer();

    public IFinalizer getFinalizer();

    public ISavePointFinalizer getSavePointFinalizer();

    public Value<String> getExceptionHandler();

    public void setExceptionHandler(String var1);

    public ElementList<IActivity> getActivities();

    public ElementList<IControlFlowRule> getControlFlowRules();

    public ElementList<IWildCardRule> getWildCardRules();

    public Value<Boolean> isTrain();

    public void setTrain(String var1);

    public void setTrain(Boolean var1);

    public Value<Boolean> isCritical();

    public void setCritical(String var1);

    public void setCritical(Boolean var1);

    public Value<Boolean> isUsePageFragments();

    public void setUsePageFragments(String var1);

    public void setUsePageFragments(Boolean var1);

    public IVisibility getVisibility();
}

