/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.model;

import oracle.eclipse.tools.adf.controller.model.EndTransactionType;
import oracle.eclipse.tools.adf.controller.model.OutcomeReentryType;
import oracle.eclipse.tools.adf.controller.model.internal.EndTransactionBinding;
import oracle.eclipse.tools.adf.controller.model.internal.EndTransactionValidator;
import oracle.eclipse.tools.adf.controller.model.internal.OutcomeReentryTypeBinding;
import oracle.eclipse.tools.adf.controller.model.internal.OutcomeReentryValidator;
import oracle.eclipse.tools.adf.controller.model.internal.TaskFlowReturnOutcomeNameListener;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

public interface IOutcome
extends Element {
    public static final ElementType TYPE = new ElementType(IOutcome.class);
    @Required
    @XmlBinding(path="name")
    @Label(standard="outcome name")
    @Listeners(value={TaskFlowReturnOutcomeNameListener.class})
    @Documentation(content="Name for the outcome that is returned to the calling task flow when the called ADF bounded task flow exits. The calling ADF task flow should define control flow rules to handle control flow upon return.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=Boolean.class)
    @DefaultValue(text="false")
    public static final TransientProperty PROP_USER_MODIFIED_NAME = new TransientProperty(TYPE, "UserModifiedName");
    @Type(base=OutcomeReentryType.class)
    @Label(standard="reentry")
    @CustomXmlValueBinding(impl=OutcomeReentryTypeBinding.class)
    @Service(impl=OutcomeReentryValidator.class)
    @DefaultValue(text="not-outcome-dependent")
    @Documentation(content="Choose the default behavior that occurs when a previously exited ADF bounded task flow is reentered:[ul][li][b]<default> (not outcome dependent)[/b] : Reentry is not dependent on an outcome.[/li][li][b]reentry-allowed:[/b] The bounded task flow that called the current bounded task flow can be reentered.[/li][li][b]reentry-not-allowed:[/b] The bounded task flow that called the current bounded task flow cannot be reentered. [/li][/ul][pbr/]The [b]reentry-allowed[/b] and [b]reentry-not-allowed[/b] options apply only if reentry-outcome-dependent has been set on the calling ADF bounded task flow. The reentry-outcome-dependent option specifies that reentry of a calling bounded task flow is dependent on the reentry option set on the task flow return activity located in the called bounded task flow. ")
    public static final ValueProperty PROP_REENTRY_TYPE = new ValueProperty(TYPE, "ReentryType");
    @Type(base=EndTransactionType.class)
    @Label(standard="end transaction")
    @CustomXmlValueBinding(impl=EndTransactionBinding.class)
    @Service(impl=EndTransactionValidator.class)
    @DefaultValue(text="none")
    @Documentation(content="Choose whether to commit a transaction to the database or roll it back: [pbr/] * [b]commit:[/b] Commit the transaction to the database. [pbr/] * [b]rollback:[/b] Rollback the transaction to what it was on entry of the called bounded task flow. This has the same effect as canceling the transaction, since it rolls back a new transaction to its initial state when it was started on entry of the bounded task flow.[pbr/]You should choose one of these options only if the task flow definition supports creation of a new transaction upon entry. A new transaction is created if: [pbr/] * you choose requires-transaction or new-transaction in the transaction drop-down list for the called ADF bounded task flow[pbr/] * and a new transaction is actually created on entry of the called ADF bounded task flow. (If you choose requires-transaction, a new transaction is created on entry of the ADF bounded task flow only if one doesn't already exist).")
    public static final ValueProperty PROP_END_TRANSACTION = new ValueProperty(TYPE, "EndTransaction");
    @Type(base=Boolean.class)
    @Label(standard="restore save point")
    @XmlValueBinding(path="restore-save-point", mapExistanceToValue="true")
    @DefaultValue(text="false")
    @Documentation(content="Check to restore a previous persistent save point in an application supporting save for later functionality.")
    public static final ValueProperty PROP_RESTORE_SAVE_POINT = new ValueProperty(TYPE, "RestoreSavePoint");

    public Value<String> getName();

    public void setName(String var1);

    public Transient<Boolean> getUserModifiedName();

    public void setUserModifiedName(Boolean var1);

    public Value<OutcomeReentryType> getReentryType();

    public void setReentryType(String var1);

    public void setReentryType(OutcomeReentryType var1);

    public Value<EndTransactionType> getEndTransaction();

    public void setEndTransaction(String var1);

    public void setEndTransaction(EndTransactionType var1);

    public Value<Boolean> isRestoreSavePoint();

    public void setRestoreSavePoint(String var1);

    public void setRestoreSavePoint(Boolean var1);
}

