/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.IADFView;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.IInputParameterDefinition;
import oracle.eclipse.tools.adf.controller.model.IMethodCall;
import oracle.eclipse.tools.adf.controller.model.IParentAction;
import oracle.eclipse.tools.adf.controller.model.IRouter;
import oracle.eclipse.tools.adf.controller.model.ISavePointRestore;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowCall;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowReturn;
import oracle.eclipse.tools.adf.controller.model.IUrlView;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.context.typed.IWebPageContext;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public final class TaskFlowProxy
implements ITaskFlowContext.ITaskFlowProxy,
IWebPageContext.ITaskFlowProxy {
    private ITaskFlow model;

    public TaskFlowProxy(IFile file) {
        this.model = TaskFlowFactory.createTaskFlow(file);
    }

    public TaskFlowProxy(ITaskFlow model) {
        this.model = model;
    }

    public TaskFlowProxy(IProject project) {
        IFile file = TaskFlowFactory.getDefaultUnboundedTaskFlowFile(project);
        this.model = TaskFlowFactory.createTaskFlow(file);
    }

    public IFile getTaskFlowFile() {
        if (this.model != null) {
            return (IFile)this.model.adapt(IFile.class);
        }
        return null;
    }

    public String getTaskFlowId() {
        if (this.model != null) {
            return (String)this.model.getTaskFlowId().content();
        }
        return null;
    }

    public List<?> getActivities() {
        if (this.model != null) {
            return this.model.getActivities();
        }
        return null;
    }

    public String getActivityId(Object activity) throws IllegalArgumentException {
        if (!(activity instanceof IActivity)) {
            throw new IllegalArgumentException();
        }
        IActivity tfActivity = (IActivity)activity;
        return (String)tfActivity.getActivityId().content();
    }

    public String getActivityType(Object activity) {
        IActivity tfActivity = (IActivity)activity;
        if (tfActivity instanceof IMethodCall) {
            return "method-call";
        }
        if (tfActivity instanceof IParentAction) {
            return "parent-action";
        }
        if (tfActivity instanceof IRouter) {
            return "router";
        }
        if (tfActivity instanceof ISavePointRestore) {
            return "save-point-restore";
        }
        if (tfActivity instanceof ITaskFlowCall) {
            return "task-flow-call";
        }
        if (tfActivity instanceof ITaskFlowReturn) {
            return "task-flow-return";
        }
        if (tfActivity instanceof IUrlView) {
            return "url-view";
        }
        if (tfActivity instanceof IADFView) {
            return "view";
        }
        if (tfActivity != null) {
            return tfActivity.type().getQualifiedName();
        }
        return null;
    }

    public boolean usesPageFragments() {
        if (this.model != null) {
            return (Boolean)this.model.isUsePageFragments().content();
        }
        return false;
    }

    public List<IWebPageContext.IParameterProxy> getParameters() {
        if (this.model != null) {
            ArrayList<ParameterProxy> parameters = new ArrayList<ParameterProxy>();
            for (IInputParameterDefinition parameter : this.model.getInputParameters()) {
                parameters.add(new ParameterProxy(parameter));
            }
            return Collections.unmodifiableList(parameters);
        }
        return Collections.emptyList();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getTaskFlowFile() == null ? 0 : this.getTaskFlowFile().hashCode());
        result = 31 * result + (this.getTaskFlowId() == null ? 0 : this.getTaskFlowId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskFlowProxy other = (TaskFlowProxy)obj;
        return DTRTUtil.equals((Object)this.getTaskFlowFile(), (Object)other.getTaskFlowFile()) && DTRTUtil.equals((Object)this.getTaskFlowId(), (Object)other.getTaskFlowId());
    }

    private class ParameterProxy
    implements IWebPageContext.IParameterProxy {
        private IInputParameterDefinition parameter;

        public ParameterProxy(IInputParameterDefinition parameter) {
            this.parameter = parameter;
        }

        public String getName() {
            if (this.parameter != null) {
                return (String)this.parameter.getName().content();
            }
            return null;
        }

        public String getDefaultValue() {
            if (this.parameter != null) {
                return (String)this.parameter.getValue().content();
            }
            return null;
        }

        public boolean isRequired() {
            if (this.parameter != null) {
                return (Boolean)this.parameter.isRequired().content();
            }
            return false;
        }

        private TaskFlowProxy getOuterType() {
            return TaskFlowProxy.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterProxy other = (ParameterProxy)obj;
            return DTRTUtil.equals((Object)this.getName(), (Object)other.getName()) && DTRTUtil.equals((Object)this.getOuterType(), (Object)other.getOuterType());
        }
    }
}

