/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller;

import oracle.eclipse.tools.adf.controller.ADFControllerPlugin;
import oracle.eclipse.tools.adf.controller.IBreakpointService;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class TaskFlowFactory {
    private static final String ADFC_CONFIG_FILE_NAME = "adfc-config.xml";
    private static IBreakpointService breakpointService = null;
    private static final String BREAKPOINT_SERVICE_EXT_POINT = "oracle.eclipse.tools.adf.controller.breakpointService";

    public static ITaskFlow createTaskFlow(IFile file) {
        try {
            TaskFlowType type = TaskFlowUtil.getTaskFlowType(file);
            if (type == TaskFlowType.Bounded || type == TaskFlowType.Unbounded || type == TaskFlowType.Template) {
                XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file));
                ITaskFlowFile tfFile = (ITaskFlowFile)ITaskFlowFile.TYPE.instantiate((Resource)new RootXmlResource(store));
                return tfFile.getTaskFlow();
            }
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
            return null;
        }
        return null;
    }

    public static ITaskFlowFile createTaskFlowFile(IFile file) {
        try {
            XmlResourceStore store = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file));
            ITaskFlowFile tfFile = (ITaskFlowFile)ITaskFlowFile.TYPE.instantiate((Resource)new RootXmlResource(store));
            return tfFile;
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((Plugin)ADFControllerPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static IFile getDefaultUnboundedTaskFlowFile(IProject project) {
        IFile adfcConfigFile = null;
        IContainer underlyingFolder = ProjectUtil.getWebContentFolderIResource(project);
        if (underlyingFolder != null) {
            IPath webContentPath = underlyingFolder.getProjectRelativePath();
            IPath adfcConfigFilePath = webContentPath.append("WEB-INF").append(ADFC_CONFIG_FILE_NAME);
            adfcConfigFile = project.getFile(adfcConfigFilePath);
        }
        return adfcConfigFile;
    }

    public static IBreakpointService getTaskflowBreakpointService() {
        IExtensionRegistry registry;
        IExtensionPoint extPoint;
        IConfigurationElement[] configs;
        if (breakpointService == null && (configs = (extPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(BREAKPOINT_SERVICE_EXT_POINT)).getConfigurationElements()) != null && configs.length > 0) {
            try {
                Object obj = configs[0].createExecutableExtension("class");
                if (obj instanceof IBreakpointService) {
                    breakpointService = (IBreakpointService)obj;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return breakpointService;
    }
}

