/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jst.jsf.common.internal.managedobject.AbstractManagedObject;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.IFacesConfigChangeListener;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvidersChangeListener;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigProvidersChangeEvent;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.CompositeJSFAppConfigLocatorProviderStrategy;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.BehaviorType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.ELResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyResolverType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.ResourceBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.emf.VariableResolverType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJSFAppConfigManager
extends AbstractManagedObject
implements IJSFAppConfigManager {
    protected IProject _project;
    protected List<IJSFAppConfigLocater> configLocaters;
    protected List<IJSFAppConfigProvidersChangeListener> configProvidersChangeListeners;
    protected Map<Class, IFacesConfigChangeListener> facesConfigChangeListeners;
    protected FacesConfigChangeAdapter facesConfigChangeAdapter;

    public AbstractJSFAppConfigManager(IProject project) {
        this._project = project;
        this.initialize();
    }

    @Override
    public IProject getProject() {
        return this._project;
    }

    protected void initialize() {
        this.facesConfigChangeListeners = new HashMap<Class, IFacesConfigChangeListener>();
        this.configProvidersChangeListeners = new ArrayList<IJSFAppConfigProvidersChangeListener>();
        this.configLocaters = new ArrayList<IJSFAppConfigLocater>();
        this.populateConfigLocaters();
        this.startConfigLocaters();
    }

    protected void populateConfigLocaters() {
        CompositeJSFAppConfigLocatorProviderStrategy clps = new CompositeJSFAppConfigLocatorProviderStrategy(this.getProject());
        for (IJSFAppConfigLocater locator : clps.getLocators()) {
            locator.setJSFAppConfigManager(this);
            this.configLocaters.add(locator);
        }
    }

    protected void startConfigLocaters() {
        for (final IJSFAppConfigLocater configLocater : this.configLocaters) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JSFCorePlugin.log("While starting config locator", e);
                }

                public void run() throws Exception {
                    configLocater.startLocating();
                }
            });
        }
    }

    protected void stopConfigLocaters() {
        for (final IJSFAppConfigLocater configLocater : this.configLocaters) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    JSFCorePlugin.log("Stopping a config locator", exception);
                }

                public void run() throws Exception {
                    configLocater.stopLocating();
                    configLocater.dispose();
                }
            });
        }
    }

    protected void changeProject(IProject newProject) {
        this._project = newProject;
        this.stopConfigLocaters();
        this.startConfigLocaters();
    }

    @Override
    public boolean addJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.add(listener);
    }

    @Override
    public boolean removeJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.remove(listener);
    }

    @Override
    public void notifyJSFAppConfigProvidersChangeListeners(IJSFAppConfigProvider configProvider, int eventType) {
        final JSFAppConfigProvidersChangeEvent event = new JSFAppConfigProvidersChangeEvent(configProvider, eventType);
        for (final IJSFAppConfigProvidersChangeListener listener : this.configProvidersChangeListeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.changedJSFAppConfigProviders(event);
                }

                public void handleException(Throwable exception) {
                    JSFCorePlugin.log("While notifying listeners", exception);
                }
            });
        }
    }

    @Override
    public Object addFacesConfigChangeListener(Class emfClass, IFacesConfigChangeListener listener) {
        this.getFacesConfigModels();
        return this.facesConfigChangeListeners.put(emfClass, listener);
    }

    @Override
    public Object removeFacesConfigChangeListener(Class emfClass) {
        return this.facesConfigChangeListeners.remove(emfClass);
    }

    @Override
    public void notifyFacesConfigChangeListeners(final Notification notification) {
        Class emfClass;
        IFacesConfigChangeListener listener;
        Object emfFeature = notification.getFeature();
        if (emfFeature instanceof EStructuralFeature && (listener = this.facesConfigChangeListeners.get(emfClass = ((EStructuralFeature)emfFeature).getEType().getInstanceClass())) != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    JSFCorePlugin.log("Problem while loading listeners", exception);
                }

                public void run() throws Exception {
                    listener.notifyChanged(notification);
                }
            });
        }
    }

    protected Set<IJSFAppConfigProvider> getJSFAppConfigProviders() {
        final LinkedHashSet<IJSFAppConfigProvider> allConfigProviders = new LinkedHashSet<IJSFAppConfigProvider>();
        for (final IJSFAppConfigLocater configLocater : this.configLocaters) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    allConfigProviders.addAll(configLocater.getJSFAppConfigProviders());
                }

                public void handleException(Throwable exception) {
                    JSFCorePlugin.log("While getting app config providers", exception);
                }
            });
        }
        return allConfigProviders;
    }

    protected List<FacesConfigType> getFacesConfigModels() {
        final ArrayList<FacesConfigType> facesConfigModels = new ArrayList<FacesConfigType>();
        for (final IJSFAppConfigProvider configProvider : this.getJSFAppConfigProviders()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    FacesConfigType facesConfig = configProvider.getFacesConfigModel();
                    if (facesConfig != null) {
                        facesConfigModels.add(facesConfig);
                    }
                }
            });
        }
        return facesConfigModels;
    }

    public void dispose() {
        this.stopConfigLocaters();
        this.configLocaters.clear();
        this.configProvidersChangeListeners.clear();
        this.facesConfigChangeListeners.clear();
    }

    public void destroy() {
        this.dispose();
    }

    public void checkpoint() {
    }

    @Override
    public List<ManagedBeanType> getManagedBeans() {
        ArrayList<ManagedBeanType> allManagedBeans = new ArrayList<ManagedBeanType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList managedBeans = facesConfig.getManagedBean();
            allManagedBeans.addAll((Collection<ManagedBeanType>)managedBeans);
        }
        return allManagedBeans;
    }

    @Override
    public final List<String> getPropertyResolvers() {
        ArrayList<String> allPropertyResolvers = new ArrayList<String>();
        List<ApplicationType> applications = this.getApplications();
        for (ApplicationType application : applications) {
            for (PropertyResolverType propRes : application.getPropertyResolver()) {
                String propClass = propRes.getTextContent();
                if (propClass == null || "".equals(propClass = propClass.trim())) continue;
                allPropertyResolvers.add(propClass);
            }
        }
        return allPropertyResolvers;
    }

    @Override
    public List<ValidatorType> getValidators() {
        ArrayList<ValidatorType> allValidators = new ArrayList<ValidatorType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList validators = facesConfig.getValidator();
            allValidators.addAll((Collection<ValidatorType>)validators);
        }
        return allValidators;
    }

    @Override
    public final List<String> getVariableResolvers() {
        ArrayList<String> allVariableResolvers = new ArrayList<String>();
        List<ApplicationType> applications = this.getApplications();
        for (ApplicationType application : applications) {
            for (VariableResolverType varRes : application.getVariableResolver()) {
                String varClass = varRes.getTextContent();
                if (varClass == null || "".equals(varClass = varClass.trim())) continue;
                allVariableResolvers.add(varClass);
            }
        }
        return allVariableResolvers;
    }

    @Override
    public final List<String> getELResolvers() {
        ArrayList<String> allELResolvers = new ArrayList<String>();
        List<ApplicationType> applications = this.getApplications();
        for (ApplicationType application : applications) {
            for (ELResolverType varRes : application.getELResolver()) {
                String varClass = varRes.getTextContent();
                if (varClass == null || "".equals(varClass = varClass.trim())) continue;
                allELResolvers.add(varClass);
            }
        }
        return allELResolvers;
    }

    @Override
    public List<ConverterType> getConverters() {
        ArrayList<ConverterType> allConverters = new ArrayList<ConverterType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList converters = facesConfig.getConverter();
            allConverters.addAll((Collection<ConverterType>)converters);
        }
        return allConverters;
    }

    @Override
    public List<NavigationRuleType> getNavigationRules() {
        ArrayList<NavigationRuleType> allNavigationRules = new ArrayList<NavigationRuleType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList navigationRules = facesConfig.getNavigationRule();
            allNavigationRules.addAll((Collection<NavigationRuleType>)navigationRules);
        }
        return allNavigationRules;
    }

    @Override
    public List<NavigationRuleType> getNavigationRulesForPage(IFile pageFile) {
        ArrayList<NavigationRuleType> navigationRulesForPage = new ArrayList<NavigationRuleType>();
        IPath pageFilePath = JSFAppConfigUtils.getWebContentFolderRelativePath(pageFile);
        if (pageFilePath != null) {
            String pageFileString = pageFilePath.toString();
            if (!pageFileString.startsWith("/")) {
                pageFileString = "/" + pageFileString;
            }
            List<NavigationRuleType> navigationRules = this.getNavigationRules();
            for (NavigationRuleType navigationRule : navigationRules) {
                FromViewIdType fromViewIdType = navigationRule.getFromViewId();
                if (fromViewIdType != null) {
                    String fromViewId = fromViewIdType.getTextContent();
                    if (fromViewId == null || fromViewId.length() <= 0) continue;
                    if (!fromViewId.equals("*")) {
                        String prefixFromViewId;
                        if (fromViewId.equals(pageFileString)) {
                            navigationRulesForPage.add(navigationRule);
                            continue;
                        }
                        if (!fromViewId.endsWith("*") || !pageFileString.startsWith(prefixFromViewId = fromViewId.substring(0, fromViewId.length() - 1))) continue;
                        navigationRulesForPage.add(navigationRule);
                        continue;
                    }
                    navigationRulesForPage.add(navigationRule);
                    continue;
                }
                navigationRulesForPage.add(navigationRule);
            }
        }
        return navigationRulesForPage;
    }

    @Override
    public List<ApplicationType> getApplications() {
        ArrayList<ApplicationType> allApplications = new ArrayList<ApplicationType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList applications = facesConfig.getApplication();
            allApplications.addAll((Collection<ApplicationType>)applications);
        }
        return allApplications;
    }

    @Override
    public List<FactoryType> getFactories() {
        ArrayList<FactoryType> allFactories = new ArrayList<FactoryType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList factories = facesConfig.getFactory();
            allFactories.addAll((Collection<FactoryType>)factories);
        }
        return allFactories;
    }

    @Override
    public List<ComponentType> getComponents() {
        ArrayList<ComponentType> allComponents = new ArrayList<ComponentType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList components = facesConfig.getComponent();
            allComponents.addAll((Collection<ComponentType>)components);
        }
        return allComponents;
    }

    @Override
    public List<ReferencedBeanType> getReferencedBeans() {
        ArrayList<ReferencedBeanType> allReferencedBeans = new ArrayList<ReferencedBeanType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList referencedBeans = facesConfig.getReferencedBean();
            allReferencedBeans.addAll((Collection<ReferencedBeanType>)referencedBeans);
        }
        return allReferencedBeans;
    }

    @Override
    public List<RenderKitType> getRenderKits() {
        ArrayList<RenderKitType> allRenderKits = new ArrayList<RenderKitType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList renderKits = facesConfig.getRenderKit();
            allRenderKits.addAll((Collection<RenderKitType>)renderKits);
        }
        return allRenderKits;
    }

    @Override
    public List<LifecycleType> getLifecycles() {
        ArrayList<LifecycleType> allLifecycles = new ArrayList<LifecycleType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList lifecycles = facesConfig.getLifecycle();
            allLifecycles.addAll((Collection<LifecycleType>)lifecycles);
        }
        return allLifecycles;
    }

    @Override
    public List<ResourceBundleType> getResourceBundles() {
        ArrayList<ResourceBundleType> allResourceBundles = new ArrayList<ResourceBundleType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            for (ApplicationType appType : facesConfig.getApplication()) {
                allResourceBundles.addAll((Collection<ResourceBundleType>)appType.getResourceBundle());
            }
        }
        return allResourceBundles;
    }

    @Override
    public List<BehaviorType> getBehaviors() {
        ArrayList<BehaviorType> allBehaviors = new ArrayList<BehaviorType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList behaviors = facesConfig.getBehavior();
            allBehaviors.addAll((Collection<BehaviorType>)behaviors);
        }
        return allBehaviors;
    }

    @Override
    public List<FacesConfigExtensionType> getFacesConfigExtensions() {
        ArrayList<FacesConfigExtensionType> allFCExts = new ArrayList<FacesConfigExtensionType>();
        for (FacesConfigType facesConfig : this.getFacesConfigModels()) {
            EList fcExts = facesConfig.getFacesConfigExtension();
            allFCExts.addAll((Collection<FacesConfigExtensionType>)fcExts);
        }
        return allFCExts;
    }

    @Override
    public void addFacesConfigChangeAdapter(FacesConfigType facesConfig) {
        if (facesConfig != null) {
            if (this.facesConfigChangeAdapter == null) {
                this.facesConfigChangeAdapter = new FacesConfigChangeAdapter();
            }
            facesConfig.eAdapters().add((Object)this.facesConfigChangeAdapter);
        }
    }

    @Override
    public void removeFacesConfigChangeAdapter(FacesConfigType facesConfig) {
        if (facesConfig != null && this.facesConfigChangeAdapter != null) {
            facesConfig.eAdapters().remove((Object)this.facesConfigChangeAdapter);
        }
    }

    class FacesConfigChangeAdapter
    extends EContentAdapter {
        FacesConfigChangeAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            AbstractJSFAppConfigManager.this.notifyFacesConfigChangeListeners(notification);
        }
    }
}

