/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ConsoleFilterOutputStream
extends FilterOutputStream {
    StringBuffer buffer = new StringBuffer();

    public ConsoleFilterOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int off, int length) {
        try {
            super.write(data, off, length);
            this.buffer.append(new String(data, off, length, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(int b) throws IOException {
        super.write(b);
        this.buffer.append(new String(ByteBuffer.allocate(4).putInt(b).array(), "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastWritten() {
        ConsoleFilterOutputStream consoleFilterOutputStream = this;
        synchronized (consoleFilterOutputStream) {
            String ret = this.buffer.toString();
            this.buffer = new StringBuffer();
            return ret;
        }
    }
}

