/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util.logger;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileWriter {
    protected int spaces = 0;
    protected static final int TAB_SIZE = 2;
    protected boolean lastPrint = false;
    protected PrintWriter pr = null;
    protected PrintWriter actual = null;
    protected PrintStream pStream = null;
    private OrderedMap<String, String> map = new OrderedMap();
    protected ByteArrayOutputStream br;
    protected int cursorPosition = 0;
    protected int currentLineNonSpaceCharOffset = 0;
    protected boolean autoCommit = false;
    protected String caption = null;

    public TextFileWriter(PrintWriter pr) throws UnsupportedEncodingException {
        this(pr, false);
    }

    public TextFileWriter(PrintWriter pr, boolean autoCommit) throws UnsupportedEncodingException {
        this.autoCommit = autoCommit;
        this.actual = pr;
        if (!autoCommit) {
            this.br = new ByteArrayOutputStream();
            this.pr = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.br, "UTF-8"), true);
        } else {
            this.pr = pr;
        }
    }

    public TextFileWriter(PrintStream stream) {
        this.pStream = stream;
        this.pr = null;
    }

    public void close() {
        if (this.actual != null) {
            this.actual.close();
        }
    }

    public void flush() {
        if (this.actual != null) {
            this.actual.flush();
        }
    }

    public void printContextSpace() {
        this.printSpace(this.spaces * 2);
    }

    public String getSpace(int length) {
        return CloudUtil.padChar(length, ' ', "", length, true);
    }

    public String getContextSpace() {
        return this.getSpace(this.spaces * 2);
    }

    public void printSpace(int length) {
        boolean count = this.cursorPosition == 0;
        for (int i = 0; i < length; ++i) {
            if (this.pStream != null) {
                this.pStream.print(" ");
            } else {
                this.pr.print(" ");
            }
            if (count) {
                ++this.currentLineNonSpaceCharOffset;
            }
            ++this.cursorPosition;
        }
        this.lastPrint = true;
    }

    public void tab() {
        ++this.spaces;
    }

    public void shiftTab() {
        --this.spaces;
    }

    public void println() {
        this.println(false, false);
    }

    public void println(boolean align, boolean lastCursor) {
        int space = lastCursor ? this.cursorPosition : this.currentLineNonSpaceCharOffset;
        this.println("");
        if (align) {
            this.printSpace(space);
        }
    }

    public void println(String s) {
        this.println(s, true);
    }

    public void println(String s, boolean alignSpace) {
        this.println(s, alignSpace, true);
    }

    public void println(String s, boolean alignSpace, boolean printcaption) {
        if (printcaption) {
            this.print(this.getCaptionToPrint());
        }
        if (alignSpace) {
            this.printContextSpace();
        }
        if (this.pStream != null) {
            this.pStream.print(s + "\r\n");
            this.pStream.flush();
        } else {
            this.pr.println(s);
            this.pr.flush();
        }
        this.lastPrint = false;
        this.cursorPosition = 0;
        this.currentLineNonSpaceCharOffset = 0;
    }

    public void print(String s) {
        if (!this.lastPrint) {
            this.printContextSpace();
        }
        if (this.pStream != null) {
            this.pStream.print(s);
        } else {
            this.pr.print(s);
        }
        this.cursorPosition += s.length();
        this.lastPrint = true;
    }

    public void printBinaryAsString(byte[] data) throws UnsupportedEncodingException {
        if (data != null) {
            if (this.pStream != null) {
                this.pStream.print(new String(data, "UTF-8"));
            } else {
                this.pr.print(new String(data, "UTF-8"));
            }
        }
    }

    public void commit() {
        try {
            if (!this.autoCommit) {
                StringBuffer buf = new StringBuffer(this.br.toString("UTF-8"));
                this.actual.print(buf);
            }
            this.actual.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printCommentStart() {
        this.print("# ");
    }

    public void printlnComment(String comment) {
        List<String> lines = CloudUtil.parseString(comment, "\n");
        for (String line : lines) {
            this.printCommentStart();
            this.println(line);
        }
        this.println();
    }

    public void printUnderLined(String text) {
        this.printUnderLined(text, '-');
    }

    public void printUnderLined(String text, char with) {
        this.println(text);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            buf.append(with);
        }
        this.println(buf.toString());
    }

    public OrderedMap<String, String> initMapText() {
        return this.map;
    }

    public String getCaptionToPrint() {
        if (this.caption != null && !this.caption.equals("")) {
            return "[" + this.caption + "] ";
        }
        return "";
    }

    public int getCaptionLength() {
        return this.getCaptionToPrint().length();
    }

    public void addMapText(String name, Object value) {
        this.map.put(name, value == null ? "" : value.toString(), true);
    }

    public int endMapText() {
        int x = this.endMapText(89);
        this.flush();
        return x;
    }

    public int endMapText(int maxLineLength) {
        int allignLength = CloudUtil.getKeyMaxLength(this.map);
        String spaces = this.getContextSpace();
        for (NameValuePair<String, String> pair : this.map.getList()) {
            String key = pair.getName();
            if (key == null) {
                this.println();
                continue;
            }
            String value = pair.getValue();
            if (value == null) {
                value = "";
            }
            this.println(CloudUtil.convertToHelpText(spaces + this.getCaptionToPrint() + CloudUtil.padChar(allignLength, ' ', key.trim(), allignLength, true) + " - " + value, maxLineLength, allignLength + 3 + this.getCaptionLength() + spaces.length()), false, false);
        }
        this.map.clear();
        return allignLength;
    }

    public void printComment(String t) {
        this.printlnComment(t);
    }

    public void printComment(Throwable t) {
        String[] messages = CloudUtil.getAllInnerErrorMessages(t);
        this.printlnComment("Exception has occurred.");
        for (int i = 0; i < messages.length; ++i) {
            if (i != 0) {
                this.printlnComment("\tCaused By ->" + messages[i]);
                continue;
            }
            this.printlnComment(messages[i]);
        }
    }

    public PrintWriter getActual() {
        return this.actual;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void reSetCaption() {
        this.caption = null;
    }

    public String getCaption() {
        return this.caption;
    }
}

