/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    static final char quote = '\"';

    public static List<String> parseWithQuote(String input, String with) {
        return StringUtils.parseWithQuote(input, with, '\"');
    }

    private static String stripQuote(String s, char q) {
        if (s.length() > 1 && s.startsWith(String.valueOf(q)) && s.endsWith(String.valueOf(q))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String unEscape(String where, char quote) {
        boolean escaping = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < where.length(); ++i) {
            char c = where.charAt(i);
            if (escaping) {
                if (c == '\\') {
                    buffer.append(c);
                } else if (c == quote) {
                    buffer.append(c);
                } else {
                    buffer.append(c);
                }
                escaping = false;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static List<String> parseWithQuote(String input, String with, char quote) {
        ArrayList<String> ret = new ArrayList<String>();
        if (input == null) {
            return ret;
        }
        int index_D = StringUtils.findIndexOf(with, input, quote);
        while (index_D >= 0) {
            String text = input.substring(0, index_D);
            if (text.length() > 0) {
                ret.add(StringUtils.unEscape(StringUtils.stripQuote(text, quote), quote));
            }
            input = input.substring(index_D + with.length(), input.length());
            index_D = StringUtils.findIndexOf(with, input, quote);
        }
        if (!input.trim().equals("")) {
            ret.add(StringUtils.unEscape(StringUtils.stripQuote(input, quote), quote));
        }
        return ret;
    }

    public static int findIndexOf(String what, String where, char quote) {
        if (where == null || what == null) {
            return -1;
        }
        boolean insideQuote = false;
        boolean escaping = false;
        for (int i = 0; i < where.length(); ++i) {
            if (where.length() - i < what.length()) {
                return -1;
            }
            char c = where.charAt(i);
            if (c == '\\') {
                escaping = !escaping;
                continue;
            }
            if (c == quote) {
                if (!escaping) {
                    insideQuote = !insideQuote;
                }
                escaping = false;
                continue;
            }
            if (!insideQuote && where.substring(i, where.length()).startsWith(what)) {
                return i;
            }
            escaping = false;
        }
        if (insideQuote) {
            throw new IllegalArgumentException("Un-matched quote.");
        }
        if (escaping) {
            throw new IllegalArgumentException("Invalid escape sequence.");
        }
        return -1;
    }
}

