/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.MainBase;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.StringUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudUtil {
    public static final Random random = new Random();
    static final String[] wrapCutText = new String[]{" ", "/", "\\", ";", "|", ")", "}", "]", ","};
    static final String[] wrapCutText_finally = new String[]{"_", "-", ".", "=", ":"};
    static final String[] wrapCutText_NOT_ENDING = new String[]{"://", ":/"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deSerialize(JAXBContext context, ClassLoader cl, InputStream in) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Object object = context.createUnmarshaller().unmarshal(in);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File to, File from) throws Exception {
        if (!to.getCanonicalPath().equalsIgnoreCase(from.getCanonicalPath())) {
            FileInputStream in = new FileInputStream(from);
            try {
                CloudUtil.writeToFile(to, in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    public static boolean isCausedBy(Throwable actual, Class causeClass) {
        return CloudUtil.getCause(actual, causeClass) != null;
    }

    public static <T> T getCause(Throwable actual, Class<T> causeClass) {
        if (causeClass.isAssignableFrom(actual.getClass())) {
            return (T)actual;
        }
        if (actual.getCause() == null) {
            return null;
        }
        return CloudUtil.getCause(actual.getCause(), causeClass);
    }

    public static String getDynamicIdentifier(int length) {
        if (length < 0) {
            return null;
        }
        int q = length / 3;
        int r = length % 3;
        StringBuffer buf = new StringBuffer("");
        if (q > 0) {
            buf.append(CloudUtil.getRandomString(65, 90, q));
            buf.append(CloudUtil.getRandomString(48, 57, q));
            buf.append(CloudUtil.getRandomString(97, 122, q));
        }
        buf.append(CloudUtil.getRandomString(65, 90, r));
        return buf.toString();
    }

    public static String getRandomString(int asciiFrom, int asciiTo, int length) {
        if (asciiFrom > asciiTo || length < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        int dif = asciiTo - asciiFrom + 1;
        for (int i = 0; i < length; ++i) {
            int num = random.nextInt();
            if (num < 0) {
                num = -num;
            }
            num = num % dif + asciiFrom;
            buf.append((char)num);
        }
        return buf.toString();
    }

    public static String getDynamicIdentifier() {
        int next = random.nextInt();
        if (next < 0) {
            next = -next;
        }
        return CloudUtil.getDynamicIdentifier(next % 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, InputStream in) throws Exception {
        FileOutputStream out = new FileOutputStream(CloudUtil.validateOutputFile(file.getAbsolutePath(), true));
        try {
            CloudUtil.pipe(out, in);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(OutputStream out, InputStream in) throws IOException {
        byte[] buffer = new byte[102400];
        int read = in.read(buffer);
        while (read >= 0) {
            out.write(buffer, 0, read);
            out.flush();
            read = in.read(buffer);
        }
    }

    public static void writeToFile(File file, byte[] content) throws Exception {
        if (content == null) {
            return;
        }
        FileOutputStream out = null;
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new Exception("Path could not be created.");
            }
            if (!file.createNewFile()) {
                throw new Exception("File could not be created.");
            }
        }
        try {
            out = new FileOutputStream(file);
            out.write(content);
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static OrderedMap<String, String> parseCommandlineProperties(String value, String propSeparator) {
        OrderedMap<String, String> ret = new OrderedMap<String, String>();
        if (value == null) {
            return ret;
        }
        if (propSeparator == null) {
            propSeparator = ",";
        }
        List<String> list = StringUtils.parseWithQuote(value, propSeparator);
        for (String token : list) {
            int index = token.indexOf("=");
            String name = null;
            String val = null;
            if (index < 0) {
                name = token;
                val = "";
            } else {
                name = token.substring(0, index);
                val = token.substring(index + 1, token.length());
            }
            ret.put(name, val);
        }
        return ret;
    }

    public static byte[] readAllFromFile(String file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] byArray = CloudUtil.readAllFrom(fis, false);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read file:" + file, e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    Logger.getDEFAULT().printlnThrowable(e);
                }
            }
        }
    }

    public static byte[] readAllFrom(InputStream in, boolean chunked) {
        if (in == null) {
            throw new RuntimeException("Stream can't be null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            while (len > 0) {
                byte[] check;
                bos.write(buf, 0, len);
                if (!chunked || (check = new String(bos.toByteArray(), "UTF-8").trim().getBytes("UTF-8")).length < 1 || check[check.length - 1] != 48 || check.length != 1 && check[check.length - 2] != 10) {
                    len = in.read(buf);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read:", e);
        }
        return bos.toByteArray();
    }

    public static String findShortCutText(String in) {
        if (in == null || in.trim().equals("")) {
            return null;
        }
        StringBuffer ret = new StringBuffer(in.substring(0, 1));
        for (int i = 1; i < in.length(); ++i) {
            if (in.charAt(i) < 'A' || in.charAt(i) > 'Z') continue;
            ret.append(in.charAt(i));
        }
        return ret.toString().toLowerCase();
    }

    public static String getCommaSeparatedListOfString(String[] list) {
        if (list == null) {
            return null;
        }
        return CloudUtil.getCommaSeparatedListOfString(Arrays.asList(list));
    }

    public static String parseAndRemoveDuplicatesClassPath(String s) {
        return CloudUtil.parseAndRemoveDuplicates(s, File.pathSeparator);
    }

    public static String parseAndRemoveDuplicates(String s, String del) {
        if (s == null) {
            return s;
        }
        List<String> list = CloudUtil.parseString(s, del);
        HashSet<String> set = new HashSet<String>();
        for (String item : list) {
            set.add(item);
        }
        return CloudUtil.getSeparatedListOfString(set, "", "", false, del);
    }

    public static List<String> parseString(String s) {
        return CloudUtil.parseString(s, ",");
    }

    public static String[] parseString2StringArray(String s) {
        List<String> list = CloudUtil.parseString(s);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public static List<String> parseString(String s, String del) {
        return CloudUtil.parseString(s, del, false);
    }

    public static List<String> parseString(String s, String del, boolean ignoreNull) {
        if (s == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (del == null) {
            ret.add(s);
            return ret;
        }
        StringTokenizer token = new StringTokenizer(s, del);
        while (token.hasMoreTokens()) {
            String tokenSingle = token.nextToken();
            boolean toAdd = true;
            if (ignoreNull && "".equals(tokenSingle = tokenSingle.trim())) {
                toAdd = false;
            }
            if (!toAdd) continue;
            ret.add(tokenSingle);
        }
        return ret;
    }

    public static String getCommaSeparatedListOfString(Collection<String> list) {
        return CloudUtil.getCommaSeparatedListOfString(list, "(", ")", true);
    }

    public static String getSimpleCommaSeparatedListOfString(String[] list) {
        if (list == null) {
            return null;
        }
        return CloudUtil.getCommaSeparatedListOfString(list, "", "", false);
    }

    public static String getCommaSeparatedListOfString(String[] list, String open, String close, boolean singleQuoteElement) {
        List<String> listStr = null;
        if (list != null) {
            listStr = Arrays.asList(list);
        }
        return CloudUtil.getCommaSeparatedListOfString(listStr, open, close, singleQuoteElement);
    }

    public static String getCommaSeparatedListOfString(Collection<String> list, String open, String close, boolean singleQuoteElement) {
        return CloudUtil.getSeparatedListOfString(list, open, close, singleQuoteElement, ",");
    }

    public static String getSeparatedListOfString(Collection<String> list, String open, String close, boolean singleQuoteElement, String separator) {
        if (list == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(open);
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String item = it.next();
            if (singleQuoteElement) {
                buffer.append("'" + item + "'");
            } else {
                buffer.append(item);
            }
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        buffer.append(close);
        return buffer.toString();
    }

    public static List<String> getEnumValuesAsList(Class cls) {
        return CloudUtil.getEnumValuesAsList(cls, null);
    }

    public static List<String> getEnumValuesAsList(Class cls, String toBeRemoved) {
        return CloudUtil.getEnumValuesAsList(cls, toBeRemoved, false);
    }

    public static List<String> getEnumValuesAsList(Class cls, String toBeRemoved, boolean tolower) {
        Enum[] en = (Enum[])cls.getEnumConstants();
        return CloudUtil.getEnumValuesAsList(en, toBeRemoved, tolower);
    }

    public static List<String> getEnumValuesAsList(Enum[] en) {
        return CloudUtil.getEnumValuesAsList(en, null);
    }

    public static List<String> getEnumValuesAsList(Enum[] en, String toBeRemoved) {
        return CloudUtil.getEnumValuesAsList(en, toBeRemoved, false);
    }

    public static List<String> getEnumValuesAsList(Enum[] en, String toBeRemoved, boolean lowercase) {
        ArrayList<String> values = new ArrayList<String>(en.length);
        for (int i = 0; i < en.length; ++i) {
            if (toBeRemoved != null && toBeRemoved.equals(en[i].name())) continue;
            if (lowercase) {
                values.add(en[i].name().toLowerCase());
                continue;
            }
            values.add(en[i].name());
        }
        return values;
    }

    public static int getKeyMaxLength(List<CommandLineArg> args) {
        Hashtable<String, CommandLineArg> map = new Hashtable<String, CommandLineArg>();
        if (args != null) {
            for (CommandLineArg arg : args) {
                map.put(arg.getOptionName(), arg);
            }
        }
        return CloudUtil.getKeyMaxLength(map);
    }

    public static int getKeyMaxLengthProcessEachCommand(OrderedMap<String, CommandLine> map) {
        int max = CloudUtil.getKeyMaxLength(map);
        if (map.getList() != null) {
            for (NameValuePair<String, CommandLine> cmd : map.getList()) {
                int cmdLength = CloudUtil.getKeyMaxLength(cmd.getValue().getArgs());
                if (cmdLength <= max) continue;
                max = cmdLength;
            }
        }
        return max;
    }

    public static int getKeyMaxLength(Map map) {
        if (map == null) {
            return 0;
        }
        int maxLength = 0;
        for (Object obj : map.keySet()) {
            if (obj == null || obj.toString().length() <= maxLength) continue;
            maxLength = obj.toString().length();
        }
        return maxLength;
    }

    public static boolean isHttpUrl(String urlString) throws Exception {
        return CloudUtil.isProtocolMatching(urlString, "http");
    }

    public static boolean isFtpUrl(String urlString) throws Exception {
        return CloudUtil.isProtocolMatching(urlString, "ftp");
    }

    public static boolean isProtocolMatching(String urlStr, String pcol) throws Exception {
        if (urlStr == null) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException me) {
            return urlStr.startsWith(pcol + ":");
        }
        String p = url.getProtocol();
        if (p == null) {
            return false;
        }
        return p.equalsIgnoreCase(pcol);
    }

    public static void handleFinalException(Throwable e, boolean standalone) {
        if (ClassNotFoundException.class == e.getClass()) {
            Logger.getDEFAULT().printlnErrorI18n("ERROR_UNKNOWN_CAUSE_UNABLE_TO_FIND_CLASS");
        }
        if (NoClassDefFoundError.class.isAssignableFrom(e.getClass())) {
            Logger.getDEFAULT().printlnErrorI18n("ERROR_UNKNOWN_CAUSE_UNABLE_TO_LOAD_CLASS");
        }
        if (NullPointerException.class == e.getClass()) {
            Logger.getDEFAULT().printlnErrorI18n("ERROR_UNKNOWN_NPE");
        }
        if (ClassCastException.class == e.getClass()) {
            Logger.getDEFAULT().printlnErrorI18n("NLS_ERROR_UN_EXPECTED_CCE");
        }
        if (CloudUtil.isCausedBy(e, ConnectException.class) || CloudUtil.isCausedBy(e, UnknownHostException.class)) {
            Logger.getDEFAULT().printlnTipI18n("NLS_ERROR_CONNECT_EXCEPTION", "httpproxy");
        }
        String[] messages = CloudUtil.getAllInnerErrorMessages(e);
        int count = 0;
        String allMsg = null;
        for (String mes : messages) {
            if (count != 0) {
                allMsg = allMsg + "\n|";
                allMsg = allMsg + "\n+" + CloudUtil.getString("-", count * 3) + "-> Caused By : " + mes;
            } else {
                allMsg = mes;
            }
            ++count;
        }
        if (standalone) {
            Logger.getDEFAULT().printlnError(allMsg);
        }
        Logger.getDEFAULT().printlnThrowable(e);
    }

    public static String getString(String sp, int count) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            ret.append(sp);
        }
        return ret.toString();
    }

    public static boolean isHttpsUrl(String urlString) {
        try {
            return CloudUtil.isProtocolMatching(urlString, "https");
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnThrowable(e);
            return false;
        }
    }

    public static String[] getAllInnerErrorMessages(Throwable th) {
        ArrayList<String> all = new ArrayList<String>();
        boolean msgFound = false;
        while (th != null) {
            if (th.getMessage() != null && !th.getMessage().trim().equals("")) {
                if (!msgFound && all.size() > 0) {
                    all.add(0, th.getMessage());
                }
                all.add(th.getMessage());
                msgFound = true;
            } else {
                all.add(th.getClass().getName());
            }
            th = th.getCause();
        }
        return all.toArray(new String[0]);
    }

    public static String convertToToolTip(String source) {
        return CloudUtil.convertToHelpText(source, 80, 1);
    }

    public static long getLastModifiedDate(File dir) {
        long sub;
        int i;
        if (!dir.exists()) {
            return 0L;
        }
        if (dir.isFile()) {
            return dir.lastModified();
        }
        String[] files = CloudUtil.findDirectoriesWithPatternAt(dir, null);
        long ret = dir.lastModified();
        for (i = 0; i < files.length; ++i) {
            sub = CloudUtil.getLastModifiedDate(new File(dir, files[i]));
            if (ret >= sub) continue;
            ret = sub;
        }
        files = CloudUtil.findFilesWithPatternAt(dir, null);
        for (i = 0; i < files.length; ++i) {
            sub = CloudUtil.getLastModifiedDate(new File(dir, files[i]));
            if (ret >= sub) continue;
            ret = sub;
        }
        return ret;
    }

    public static String getFileExtension(String path) {
        if (path == null) {
            throw new RuntimeException("path can not be null");
        }
        int last_index = path.lastIndexOf(".");
        if (last_index < 0) {
            return null;
        }
        return path.substring(last_index + 1, path.length());
    }

    public static String getFileBaseName(String fileName) {
        if (fileName == null) {
            throw new RuntimeException("fileName can not be null");
        }
        int index = fileName.indexOf(".");
        if (index < 0) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static void main(String[] s) throws Exception {
        System.out.println(CloudUtil.convertToHelpText("ab\nb", 2, 0));
    }

    public static String convertToHelpText(String source, int eachLineMaxLength, int nextLineOffset) {
        if (eachLineMaxLength <= 0) {
            eachLineMaxLength = 80;
        }
        if (source == null) {
            return null;
        }
        source = source.replaceAll("\t", "   ");
        StringBuffer ret = new StringBuffer("");
        boolean alreadyCut = false;
        while (source.length() > eachLineMaxLength || source.contains("\n")) {
            boolean newLine = false;
            boolean cutAtMax = false;
            int lastIndexAtSpace = (source.length() > eachLineMaxLength ? source.substring(0, eachLineMaxLength + 1) : source).indexOf("\n");
            if (lastIndexAtSpace < 0) {
                String end;
                boolean endSwith;
                String cut;
                int temp;
                int i;
                for (i = 0; i < wrapCutText.length; ++i) {
                    temp = 0;
                    cut = source.substring(0, eachLineMaxLength);
                    temp = cut.lastIndexOf(wrapCutText[i]);
                    if (temp > 0) {
                        endSwith = false;
                        end = cut.substring(0, temp);
                        for (String e : wrapCutText_NOT_ENDING) {
                            if (!end.endsWith(e)) continue;
                            endSwith = true;
                            break;
                        }
                        if (endSwith) {
                            temp = -1;
                        }
                    }
                    if (temp <= lastIndexAtSpace) continue;
                    lastIndexAtSpace = temp;
                }
                if (lastIndexAtSpace < 0) {
                    for (i = 0; i < wrapCutText_finally.length; ++i) {
                        temp = 0;
                        cut = source.substring(0, eachLineMaxLength);
                        temp = cut.lastIndexOf(wrapCutText_finally[i]);
                        if (temp > 0) {
                            endSwith = false;
                            end = cut.substring(0, temp);
                            for (String e : wrapCutText_NOT_ENDING) {
                                if (!end.endsWith(e)) continue;
                                endSwith = true;
                                break;
                            }
                            if (endSwith) {
                                temp = -1;
                            }
                        }
                        if (temp <= lastIndexAtSpace) continue;
                        lastIndexAtSpace = temp;
                    }
                }
            } else {
                newLine = true;
            }
            if (lastIndexAtSpace < 0) {
                lastIndexAtSpace = eachLineMaxLength;
                cutAtMax = true;
            }
            String line = source.substring(0, newLine ? lastIndexAtSpace : (cutAtMax ? lastIndexAtSpace : lastIndexAtSpace + 1));
            ret.append(line);
            ret.append("\n");
            source = source.substring(newLine ? lastIndexAtSpace + 1 : (cutAtMax ? lastIndexAtSpace : lastIndexAtSpace + 1), source.length());
            for (int i = 0; i < nextLineOffset; ++i) {
                ret.append(" ");
            }
            if (eachLineMaxLength <= nextLineOffset || alreadyCut) continue;
            eachLineMaxLength -= nextLineOffset;
            alreadyCut = true;
        }
        ret.append(source);
        return ret.toString();
    }

    public static String padChar(int minLength, char what, String where, int maxLength, boolean addToRight) {
        if (where == null) {
            return null;
        }
        for (int i = where.length(); i < minLength && where.length() < maxLength; ++i) {
            where = addToRight ? where + what : what + where;
        }
        if (maxLength > 0 && where.length() > maxLength) {
            where = where.substring(0, maxLength);
        }
        return where;
    }

    public static void validateHttpUrl(String url, String name) throws Exception {
        Exception e = null;
        try {
            if (CloudUtil.isHttpUrl(url) || CloudUtil.isHttpsUrl(url)) {
                return;
            }
        }
        catch (Exception e1) {
            e = e1;
        }
        throw new Exception(NLSUtil.localizeMessage("NLS_ERR_INVALID_HTTP_PROTOCOL", name), e);
    }

    public static File validateOutputDir(String dir) throws Exception {
        File file = new File(dir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception(NLSUtil.localizeMessage("NLS_ERR_PATH_SHOULD_BE_A_DIR", dir));
            }
        } else if (!file.mkdirs()) {
            throw new Exception(NLSUtil.localizeMessage("NLS_ERR_UNABLE_TO_CREATE_PATH", file.getAbsolutePath()));
        }
        return file;
    }

    public static File validateOutputFile(String fileStr, boolean createParent) throws Exception {
        File file = new File(fileStr);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception(NLSUtil.localizeMessage("NLS_ERR_PATH_SHOULD_BE_A_FILE", fileStr));
            }
        } else if (createParent && file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("Output dir '" + fileStr + "' could not be created.");
        }
        return file;
    }

    public static File validateOutputFileRuntimeException(String fileStr, boolean createParent) {
        try {
            return CloudUtil.validateOutputFile(fileStr, createParent);
        }
        catch (Exception e) {
            throw new RuntimeException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    public static File validateInputDirOnlyRuntimeException(String dir) {
        try {
            return CloudUtil.validateInputDir(dir);
        }
        catch (Exception e) {
            throw new RuntimeException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    public static File validateInputDir(String dir) throws Exception {
        return CloudUtil.validateInputDir(dir, "Directory");
    }

    public static File validateInputDir(String dir, String dirName) throws Exception {
        if (dir == null) {
            throw new Exception(dirName + " path can't be null");
        }
        File file = new File(dir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception("Path " + dir + " should be a directory for " + dirName);
            }
        } else {
            throw new Exception(dirName + " does not exist.:" + dir);
        }
        return file;
    }

    public static File validateInputPath(String fileStr) throws Exception {
        if (fileStr == null) {
            throw new Exception("Input path can't be null");
        }
        File file = new File(fileStr);
        if (!file.exists()) {
            throw new Exception("Path does not exist:" + fileStr);
        }
        return file;
    }

    public static File validateInputFile(String fileStr) throws Exception {
        return CloudUtil.validateInputFile(fileStr, "File");
    }

    public static File validateInputFile(String fileStr, String argName) throws Exception {
        if (fileStr == null) {
            throw new Exception(argName + " can't be null");
        }
        File file = new File(fileStr);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception(argName + " \"" + fileStr + "\" should be a file.");
            }
        } else {
            throw new Exception(argName + " \"" + fileStr + "\" does not exist.");
        }
        return file;
    }

    public static String[] findDirectoriesWithPatternAt(File dir, final String pattern) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!new File(dir, name).isDirectory()) {
                    return false;
                }
                if (pattern == null) {
                    return true;
                }
                Pattern pat = Pattern.compile(pattern);
                Matcher matcher = pat.matcher(name);
                return matcher.matches();
            }
        });
    }

    public static List<String> recurseFindFilesWithPatternAt(File dir, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        CloudUtil.recurseFindAndAddFilesWithPatternAt(dir, "", pattern, list);
        return list;
    }

    public static void recurseFindAndAddFilesWithPatternAt(File dir, String offset, String pattern, List<String> list) {
        String[] dirs;
        File effectiveDir = new File(dir, offset);
        String[] files = CloudUtil.findFilesWithPatternAt(effectiveDir, pattern);
        if (files != null) {
            for (String file : files) {
                list.add(offset + file);
            }
        }
        if ((dirs = CloudUtil.findDirectoriesWithPatternAt(effectiveDir, null)) != null) {
            for (String sub : dirs) {
                CloudUtil.recurseFindAndAddFilesWithPatternAt(dir, offset + sub + File.separator, pattern, list);
            }
        }
    }

    public static String[] findFilesWithPatternAt(File dir, final String pattern) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (!new File(dir, name).isFile()) {
                    return false;
                }
                if (pattern == null) {
                    return true;
                }
                Pattern pat = Pattern.compile(pattern);
                Matcher matcher = pat.matcher(name);
                return matcher.matches();
            }
        });
    }

    public static String textEncodetoXML(String value, boolean toHtml) {
        if (value == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '<') {
                buff.append("&lt;");
                continue;
            }
            if (c == '>') {
                buff.append("&gt;");
                continue;
            }
            if (c == '&') {
                buff.append("&amp;");
                continue;
            }
            if (c == '\'') {
                buff.append("&apos;");
                continue;
            }
            if (c == '\"') {
                buff.append("&quot;");
                continue;
            }
            if (c == '\r' && i + 1 < value.length() && value.charAt(i + 1) == '\n') {
                if (toHtml) {
                    buff.append("<br/>");
                    buff.append("\r\n");
                } else {
                    buff.append("&#xd;");
                }
                ++i;
                continue;
            }
            if (c == ' ' && toHtml) {
                buff.append("&nbsp;");
                continue;
            }
            if (c == '\n' && toHtml) {
                buff.append("<br/>");
                continue;
            }
            if ((c == '\u0000' || c == '\u0007' || c == '\b' || c == '\n' || c == '\f') && toHtml) {
                buff.append(" ");
                continue;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static URLClassLoader createURLClassLoader(String classpath) throws Exception {
        return CloudUtil.createURLClassLoader(classpath, Thread.currentThread().getContextClassLoader());
    }

    public static URLClassLoader createURLClassLoader(String classpath, final ClassLoader parent) throws Exception {
        if (classpath == null) {
            classpath = "";
        }
        Logger.getDEFAULT().printlnFine("Creating URL classloader with " + classpath);
        final ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            File file = new File(tokenizer.nextToken());
            if (!file.exists()) continue;
            urls.add(file.toURI().toURL());
        }
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(urls.toArray(new URL[0]), parent);
            }
        });
    }

    public static String[] adjustArgs(String[] s, OrderedMap<String, CommandLine> all) throws CliException {
        String c;
        String arg;
        int cmdIndex = s.length - 1;
        while (!(arg = s[cmdIndex]).startsWith("-") || all.get(c = arg.substring(1, arg.length())) == null && MainBase.findByAlias(c, all) == null) {
            if (--cmdIndex != -1) continue;
            return s;
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(s[cmdIndex]);
        for (int i = 0; i < s.length; ++i) {
            if (i == cmdIndex) continue;
            ret.add(s[i]);
        }
        return ret.toArray(new String[0]);
    }
}

