/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase.display;

import java.util.ArrayList;
import java.util.List;
import oracle.cloudlogic.javaservice.common.clibase.display.Cell;
import oracle.cloudlogic.javaservice.common.clibase.display.HeaderCell;
import oracle.cloudlogic.javaservice.common.clibase.display.Row;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.ProcessUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.TextFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid {
    public static final String GRID_USE_GRAPHICS_CHARS = "GRID_USE_GRAPHICS_CHARS";
    private final OrderedMap<String, HeaderCell> columns = new OrderedMap();
    public static final boolean useGrphics = ProcessUtil.isOS_WINDOWS() && Boolean.getBoolean("GRID_USE_GRAPHICS_CHARS");
    static final char TAB_LEFT_TOP = (char)(useGrphics ? 201 : 35);
    static final char TAB_RIGHT_TOP = (char)(useGrphics ? 187 : 35);
    static final char TITLE_VERTICAL = (char)(useGrphics ? 186 : 124);
    static final char TABLE_BOTTOM_LEFT = (char)(useGrphics ? 192 : 43);
    static final char TABLE_BOTTOM_RIGHT = (char)(useGrphics ? 217 : 43);
    static final char TABLE_BOTTOM_SPLIT = (char)(useGrphics ? 193 : 43);
    static final char TITLE_HORIZONTAL = (char)(useGrphics ? 205 : 61);
    static final char TITLE_SPLIT_DOWN = (char)(useGrphics ? 203 : 35);
    static final char VERTICAL = (char)(useGrphics ? 179 : 124);
    private static final char VERTICAL_WITH_RIGHT = (char)(useGrphics ? 195 : 124);
    private static final char TITLE_VERTICAL_WITH_RIGHT = (char)(useGrphics ? 185 : 124);
    private static final char TITLE_VERTICAL_WITH_LEFT = (char)(useGrphics ? 204 : 124);
    private static final char VERTICAL_WITH_LEFT = (char)(useGrphics ? 180 : 124);
    public static final char HORIZONTAL = (char)(useGrphics ? 196 : 45);
    private static final char PLUS = (char)(useGrphics ? 197 : 43);
    private static final char TITLE_PLUS = (char)(useGrphics ? 206 : 124);
    private final List<Row> rows = new ArrayList<Row>();

    public int getMaxLinesInHeaders() {
        int lineCount = 0;
        for (int i = 0; i < this.columns.getList().size(); ++i) {
            if (lineCount >= this.columns.getList().get(i).getValue().getLinesCount()) continue;
            lineCount = this.columns.getList().get(i).getValue().getLinesCount();
        }
        return lineCount;
    }

    public HeaderCell addColumn(String name) {
        HeaderCell c = new HeaderCell();
        c.setContent(name);
        c.setWidth(name.length());
        this.columns.put(name, c);
        return c;
    }

    public void removeColumn(int i) {
        this.columns.getList().remove(i);
        for (Row row : this.rows) {
            row.getCells().remove(i);
        }
    }

    public void removeEmptyColumns() {
        for (Row row : this.rows) {
            for (Cell c : row.getCells()) {
                if (c.getInnderGrid() == null) continue;
                c.getInnderGrid().removeEmptyColumns();
            }
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.hasAnyDataAtColumn(i)) continue;
            this.removeColumn(i);
            --i;
        }
    }

    public boolean hasAnyDataAtColumn(int i) {
        for (Row row : this.rows) {
            if (row.getCells().get(i).getInnderGrid() != null) {
                for (int j = 0; j < row.getCells().get((int)i).getInnderGrid().columns.size(); ++j) {
                    if (!row.getCells().get(i).getInnderGrid().hasAnyDataAtColumn(j)) continue;
                    return true;
                }
                continue;
            }
            if (row.getCells().get(i).getContent() == null) continue;
            return true;
        }
        return false;
    }

    public int getExtraWidthAtColumn(int i) {
        HeaderCell c = this.columns.getList().get(i).getValue();
        if (c.getWidth() == 1) {
            return 0;
        }
        int extraWidth = c.getWidth() - 1;
        for (Row r : this.rows) {
            int e = r.getCells().get(i).getExtraWidth(c.getWidth());
            if (e < extraWidth) {
                extraWidth = e;
            }
            if (extraWidth != 0) continue;
            return 0;
        }
        return extraWidth;
    }

    public HeaderCell getColumnWithMoreExtraWidth() {
        int index = 0;
        int extra = this.getExtraWidthAtColumn(0);
        for (int i = 1; i < this.columns.getList().size(); ++i) {
            int e = this.getExtraWidthAtColumn(i);
            if (e <= extra) continue;
            index = i;
            extra = e;
        }
        if (this.getExtraWidthAtColumn(index) > 0) {
            return this.columns.getList().get(index).getValue();
        }
        return null;
    }

    public void checkAndAddColumn(String name) {
        int index = this.getColumnIndex(name);
        if (index < 0) {
            this.addColumn(name);
        }
    }

    public Row createNewRow() {
        Row r = new Row(this.columns.size());
        this.rows.add(r);
        return r;
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.getList().size(); ++i) {
            if (!name.equals(this.columns.getList().get(i).getValue().getContent())) continue;
            return i;
        }
        return -1;
    }

    public void resetFormatting(boolean verticalAlign) {
        int c = 0;
        for (NameValuePair<String, HeaderCell> pair : this.columns.getList()) {
            pair.getValue().cutWithWidth(pair.getValue().getWidth(), verticalAlign);
            for (Row r : this.rows) {
                Cell cell = r.getCells().get(c);
                cell.cutWithWidth(pair.getValue().getWidth(), verticalAlign);
            }
            ++c;
        }
        if (verticalAlign) {
            for (Row r : this.rows) {
                r.verticalAlign();
            }
        }
    }

    public int getMaxLinesAtCell(int c, boolean excludeTitle) {
        int max = excludeTitle ? 0 : this.columns.getList().get(c).getValue().getLinesCount() - this.columns.getList().get(c).getValue().getOriginalLinesCount() - this.columns.getList().get(c).getValue().getVerticalAlignExtraLineAdded();
        for (Row r : this.rows) {
            boolean swap = false;
            int maxLines = max;
            if (r.getCells().get(c).isInnerGridSerialized()) {
                int index = r.getCells().get(c).getInnderGrid().findCellWithMoreline(false);
                maxLines = r.getCells().get(c).getInnderGrid().getMaxLinesAtCell(index, false);
                if (maxLines > max) {
                    swap = true;
                }
            } else {
                maxLines = r.getCells().get(c).getLinesCount() - r.getCells().get(c).getOriginalLinesCount() - r.getCells().get(c).getVerticalAlignExtraLineAdded();
                if (maxLines > max) {
                    swap = true;
                }
            }
            if (!swap) continue;
            max = maxLines;
        }
        return max;
    }

    public int findCellWithMoreline(boolean excludeTitle) {
        int c = 0;
        int max = this.getMaxLinesAtCell(0, excludeTitle);
        for (int i = 1; i < this.columns.getList().size(); ++i) {
            int newMax = this.getMaxLinesAtCell(i, excludeTitle);
            boolean swap = false;
            if (max == newMax) {
                swap = this.getExtraWidthAtColumn(c) > this.getExtraWidthAtColumn(i);
            } else if (max < newMax) {
                swap = true;
            }
            if (!swap) continue;
            c = i;
            max = newMax;
        }
        return c;
    }

    public HeaderCell findLargerWidthCell() {
        HeaderCell cell = this.columns.getList().get(0).getValue();
        int width = cell.getWidth();
        for (int i = 1; i < this.columns.getList().size(); ++i) {
            HeaderCell c = this.columns.getList().get(i).getValue();
            if (c.getWidth() <= width) continue;
            width = c.getWidth();
            cell = c;
        }
        return cell;
    }

    public boolean pack(int max) {
        return this.pack(max, false);
    }

    public boolean pack(int max, boolean verticalAlign) {
        return this.pack(max, verticalAlign, false);
    }

    public boolean pack(int max, boolean verticalAlign, boolean removeEmpty) {
        if (removeEmpty) {
            this.removeEmptyColumns();
        }
        if (this.columns.isEmpty()) {
            return true;
        }
        boolean ret = this.pack(max, new ArrayList<HeaderCell>(), verticalAlign);
        if (ret && verticalAlign) {
            int maxLines = this.getMaxLinesInHeaders();
            for (int i = 0; i < this.columns.getList().size(); ++i) {
                this.columns.getList().get(i).getValue().verticalAlign(maxLines);
            }
            for (Row r : this.rows) {
                r.verticalAlign();
            }
        }
        return ret;
    }

    private boolean pack(int max, List<HeaderCell> alreadyAdjusted, boolean verticalAlign) {
        boolean done = this.packRecursive(max, verticalAlign);
        if (done) {
            HeaderCell c = this.getColumnWithMoreExtraWidth();
            if (c != null && c.getWidth() > 1) {
                int index = this.findCellWithMoreline(false);
                if (c == this.columns.getList().get(index).getValue()) {
                    return true;
                }
                int maxLines = this.getMaxLinesAtCell(index, false);
                if (maxLines <= 1) {
                    return true;
                }
                if (alreadyAdjusted.contains(c)) {
                    return true;
                }
                c.decrementWidth();
                this.columns.getList().get(index).getValue().incrementWidth();
                alreadyAdjusted.add(this.columns.getList().get(index).getValue());
                this.pack(max, alreadyAdjusted, verticalAlign);
            }
            return true;
        }
        return false;
    }

    private boolean packRecursive(int max, boolean verticalAlign) {
        boolean toexpand;
        this.resetFormatting(verticalAlign);
        int currentWidth = this.calculateTableWidth();
        if (max == currentWidth) {
            return true;
        }
        boolean bl = toexpand = currentWidth < max;
        if (toexpand) {
            int index = this.findCellWithMoreline(false);
            int maxLines = this.getMaxLinesAtCell(index, false);
            if (maxLines == 1) {
                return true;
            }
            HeaderCell c = this.columns.getList().get(index).getValue();
            c.incrementWidth();
            return this.packRecursive(max, verticalAlign);
        }
        HeaderCell c = this.getColumnWithMoreExtraWidth();
        if (c != null) {
            c.decrementWidth();
            return this.packRecursive(max, verticalAlign);
        }
        c = this.findLargerWidthCell();
        if (c.getWidth() == 1) {
            return false;
        }
        c.decrementWidth();
        return this.packRecursive(max, verticalAlign);
    }

    public int calculateTableWidth() {
        int w = 0;
        for (NameValuePair<String, HeaderCell> pair : this.columns.getList()) {
            w += pair.getValue().getWidth();
        }
        return w += this.columns.size() + 1;
    }

    public List<String> getAsListOfString(boolean includeBorder) {
        ArrayList<String> list = new ArrayList<String>();
        if (includeBorder) {
            list.add(this.getTableTitleTop(includeBorder));
        }
        list.addAll(this.getAllColumnHeadersAsListOfStrings(includeBorder));
        list.add(this.getTableTitleBottom(includeBorder));
        for (int i = 0; i < this.rows.size(); ++i) {
            list.addAll(this.getRowAsListOfString(this.rows.get(i), includeBorder));
            if (i >= this.rows.size() - 1) continue;
            list.add(this.getRowSpliter(includeBorder));
        }
        if (includeBorder) {
            list.add(this.getTablBottom(includeBorder));
        }
        return list;
    }

    public void printTo(TextFileWriter writer) {
        this.printTo(writer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTo(TextFileWriter writer, String title) {
        if (this.columns.isEmpty()) {
            return;
        }
        TextFileWriter textFileWriter = writer;
        synchronized (textFileWriter) {
            writer.println();
            List<String> list = this.getAsListOfString(true);
            if (title != null) {
                HeaderCell tit = new HeaderCell();
                tit.setContent(title);
                List<String> titles = tit.getAsTitleString(this.calculateTableWidth() - 2, false);
                titles.addAll(list);
                list = titles;
            }
            for (String l : list) {
                writer.println(l);
            }
            writer.println();
        }
    }

    public List<String> getAllColumnHeadersAsListOfStrings(boolean includeBorder) {
        boolean moreTextOnCol = true;
        ArrayList<String> list = new ArrayList<String>();
        int l = 0;
        while (moreTextOnCol) {
            StringBuffer buf = new StringBuffer();
            if (includeBorder) {
                buf.append(TITLE_VERTICAL);
            }
            moreTextOnCol = false;
            for (int c = 0; c < this.columns.getList().size(); ++c) {
                NameValuePair<String, HeaderCell> pair = this.columns.getList().get(c);
                buf.append(pair.getValue().getLine(l, pair.getValue().getWidth()));
                if (includeBorder || c < this.columns.size() - 1) {
                    buf.append(TITLE_VERTICAL);
                }
                if (moreTextOnCol) continue;
                moreTextOnCol = pair.getValue().hasLine(l + 1);
            }
            ++l;
            list.add(buf.toString());
        }
        return list;
    }

    public void printAllColumnHeaders(TextFileWriter writer) {
        boolean moreTextOnCol = true;
        int l = 0;
        while (moreTextOnCol) {
            StringBuffer buf = new StringBuffer();
            buf.append(TITLE_VERTICAL);
            moreTextOnCol = false;
            for (int c = 0; c < this.columns.getList().size(); ++c) {
                NameValuePair<String, HeaderCell> pair = this.columns.getList().get(c);
                buf.append(pair.getValue().getLine(l, pair.getValue().getWidth()));
                buf.append(TITLE_VERTICAL);
                if (moreTextOnCol) continue;
                moreTextOnCol = pair.getValue().hasLine(l + 1);
            }
            ++l;
            writer.println(buf.toString());
        }
    }

    public void printRow(TextFileWriter writer, Row r, boolean includeBorder) {
        List<String> list = this.getRowAsListOfString(r, includeBorder);
        for (String l : list) {
            writer.println(l);
        }
    }

    public List<String> getRowAsListOfString(Row r, boolean includeBorder) {
        ArrayList<String> list = new ArrayList<String>();
        boolean moreTextOnCol = true;
        int l = 0;
        while (moreTextOnCol) {
            StringBuffer buf = new StringBuffer();
            if (includeBorder) {
                buf.append(VERTICAL);
            }
            moreTextOnCol = false;
            for (int c = 0; c < this.columns.size(); ++c) {
                buf.append(r.getCells().get(c).getLine(l, this.columns.getList().get(c).getValue().getWidth()));
                if (includeBorder || c < this.columns.size() - 1) {
                    buf.append(VERTICAL);
                }
                if (moreTextOnCol) continue;
                moreTextOnCol = r.getCells().get(c).hasLine(l + 1);
            }
            ++l;
            list.add(buf.toString());
        }
        return list;
    }

    public String getTableTitleTop(boolean includeBorder) {
        return this.getHorizontalLine(TAB_LEFT_TOP, TITLE_HORIZONTAL, TITLE_SPLIT_DOWN, TAB_RIGHT_TOP, includeBorder);
    }

    public String getRowSpliter(boolean includeBorder) {
        return this.getHorizontalLine(VERTICAL_WITH_RIGHT, HORIZONTAL, PLUS, VERTICAL_WITH_LEFT, includeBorder);
    }

    public String getTableTitleBottom(boolean includeBorder) {
        return this.getHorizontalLine(TITLE_VERTICAL_WITH_LEFT, TITLE_HORIZONTAL, TITLE_PLUS, TITLE_VERTICAL_WITH_RIGHT, includeBorder);
    }

    public String getTablBottom(boolean includeBorder) {
        return this.getHorizontalLine(TABLE_BOTTOM_LEFT, HORIZONTAL, TABLE_BOTTOM_SPLIT, TABLE_BOTTOM_RIGHT, includeBorder);
    }

    public String getHorizontalLine(char left, char horizontal, char split, char right, boolean includeBorder) {
        StringBuffer buf = new StringBuffer();
        if (includeBorder) {
            buf.append(left);
        }
        int c = 0;
        for (NameValuePair<String, HeaderCell> pair : this.columns.getList()) {
            for (int i = 0; i < pair.getValue().getWidth(); ++i) {
                buf.append(horizontal);
            }
            if (++c >= this.columns.size()) continue;
            buf.append(split);
        }
        if (includeBorder) {
            buf.append(right);
        }
        return buf.toString();
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public OrderedMap<String, HeaderCell> getColumns() {
        return this.columns;
    }

    public Grid asTree(String groupcolumnname, int lastcolumns_to_retain) {
        Grid table = this;
        if (lastcolumns_to_retain == 0) {
            return table;
        }
        if (table.getColumns().size() <= 2) {
            return table;
        }
        if (table.getColumns().size() <= lastcolumns_to_retain + 1) {
            return table;
        }
        Grid g = new Grid();
        g.addColumn(table.getColumns().getList().get(0).getValue().getContent());
        g.addColumn(groupcolumnname);
        for (Row r : table.getRows()) {
            Grid temp = g;
            Row temprow = null;
            for (int i = 0; i < r.getCells().size(); ++i) {
                Cell c = r.getCells().get(i);
                if (i >= r.getCells().size() - lastcolumns_to_retain - 1) {
                    if (temprow == null) {
                        for (int col = i; col < table.getColumns().getList().size(); ++col) {
                            temp.addColumn(table.getColumns().getList().get(col).getName());
                        }
                        temprow = temp.createNewRow();
                    }
                    temprow.setValueAt(c.getContent() == null ? "" : c.getContent(), i - r.getCells().size() + lastcolumns_to_retain + 1);
                    continue;
                }
                Grid current = Grid.findGrid(temp, c);
                if (current == null) {
                    Row row = temp.createNewRow();
                    row.setValueAt(c.getContent() == null ? "" : c.getContent(), 0);
                    Grid inner = new Grid();
                    inner.addColumn(table.getColumns().getList().get(i + 1).getName());
                    if (i + 1 < r.getCells().size() - lastcolumns_to_retain - 1) {
                        inner.addColumn(groupcolumnname);
                    }
                    row.setGridAt(inner, 1);
                    temp = inner;
                    continue;
                }
                temp = current;
            }
        }
        return g;
    }

    private static Grid findGrid(Grid g, Cell c) {
        Row r;
        if (g.getRows().size() > 0 && (r = g.getRows().get(g.getRows().size() - 1)).getCells().get(0).getContent().equals(c.getContent())) {
            return r.getCells().get(1).getInnderGrid();
        }
        return null;
    }
}

