/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.CommonConstants;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliExitCodeException;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.TimeUtils;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MainBase
implements CommonConstants {
    private boolean TEST_MODE = false;
    public static final int DEF_MAX_COLUMN_LENGTH = 89;
    private static MainBase main;
    static CommandLine PRINT_COMMAND;
    static CommandLine VERSION_COMMAND;
    public int MAX_COLUMN_LENGTH = 89;
    public static final String DEFAULT_PROP_SEPARATOR = ",";
    protected String defaultCommand = null;
    public static final int EXIT_CODE_SYSTEM_ERROR_NO_MAIN_CLASS = 10;
    public static final int EXIT_CODE_USER_ERROR_PRINT_USAGE = 1;
    public static final int EXIT_CODE_USER_ERROR_PRINT_USAGE_EXPLCIT = 5;
    public static final int EXIT_CODE_USER_ERROR_CLI_ERROR = 4;
    public static final int EXIT_CODE_USER_ERROR_COMMAND_NOT_FOUND = 2;
    public static final int EXIT_CODE_SUCCESS = 0;

    public abstract OrderedMap<String, CommandLine> getAllCommands();

    public void setTEST_MODE(boolean TEST_MODE) {
        this.TEST_MODE = TEST_MODE;
    }

    public abstract String getUsage(boolean var1);

    public static CommandLine findByAlias(String alias, OrderedMap<String, CommandLine> map) {
        if (alias == null) {
            return null;
        }
        for (NameValuePair<String, CommandLine> pair : map.getList()) {
            CommandLine cmd = pair.getValue();
            if (!cmd.getCommandAliases().contains(alias)) continue;
            return cmd;
        }
        return null;
    }

    public Properties getDefaultProperties(CommandLine cmd) {
        return new Properties();
    }

    public static MainBase getMain() {
        return main;
    }

    public static void main(String[] s) throws Exception {
        MainBase.mainReturn(s);
    }

    public static int mainReturn(String[] s) throws Exception {
        MainBase main = MainBase.getMain();
        if (main == null) {
            Logger.getDEFAULT().printlnError("No main class is registered ...");
            return 10;
        }
        return main.doCommand(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doCommand(String[] s) throws Exception {
        block29: {
            CommandLine command;
            OrderedMap<String, CommandLine> allCommands = this.getAllCommands();
            if (s == null || s.length == 0) {
                Logger.getDEFAULT().println(CloudUtil.convertToHelpText(NLSUtil.localizeMessage("NLS_USAGE_STRING") + this.getUsage(false), 80, 10));
                this.emitHelp();
                if (this.TEST_MODE) return 1;
                System.exit(1);
            }
            if ((command = allCommands.get((s = CloudUtil.adjustArgs(s, allCommands))[0])) == null) {
                String removed = s[0].trim();
                if (removed.startsWith("-")) {
                    removed = removed.substring(1, removed.length());
                }
                if ((command = allCommands.get(removed)) == null) {
                    command = MainBase.findByAlias(removed, allCommands);
                }
                if (command == null) {
                    if (this.defaultCommand != null) {
                        command = allCommands.get(this.defaultCommand);
                        ArrayList<String> options = new ArrayList<String>();
                        options.add(this.defaultCommand);
                        options.addAll(Arrays.asList(s));
                        s = options.toArray(new String[0]);
                    }
                } else {
                    s[0] = command.getCommandName();
                }
            }
            if (command == null) {
                Logger.getDEFAULT().printlnErrorI18n("NLS_ERROR_INVALID_CMD", s[0]);
                this.emitHelp();
                if (this.TEST_MODE) return 2;
                System.exit(2);
            }
            try {
                Date end;
                command = (CommandLine)command.simpleClone();
                command.parse(s, this);
                if (command.toPrintHelp()) {
                    command.emitHelp(this, allCommands.size() != 1, this.defaultCommand);
                    if (this.TEST_MODE) {
                        int removed = 5;
                        return removed;
                    }
                    System.exit(5);
                    break block29;
                }
                if (command.toEnableDebug()) {
                    Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.TRACE);
                    Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
                } else {
                    Logger.getDEFAULT().setAllowed(Logger.DEFAULT_ALLOWED);
                }
                Date start = new Date();
                Logger.getDEFAULT().printlnDebugI18n("NLS_INFO_CMD_STARTED_AT", start.toString());
                try {
                    Logger.getDEFAULT().printlnDebug("Executing:" + command.toCommandlineArgs(true, false));
                    command.perform();
                    end = new Date();
                }
                catch (Throwable throwable) {
                    Date end2 = new Date();
                    String interval = TimeUtils.millisToLongDHMS(end2.getTime() - start.getTime());
                    Logger.getDEFAULT().printlnDebugI18n("NLS_INFO_CMD_FINISHED_AT", new String[]{end2.toString(), interval});
                    Logger.getDEFAULT().flush();
                    throw throwable;
                }
                String interval = TimeUtils.millisToLongDHMS(end.getTime() - start.getTime());
                Logger.getDEFAULT().printlnDebugI18n("NLS_INFO_CMD_FINISHED_AT", new String[]{end.toString(), interval});
                Logger.getDEFAULT().flush();
            }
            catch (Throwable e) {
                if (command.toPrintHelp()) {
                    command.emitHelp(this, allCommands.size() != 1, this.defaultCommand);
                    if (this.TEST_MODE) {
                        int end = 5;
                        return end;
                    }
                    System.exit(5);
                }
                CloudUtil.handleFinalException(e, true);
                CliExitCodeException code = CloudUtil.getCause(e, CliExitCodeException.class);
                if (!this.TEST_MODE) {
                    if (code != null) {
                        System.exit(code.getExitCode());
                        break block29;
                    } else {
                        System.exit(4);
                    }
                    break block29;
                }
                if (code != null) {
                    int n = code.getExitCode();
                    return n;
                }
                int n = 4;
                return n;
            }
            finally {
                if (command.toEnableDebug()) {
                    Logger.getDEFAULT().setAllowed(Logger.DEFAULT_ALLOWED);
                }
            }
        }
        if (this.TEST_MODE) return 0;
        System.exit(0);
        return 0;
    }

    public void emitHelp() {
        try {
            this.emitHelp(new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8")), false, CloudUtil.getKeyMaxLengthProcessEachCommand(this.getAllCommands()));
        }
        catch (Throwable t) {
            Logger.getDEFAULT().printlnErrorI18n("NLS_ERROR_SYSTEM_ERROR_OCCURRED", t.getMessage());
            Logger.getDEFAULT().printlnThrowable(t);
        }
    }

    public OrderedMap<String, List<CommandLine>> getOptionsMap() {
        ArrayList<String> allArgs = new ArrayList<String>();
        for (int i = 0; i < this.getAllCommands().getList().size(); ++i) {
            CommandLine command = this.getAllCommands().getList().get(i).getValue();
            for (NameValuePair<String, CommandLineArg> pair : command.getArgs().getList()) {
                if (pair.getValue().isHidden() || allArgs.contains(pair.getName())) continue;
                allArgs.add(pair.getName());
            }
        }
        Collections.sort(allArgs);
        OrderedMap<String, List<CommandLine>> map = new OrderedMap<String, List<CommandLine>>();
        for (String arg : allArgs) {
            for (int i = 0; i < this.getAllCommands().getList().size(); ++i) {
                CommandLine command = this.getAllCommands().getList().get(i).getValue();
                CommandLineArg arg1 = command.getArgs().get(arg);
                if (arg1 == null || arg1.isHidden()) continue;
                List<CommandLine> list = map.get(arg);
                if (list == null) {
                    list = new ArrayList<CommandLine>();
                    map.put(arg, list);
                }
                list.add(command);
            }
        }
        return map;
    }

    public void emitHelp(PrintWriter pr, boolean html, int allignLength) {
        if (html) {
            pr.println("<h3>Usage</h3><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
            pr.println(this.getUsage(html));
            pr.println("</pre>");
            pr.println("<hr width=\"100%\" noshade color=\"maroon\" size=\"2\"/>");
        }
        if (this.getAllCommands().size() > 1) {
            if (html) {
                pr.println("<a name=\"top\"></a>");
                pr.println("<h2>");
            }
            pr.println("\nPossible Commands are:");
            if (html) {
                pr.println("</h2><pre style=\"font-family:Helvetica Neue,Helvetica,Arial,sans-serif;font-size:13px;line-height:18px;color: #333333;width:100\">");
            }
            for (int i = 0; i < this.getAllCommands().getList().size(); ++i) {
                CommandLine command = this.getAllCommands().getList().get(i).getValue();
                if (!html) {
                    pr.println(CloudUtil.convertToHelpText(CloudUtil.padChar(allignLength, ' ', command.getCommandName().trim(), allignLength, true) + " - " + command.getDescription() + (command.getCommandName().equals(this.defaultCommand) ? " This is the default command." : ""), this.MAX_COLUMN_LENGTH, allignLength + 3));
                } else {
                    pr.println("<a href=\"#" + command.getCommandName() + "\">" + command.getCommandName() + "</a>");
                    pr.println(CloudUtil.convertToHelpText(CloudUtil.padChar(allignLength, ' ', " ", allignLength, true) + " - " + command.getDescription() + (command.getCommandName().equals(this.defaultCommand) ? " This is the default command" : ""), this.MAX_COLUMN_LENGTH, allignLength + 3));
                }
                pr.println();
            }
            if (html) {
                pr.println("</pre>");
            }
        }
        pr.flush();
    }

    public void writeHelpHtml(String filePath) throws Exception {
        int alignLength = CloudUtil.getKeyMaxLengthProcessEachCommand(this.getAllCommands());
        File file = new File(filePath);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception("File could not be created at:" + file.getAbsolutePath());
        }
        PrintWriter pr = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
        pr.println("<!DOCTYPE html>");
        pr.println("<html><head><link rel=\"stylesheet\" href=\"css/cloud3.css\"><title>Oracle Cloud - Java Service SDK Usage</title></head><body><header class=\"navbar-fixed-top\"><hgroup class=\"container\"><div class=\"cloudLogo columns\"><a href='http://cloud.oracle.com' target=\"_blank\"><img alt=\"Oracle Cloud logo\" src=\"images/oracle-cloud-logo.png\" border=\"0\" /></a></div></hgroup></header><div class=\"blueBanner\"><div class=\"container\"><div class=\"blueBannerLogo img-center-align\"><img src='images/cloud-java.png' alt=\"\"/></div><div class=\"blueBannerHeading\"><h1 class=\"blueBannerTitleWithSubtitle\"><a href='../index.html'style=\"color:white\">Oracle Java Cloud Service</a></h1><h2 class=\"blueBannerSubTitle\">All the productivity of Java, without the IT.</h2></div></div></div><div class='resourcesContainer'><div class=\"container\"><div class=\"resourcesSideNav\"><ul><li class=''><a href='index.html'>Home</a></li><li class=''><a href='javacloud-usage.html'>CLI-Javacloud.jar</a></li><li class=''><a href='javacloud.properties.html'>CLI-Javacloud.properties</a></li><li class=''><a href='javacloud-fs-usage.html'>CLI-Filesystem Shell </a></li><li class=''><a href='javacloud-app-config.html'>CLI-Configuration Shell</a></li><li class=''><a href='whitelist-usage.html'>CLI-Whitelist.jar</a></li><li class=''><a href='ant-tasks.html'>ANT Tasks</a></li><li class=''><a href='maven-plugin.html'>Maven Plugin</a></li><li class=''><a href='localextension.jar.html'>SDK-Local Weblogic Domain</a></li><li class=''><a href='codesnippet.html'>Examples</a></li><li class=''><a href='samples.html'>Sample Applications</a></li></ul></div><div class=\"resourcesContent\"><div class=\"resourceSubCategoryLayout\"><div class=\"resourceSubCategoryHeader\"><div class=\"resourceSubCategoryTitle\">SDK-CLI</div></div><div class=\"resourceLayout\">");
        pr.println("<body>");
        this.emitHelp(pr, true, alignLength);
        pr.println("<hr width=\"100%\" noshade color=\"maroon\" size=\"3\"/>");
        OrderedMap<String, List<CommandLine>> map = this.getOptionsMap();
        pr.println("\n<h3>Quick Argument Summary</h3><br/>");
        pr.println("<table border=\"1\">");
        pr.println("<tr>");
        pr.println("<th>Arguments");
        pr.println("</th>");
        pr.println("<th> Commands Supporting-Hyperlinked");
        pr.println("</th>");
        pr.println("</tr>");
        for (NameValuePair<String, List<CommandLine>> pair : map.getList()) {
            pr.println("<tr>");
            pr.println("<td>" + pair.getName());
            pr.println("</td>");
            pr.println("<td>");
            for (int i = 0; i < this.getAllCommands().getList().size(); ++i) {
                CommandLine command = this.getAllCommands().getList().get(i).getValue();
                if (pair.getValue().contains(command)) {
                    CommandLineArg arg = command.getArgs().get(pair.getName());
                    pr.println("<a href=\"#" + command.getCommandName() + "\" title=\"Argument Description:" + arg.getDescription() + "\"  >");
                    pr.println(command.getCommandName());
                    pr.println("</a>");
                } else {
                    pr.println(command.getCommandName());
                }
                pr.println("&nbsp;");
            }
            pr.println("</td>");
            pr.println("</tr>");
        }
        pr.println("</table>");
        for (int i = 0; i < this.getAllCommands().getList().size(); ++i) {
            CommandLine command = this.getAllCommands().getList().get(i).getValue();
            pr.println("<hr width=\"100%\" noshade color=\"maroon\" size=\"3\"/>");
            command.emitHelp(this, pr, true, this.getAllCommands().size() != 1, this.defaultCommand);
        }
        pr.println("<hr width=\"100%\" noshade color=\"maroon\" size=\"3\"/>");
        pr.println("</div></div></div></div></div><footer><div class=\"opcGlobalFooter\"><div class=\"container\"><div class=\"footerLeft columns\"><ul><li><a href='http://www.oracle.com/corporate/index.html' target=\"_blank\">About Oracle</a></li><li><a href='http://www.oracle.com/corporate/contact/index.htm' target=\"_blank\">Contact Us</a></li><li><a href='http://www.oracle.com/us/legal/index.html' target=\"_blank\">Legal Notices</a></li><li><a href='http://www.oracle.com/us/legal/terms/index.html' target=\"_blank\">Terms of Use</a></li><li><a href='http://www.oracle.com/us/legal/privacy/index.html' target=\"_blank\">Your Privacy Rights</a></li></ul><p>Copyright &copy; 2013, 2014 Oracle and/or its affiliates. All rights reserved.</p></div></div></div></footer></body>");
        pr.println("</html>");
        pr.flush();
        pr.close();
    }

    public static void setMain(MainBase main) {
        MainBase.main = main;
    }

    static {
        PRINT_COMMAND = null;
        VERSION_COMMAND = null;
        PRINT_COMMAND = new CommandLine();
        PRINT_COMMAND.setCommandName("print");
        PRINT_COMMAND.setDescription("Prints the usage into a html file");
        PRINT_COMMAND.addArg(new CommandLineArg("output", true, new CommandLineArg.FileOptionType(CommandLineArg.CardinalityEnum.one, null, null, true, true), "The directory where the usage.html is to be written."));
        VERSION_COMMAND = new CommandLine();
        VERSION_COMMAND.setCommandName("version");
        VERSION_COMMAND.setDescription("Prints the version of the component");
    }
}

