/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.clibase;

import java.io.Console;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArg {
    public static final String CARDINALITY_ONE = "one";
    public static final String CARDINALITY_MANY = "many";
    private String optionName;
    private String optionDisplayName;
    private String description;
    private boolean mandatory;
    private boolean nullStringAllowed = false;
    private String optionValue;
    private String optionDefaltValue;
    private boolean debugArg;
    private List<String> replacementOptionNames;
    private boolean advancedOption;
    private String shortCut;
    private OptionType optionType;
    private List<String> possibleEnumValues;
    private List<CommandLineArg> possibleProperties;
    private boolean hidden = false;

    public CommandLineArg() {
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isBoolean() {
        return BooleanOptionType.class.isAssignableFrom(this.getOptionType().getClass());
    }

    public boolean isPassword() {
        return PasswordType.class.isAssignableFrom(this.getOptionType().getClass());
    }

    public boolean isFile() {
        return FileOptionType.class.isAssignableFrom(this.getOptionType().getClass());
    }

    @XmlTransient
    public boolean isHidden() {
        return this.hidden;
    }

    public void setOptionDefaltValue(String optionDefaltValue) {
        this.optionDefaltValue = optionDefaltValue;
    }

    public String getOptionDefaltValue() {
        return this.optionDefaltValue;
    }

    public void setNullStringAllowed(boolean nullStringAllowed) {
        this.nullStringAllowed = nullStringAllowed;
    }

    @XmlTransient
    public boolean isNullStringAllowed() {
        return this.nullStringAllowed;
    }

    public void setOptionType(OptionType type) {
        this.optionType = type;
    }

    @XmlTransient
    public OptionType getOptionType() {
        return this.optionType;
    }

    @XmlElement
    public CardinalityEnum getCardinalityEnum() {
        return this.optionType.getCardinalityEnum();
    }

    public void setPossibleEnumValues(List<String> possibleValues) {
        this.possibleEnumValues = possibleValues;
    }

    public List<String> getPossibleEnumValues() {
        return this.possibleEnumValues;
    }

    public String getPossibleEnumValuesStr() {
        StringBuffer strVal = new StringBuffer(this.possibleEnumValues.get(0));
        for (int i = 1; i < this.possibleEnumValues.size(); ++i) {
            strVal.append(", ");
            strVal.append(this.possibleEnumValues.get(i));
        }
        return strVal.toString();
    }

    public void setPossibleProperties(List<CommandLineArg> possibleProperties) {
        this.possibleProperties = possibleProperties;
    }

    public void addPropertyDescription(CommandLineArg arg) {
        if (this.possibleProperties == null) {
            this.possibleProperties = new ArrayList<CommandLineArg>();
        }
        this.possibleProperties.add(arg);
    }

    public List<CommandLineArg> getPossibleProperties() {
        return this.possibleProperties;
    }

    public String findShortCutToSuggest(CommandLine c) {
        String sc = CloudUtil.findShortCutText(this.optionName);
        if (sc == null) {
            return null;
        }
        if (c == null || c.getArgs() == null || c.getArgs().getList() == null) {
            return sc;
        }
        for (NameValuePair<String, CommandLineArg> arg : c.getArgs().getList()) {
            if (this.optionName.equals(arg.getValue().getOptionName()) || !sc.equals(arg.getValue().getOptionName()) && !sc.equals(arg.getValue().getShortCut())) continue;
            return null;
        }
        return sc;
    }

    public CommandLineArg(String name, boolean mandatory, OptionType type, String desc) {
        this(name, mandatory, type, false, desc);
    }

    public CommandLineArg(String name, boolean mandatory, OptionType type, String desc, String displayName, String def) {
        this(name, mandatory, type, false, desc, displayName, def);
    }

    public CommandLineArg(String name, boolean mandatory, OptionType type, String desc, String displayName) {
        this(name, mandatory, type, false, desc, displayName, null);
    }

    public String getCLIHelpMessage(int alignLength, int maxlength, boolean html) {
        return this.getCLIHelpMessage(true, alignLength, maxlength, html);
    }

    public String getCLIHelpMessage(boolean left, int alignLength, int maxlength, boolean html) {
        StringBuffer desc = new StringBuffer(this.getDescription());
        if (this.optionType instanceof StringOptionType) {
            if (this.getPossibleEnumValues() != null && this.getPossibleEnumValues().size() > 0) {
                desc.append("\n\nPossible Value is from :" + CloudUtil.getCommaSeparatedListOfString(this.getPossibleEnumValues()));
            }
            if (((StringOptionType)this.optionType).getCardinality().getValue() == CardinalityEnum.many) {
                desc.append("\n\nMultiple values can be passed with a comma(,) as the separator.");
            }
        }
        if (this.getShortCut() != null) {
            desc.append("\n\nShortcut:" + this.getShortCut());
        }
        if (this.getOptionDefaltValue() != null) {
            if (this.getOptionDefaltValue().length() > 20) {
                desc.append("\n\nDefault Value:\n" + this.getOptionDefaltValue());
            } else {
                desc.append("\n\nDefault Value: " + this.getOptionDefaltValue());
            }
        }
        if (this.optionType instanceof PropertiesOptionType && this.possibleProperties != null) {
            desc.append("\nThe possible properties include\n");
        }
        desc = new StringBuffer(CloudUtil.convertToHelpText(CloudUtil.padChar(alignLength, ' ', this.getOptionName().trim(), alignLength, left) + " - " + desc.toString(), maxlength, alignLength + 3));
        if (html) {
            desc = new StringBuffer(desc.toString().replaceAll("\\<", "&lt;"));
        }
        if (this.optionType instanceof PropertiesOptionType) {
            int inneralign = CloudUtil.getKeyMaxLength(this.getPossibleProperties());
            if (this.possibleProperties != null) {
                for (CommandLineArg arg : this.possibleProperties) {
                    String innerDesc = arg.getCLIHelpMessage(false, inneralign + alignLength, maxlength, html);
                    desc.append("\n" + innerDesc + "\n");
                }
            }
        }
        return desc.toString();
    }

    public CommandLineArg(String name, boolean mandatory, OptionType type, boolean debugArg, String desc) {
        this(name, mandatory, type, debugArg, desc, name, null);
    }

    public CommandLineArg(String name, boolean mandatory, OptionType type, boolean debugArg, String desc, String displayName, String defaultValue) {
        this.optionName = name;
        this.optionDisplayName = displayName;
        this.mandatory = mandatory;
        this.optionType = type;
        this.description = desc;
        this.debugArg = debugArg;
        this.optionDefaltValue = defaultValue;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public void setOptionDisplayName(String optionName) {
        this.optionDisplayName = optionName;
    }

    @XmlTransient
    public String getOptionDisplayName() {
        return this.optionDisplayName;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public String getOptionValue() {
        return this.optionValue;
    }

    public boolean isValueRequired() {
        return !(this.optionType instanceof BooleanOptionType);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDebugArg(boolean debugArg) {
        this.debugArg = debugArg;
    }

    public boolean isDebugArg() {
        return this.debugArg;
    }

    public CommandLineArg simpleClone() {
        CommandLineArg arg = new CommandLineArg(this.getOptionName(), this.isMandatory(), this.getOptionType(), this.isDebugArg(), this.getDescription(), this.getOptionDisplayName(), this.getOptionDefaltValue());
        arg.setAdvancedOption(this.isAdvancedOption());
        arg.setReplacementOptionNames(this.getReplacementOptionNames());
        arg.setShortCut(this.getShortCut());
        arg.setHidden(this.isHidden());
        arg.setNullStringAllowed(this.isNullStringAllowed());
        arg.setPossibleEnumValues(this.getPossibleEnumValues());
        arg.setPossibleProperties(this.getPossibleProperties());
        arg.setOptionType(this.getOptionType());
        return arg;
    }

    public void setReplacementOptionNames(List<String> replacementOptionName) {
        this.replacementOptionNames = replacementOptionName;
    }

    public List<String> getReplacementOptionNames() {
        return this.replacementOptionNames;
    }

    public void addReplacementOptionName(String name) {
        if (this.replacementOptionNames == null) {
            this.replacementOptionNames = new ArrayList<String>();
        }
        if (!this.replacementOptionNames.contains(name)) {
            this.replacementOptionNames.add(name);
        }
    }

    public void setAdvancedOption(boolean advancedOption) {
        this.advancedOption = advancedOption;
    }

    public boolean isAdvancedOption() {
        return this.advancedOption;
    }

    public void setShortCut(String shortCut) {
        this.shortCut = shortCut;
    }

    public String getShortCut() {
        return this.shortCut;
    }

    public static char[] readPassword(String argDesc, String argName) {
        Console cons = null;
        char[] passwd = null;
        cons = System.console();
        if (cons != null) {
            Logger.getDEFAULT().println("[" + argDesc + "]");
            passwd = cons.readPassword("[%s]", argName);
            if (passwd != null && passwd.length == 0) {
                passwd = null;
            }
        }
        return passwd;
    }

    public boolean prompt() throws IOException {
        if (this.isPassword()) {
            char[] pwd;
            String firstLine = this.description;
            int index_dot = firstLine.indexOf("\n");
            if (index_dot > 0) {
                firstLine = firstLine.substring(0, index_dot);
            }
            if ((pwd = CommandLineArg.readPassword(firstLine, this.getOptionName())) != null) {
                this.setOptionValue(new String(pwd));
            } else {
                this.setOptionValue(null);
            }
        }
        return this.getOptionValue() != null;
    }

    public static class StringOptionType
    implements OptionType {
        private Cardinality cardinality = new Cardinality();
        private String[] enumValues;

        public StringOptionType(CardinalityEnum value, String delimiter, String[] enumValues) {
            this.cardinality.setValue(value);
            this.cardinality.setDelimiter(delimiter);
            if (enumValues != null) {
                enumValues = (String[])enumValues.clone();
            }
            this.enumValues = enumValues;
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(Cardinality card) {
            this.cardinality = card;
        }

        public String[] getEnumValues() {
            if (this.enumValues == null) {
                return null;
            }
            return (String[])this.enumValues.clone();
        }

        public void setEnumValues(String[] enumValues) {
            if (enumValues != null) {
                enumValues = (String[])enumValues.clone();
            }
            this.enumValues = enumValues;
        }

        public CardinalityEnum getCardinalityEnum() {
            return this.cardinality.getValue();
        }
    }

    public static class PasswordType
    extends SingleOptionType {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileOptionType
    implements OptionType {
        private Cardinality cardinality = new Cardinality();
        private FileTypesType fileTypes;

        public FileOptionType(CardinalityEnum value, String delimiter, List<FileExt> fileTypes, boolean directoryOk, boolean fileOk) {
            this.cardinality.setValue(value);
            this.cardinality.setDelimiter(delimiter);
            this.fileTypes = new FileTypesType();
            this.fileTypes.setDirectoryOk(directoryOk);
            this.fileTypes.setFileOk(fileOk);
            this.fileTypes.setFileTypes(fileTypes);
        }

        @Override
        public CardinalityEnum getCardinalityEnum() {
            return this.cardinality.getValue();
        }

        public Cardinality getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(Cardinality card) {
            this.cardinality = card;
        }

        public FileTypesType getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(FileTypesType fileTypes) {
            this.fileTypes = fileTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileTypesType {
        private List<FileExt> fileTypes;
        private boolean directoryOk;
        private boolean fileOk;

        public List<FileExt> getFileTypes() {
            return this.fileTypes;
        }

        public void setFileTypes(List<FileExt> fileTypes) {
            this.fileTypes = fileTypes;
        }

        public boolean isDirectoryOk() {
            return this.directoryOk;
        }

        public void setDirectoryOk(boolean directory) {
            this.directoryOk = directory;
        }

        public void setFileOk(boolean fileOk) {
            this.fileOk = fileOk;
        }

        public boolean isFileOk() {
            return this.fileOk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileExt {
        ear,
        war,
        jar,
        zip,
        none,
        xml,
        properties,
        jks;

    }

    public static class Cardinality {
        private CardinalityEnum value;
        private String delimiter;

        public CardinalityEnum getValue() {
            return this.value;
        }

        public void setValue(CardinalityEnum value) {
            this.value = value;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardinalityEnum {
        one,
        many;

    }

    public static final class PropertiesOptionType
    extends PropertyOptionType {
        public CardinalityEnum getCardinalityEnum() {
            return CardinalityEnum.many;
        }
    }

    public static final class NumberOptionType
    extends SingleOptionType {
    }

    public static final class DateOptionType
    extends SingleOptionType {
    }

    public static class PropertyOptionType
    extends SingleOptionType {
    }

    public static final class BooleanOptionType
    extends SingleOptionType {
    }

    public static class SingleOptionType
    implements OptionType {
        public CardinalityEnum getCardinalityEnum() {
            return CardinalityEnum.one;
        }
    }

    public static interface OptionType {
        public CardinalityEnum getCardinalityEnum();
    }
}

