/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.api.LoggingListener;
import oracle.cloud.scanning.api.Scanner;
import oracle.cloud.scanning.config.IAllConfiguration;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.scanner.AbstractScanner;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ScannerImpl
implements Scanner {
    IAllConfiguration config = null;

    public ScannerImpl(IAllConfiguration config) {
        this.config = config;
    }

    @Override
    public void scan(String resourceURL, Listener listener) {
        ArrayList<String> resourceURLs = new ArrayList<String>();
        resourceURLs.add(resourceURL);
        this.scanAll(resourceURLs, listener);
    }

    private void scanNext(String resourceID, InputStream resource, Listener listener, IncrementalScansetAdapter adapter) {
        block15: {
            boolean openedHere = false;
            boolean scan = true;
            try {
                if (!listener.onResourceStart(resourceID)) break block15;
                if (resource == null) {
                    openedHere = true;
                    try {
                        resource = new URL(resourceID).openConnection().getInputStream();
                    }
                    catch (Throwable t2) {
                        if (listener.onResourceReadFailure(t2)) {
                            throw new RuntimeException(t2);
                        }
                        scan = false;
                    }
                }
                if (scan) {
                    AbstractScanner.process(resource, resourceID, listener, adapter);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                listener.onResourceEnd();
                if (openedHere && resource != null) {
                    try {
                        resource.close();
                    }
                    catch (Throwable t1) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(String resourceID, InputStream resource, Listener listener) {
        if (listener == null) {
            listener = new LoggingListener(Logger.getDEFAULT(), false, 0);
        }
        try {
            listener.onInit();
            this.scanNext(resourceID, resource, listener, new IncrementalScansetAdapter(this.config));
        }
        finally {
            listener.onEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanAll(List<String> resourceURLs, Listener listener) {
        if (listener == null) {
            listener = new LoggingListener(Logger.getDEFAULT(), false, 0);
        }
        try {
            listener.onInit();
            if (resourceURLs != null) {
                IncrementalScansetAdapter adapter = new IncrementalScansetAdapter(this.config);
                for (String u : resourceURLs) {
                    this.scanNext(u, null, listener, adapter);
                }
            }
        }
        finally {
            listener.onEnd();
        }
    }
}

