/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.scanning.FailedResultWrapper;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.api.config.IPropertyFileConfiguration;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.scanner.AbstractValidator;
import oracle.cloud.scanning.scanner.PropertyFileValidator;
import oracle.cloud.scanning.scanner.UnknownFileScanner;
import oracle.cloud.scanning.scanner.XMLFileValidator;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class FileScanner
extends UnknownFileScanner {
    public FileScanner(String path, InputStream in, Listener out, IncrementalScansetAdapter conf) {
        super(in, path, out, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan() throws Exception {
        if (!super.checkAllowed()) {
            return;
        }
        AbstractValidator validator = null;
        IXMLFileConfiguration xml = this.conf.checkXMLFileConfiguration(this.path);
        if (xml != null) {
            validator = new XMLFileValidator(xml, this.in, this.path);
        } else {
            IPropertyFileConfiguration prop = this.conf.checkPropertyFileConfiguration(this.path);
            if (prop != null) {
                validator = new PropertyFileValidator(prop, this.in, this.path);
            }
        }
        if (validator == null) {
            return;
        }
        List<FailedResultWrapper> ret = null;
        try {
            this.listener.onScanning(this.path);
            ret = validator.validate();
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnThrowable(e);
            ret = new ArrayList<FailedResultWrapper>();
            ret.add(new FailedResultWrapper(Util.unableToParseFile(e.getMessage())));
        }
        finally {
            if (ret == null || ret.isEmpty()) {
                this.listener.onScanSuccess();
            } else {
                this.listener.onScanFailure(ret);
            }
        }
    }
}

