/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import oracle.cloud.scanning.api.Listener;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.scanner.AbstractScanner;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class DirectoryScanner
extends AbstractScanner {
    public DirectoryScanner(String path, Listener out, IncrementalScansetAdapter conf) {
        super(null, path, out, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan() throws Exception {
        try {
            File dir = new File(this.path);
            if (!dir.isDirectory()) {
                throw new Exception(dir.getAbsolutePath() + " is not a directory");
            }
            this.listener.onDirectoryStart();
            List<String> allFiles = CloudUtil.recurseFindFilesWithPatternAt(dir, ".*");
            for (String file : allFiles) {
                File sub = new File(this.path, file);
                FileInputStream fis = new FileInputStream(sub);
                DirectoryScanner.process(fis, file.replace('\\', '/'), this.listener, this.conf);
                fis.close();
            }
        }
        finally {
            this.listener.onDirectoryEnd();
        }
    }
}

