/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.impl.validation;

import java.util.List;
import javax.xml.namespace.QName;
import oracle.cloud.scanning.api.validation.XMLElementValidator;
import oracle.cloud.scanning.types.IncludesAndExcludes;
import oracle.cloud.scanning.types.Namevaluepair;
import oracle.cloud.scanning.types.Properties;
import oracle.cloudlogic.javaservice.common.clibase.util.XMLUtil;
import org.w3c.dom.Element;

public class SharedLibraryExactMatchValidator
implements XMLElementValidator {
    @Override
    public boolean validate(Element elem, IncludesAndExcludes config, Properties properties) {
        List<Element> list;
        if (properties == null) {
            return false;
        }
        if (properties.getProperty().isEmpty()) {
            return false;
        }
        Element library = elem;
        if ("exact-match".equals(elem.getLocalName())) {
            library = (Element)library.getParentNode();
        }
        if ((list = XMLUtil.getAllFirstChildElements(library, new QName(library.getNamespaceURI(), "library-name"))) == null || list.isEmpty()) {
            return false;
        }
        String param = list.get(0).getTextContent();
        if (param == null) {
            return false;
        }
        param = param.trim();
        String version = null;
        for (Namevaluepair pair : properties.getProperty()) {
            if (!param.equals(pair.getName())) continue;
            version = pair.getValue();
            break;
        }
        if (version == null) {
            return false;
        }
        list = XMLUtil.getAllFirstChildElements(library, new QName(library.getNamespaceURI(), "specification-version"));
        if (list == null || list.isEmpty()) {
            return false;
        }
        param = list.get(0).getTextContent();
        if (param == null) {
            return false;
        }
        param = param.trim();
        return param.equals(version);
    }
}

