/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.MissingXMLNodeResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.api.config.XMLElementResult;
import oracle.cloud.scanning.api.validation.XMLElementValidator;
import oracle.cloud.scanning.config.imp.FileConfigurationImpl;
import oracle.cloud.scanning.impl.util.ReflectionUtil;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.IncludesAndExcludes;
import oracle.cloud.scanning.types.Namespace;
import oracle.cloud.scanning.types.Properties;
import oracle.cloud.scanning.types.Severity;
import oracle.cloud.scanning.types.XmlAttributeType;
import oracle.cloud.scanning.types.XmlAttributeValueType;
import oracle.cloud.scanning.types.XmlElementType;
import oracle.cloud.scanning.types.XmlElementValueType;
import oracle.cloud.scanning.types.XmlSetType;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.XMLUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLFileConfigurationImpl
implements IXMLFileConfiguration {
    XmlSetType xml = null;
    Configuration conf = null;
    private final Map<String, String> nsToPrefixMap = new HashMap<String, String>();

    public int lastValidSlash(String rx) {
        int last = rx.lastIndexOf("/");
        if (last <= 0) {
            return last;
        }
        if (rx.charAt(last - 1) == '^') {
            return this.lastValidSlash(rx.substring(0, last - 1));
        }
        return last;
    }

    public boolean isWarning(IncludesAndExcludes iae) {
        return iae.getSeverity() == Severity.WARNING;
    }

    public boolean startsWith(String rx, String pat) {
        if (FileConfigurationImpl.matchesPath(rx, pat)) {
            return true;
        }
        int last = this.lastValidSlash(rx);
        while (last > 0) {
            if (FileConfigurationImpl.matchesPath(rx = rx.substring(0, last), pat)) {
                return true;
            }
            last = this.lastValidSlash(rx);
        }
        return false;
    }

    public XMLFileConfigurationImpl(XmlSetType xml, Configuration conf) {
        this.xml = xml;
        this.conf = conf;
        for (Namespace ns : conf.getXmlsets().getXmlnamespaces().getNamespace()) {
            if (this.nsToPrefixMap.containsKey(ns.getNamespace())) {
                throw new RuntimeException("The namespace:" + ns.getNamespace() + " has been defined more than once for xml file path:" + xml.getPath());
            }
            this.nsToPrefixMap.put(ns.getNamespace(), ns.getPrefix());
        }
        if (xml.getXmlnamespaces() != null) {
            for (Namespace ns : xml.getXmlnamespaces().getNamespace()) {
                if (this.nsToPrefixMap.containsKey(ns.getNamespace())) {
                    throw new RuntimeException("The namespace:" + ns.getNamespace() + " has been defined more than once for xml file path:" + xml.getPath());
                }
                this.nsToPrefixMap.put(ns.getNamespace(), ns.getPrefix());
            }
        }
    }

    public XMLElementResult checkContinuation(NameValuePair<Boolean, String> pair) {
        for (XmlElementType el : this.xml.getXmlelement()) {
            if (!this.startsWith(el.getXpath(), pair.getValue())) continue;
            return XMLElementResult.ALLOWED_BUT_CONTINUE;
        }
        for (XmlElementValueType val : this.xml.getXmlelementvalue()) {
            if (!this.startsWith(val.getElement(), pair.getValue())) continue;
            return XMLElementResult.ALLOWED_BUT_CONTINUE;
        }
        for (XmlAttributeType attr : this.xml.getXmlattribute()) {
            if (!this.startsWith(attr.getElement(), pair.getValue())) continue;
            return XMLElementResult.ALLOWED_BUT_CONTINUE;
        }
        for (XmlAttributeValueType attrVal : this.xml.getXmlattributevalue()) {
            if (!this.startsWith(attrVal.getElement(), pair.getValue())) continue;
            return XMLElementResult.ALLOWED_BUT_CONTINUE;
        }
        return XMLElementResult.ALLOWED_ALL;
    }

    @Override
    public XMLElementResult checkXMLElement(Element e) {
        NameValuePair<Boolean, String> pair = this.elementToPath(e);
        if (!pair.getName().booleanValue()) {
            return XMLElementResult.ALLOWED_ALL;
        }
        for (XmlElementType el : this.xml.getXmlelement()) {
            if (!FileConfigurationImpl.matchesPath(el.getXpath() + ".*", pair.getValue()) || !this.validatorCheck(e, el.getLocationValidator(), el, el.getProperties())) continue;
            if (!el.getInclude().isEmpty()) {
                if (FileConfigurationImpl.matchesPathList(el.getXpath(), el.getInclude(), pair.getValue())) {
                    return this.checkContinuation(pair);
                }
                return Util.failed(el, this.isWarning(el) ? NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED_WARN", pair.getValue()) : NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED", pair.getValue()));
            }
            if (el.getExclude().isEmpty()) {
                if (!el.getIncludeMust().isEmpty()) continue;
                return Util.failed(el, this.isWarning(el) ? NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED_WARN", pair.getValue()) : NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED", pair.getValue()));
            }
            if (FileConfigurationImpl.matchesPathList(el.getXpath(), el.getExclude(), pair.getValue())) {
                return Util.failed(el, this.isWarning(el) ? NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED_WARN", pair.getValue()) : NLSUtil.localizeMessage("NLS_ELEMENT_NOT_ALLOWED", pair.getValue()));
            }
            return this.checkContinuation(pair);
        }
        return this.checkContinuation(pair);
    }

    @Override
    public Result checkXMLElementValue(Element e, String val) {
        Result result;
        if (val == null) {
            val = "";
        }
        if (!(result = this.checkXMLElementValueStrict(e, val)).isAllowed() && !val.equals(val.trim())) {
            return this.checkXMLElementValueStrict(e, val.trim());
        }
        return result;
    }

    private void checkXMLMustAttributePresent(Element e, List<MissingXMLNodeResult> list) {
        NameValuePair<Boolean, String> pair = this.elementToPath(e);
        if (!pair.getName().booleanValue()) {
            return;
        }
        for (XmlAttributeType at : this.xml.getXmlattribute()) {
            if (!FileConfigurationImpl.matchesPath(at.getElement(), pair.getValue()) || !this.validatorCheck(e, at.getLocationValidator(), at, at.getProperties()) || at.getIncludeMust().isEmpty()) continue;
            NamedNodeMap map = e.getAttributes();
            ArrayList<String> qnames = new ArrayList<String>();
            if (map != null) {
                for (int i = 0; i < map.getLength(); ++i) {
                    Node node = map.item(i);
                    if (!Attr.class.isAssignableFrom(node.getClass())) continue;
                    Attr att = (Attr)node;
                    qnames.add(this.attributeToShortForm(att));
                }
            }
            for (String must : at.getIncludeMust()) {
                boolean there = false;
                for (String child : qnames) {
                    if (!FileConfigurationImpl.matchesPath(must, child)) continue;
                    there = true;
                    break;
                }
                if (there) continue;
                list.add(Util.attributeNotFound(this.rmNsFromShortForm(must), pair.getValue(), at));
            }
        }
    }

    private void checkXMLMustElementPresent(Element e, List<MissingXMLNodeResult> list) {
        NameValuePair<Boolean, String> pair = this.elementToPath(e);
        if (!pair.getName().booleanValue()) {
            return;
        }
        for (XmlElementType el : this.xml.getXmlelement()) {
            if (!FileConfigurationImpl.matchesPath(el.getXpath(), pair.getValue() + "/") || !this.validatorCheck(e, el.getLocationValidator(), el, el.getProperties()) || el.getIncludeMust().isEmpty()) continue;
            List<Element> children = XMLUtil.getAllFirstChildElements(e);
            ArrayList<String> qnames = new ArrayList<String>();
            for (Element child : children) {
                qnames.add(this.elementToShortForm(child));
            }
            for (String must : el.getIncludeMust()) {
                boolean there = false;
                for (String child : qnames) {
                    if (!FileConfigurationImpl.matchesPath(must, child)) continue;
                    there = true;
                    break;
                }
                if (there) continue;
                list.add(Util.elementNotFound(this.rmNsFromShortForm(must), pair.getValue(), el));
            }
        }
    }

    private boolean validatorCheck(Element elem, String validator, IncludesAndExcludes inc, Properties properties) {
        try {
            if (validator == null) {
                return true;
            }
            XMLElementValidator xml = (XMLElementValidator)ReflectionUtil.instantiate(validator, XMLElementValidator.class.getClassLoader());
            return xml.validate(elem, inc, properties);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Result checkXMLElementValueStrict(Element e, String val) {
        NameValuePair<Boolean, String> pair = this.elementToPath(e);
        if (!pair.getName().booleanValue()) {
            return Result.PASSED;
        }
        Logger.getDEFAULT().printlnDebug("Checking element value at:" + pair.getValue() + " " + val);
        for (XmlElementValueType elVal : this.xml.getXmlelementvalue()) {
            if (!FileConfigurationImpl.matchesPath(elVal.getElement(), pair.getValue()) || !this.validatorCheck(e, elVal.getLocationValidator(), elVal, elVal.getProperties())) continue;
            if (!elVal.getInclude().isEmpty()) {
                if (FileConfigurationImpl.matchesPathList(elVal.getInclude(), val)) continue;
                return Util.elementValueNotAllowed(val, pair.getValue(), elVal);
            }
            if (elVal.getExclude().isEmpty()) {
                return Util.elementValueNotAllowed(val, pair.getValue(), elVal);
            }
            if (!FileConfigurationImpl.matchesPathList(elVal.getExclude(), val)) continue;
            return Util.elementValueNotAllowed(val, pair.getValue(), elVal);
        }
        return Result.PASSED;
    }

    @Override
    public Result checkAttribute(Element e, String name) {
        if (name == null) {
            throw new RuntimeException("Attribute name can not be null");
        }
        NameValuePair<Boolean, String> pair = this.elementToPath(e);
        if (!pair.getName().booleanValue()) {
            return Result.PASSED;
        }
        for (XmlAttributeType attr : this.xml.getXmlattribute()) {
            if (!FileConfigurationImpl.matchesPath(attr.getElement(), pair.getValue()) || !this.validatorCheck(e, attr.getLocationValidator(), attr, attr.getProperties())) continue;
            if (!attr.getInclude().isEmpty()) {
                if (FileConfigurationImpl.matchesPathList(attr.getInclude(), name)) continue;
                return Util.attributeNotAllowed(name, pair.getValue(), attr);
            }
            if (!(attr.getExclude().isEmpty() ? attr.getIncludeMust().isEmpty() : FileConfigurationImpl.matchesPathList(attr.getExclude(), name))) continue;
            return Util.attributeNotAllowed(name, pair.getValue(), attr);
        }
        return Result.PASSED;
    }

    @Override
    public Result checkAttributeValue(Element e, String name, String value) {
        NameValuePair<Boolean, String> pair;
        if (name == null) {
            throw new RuntimeException("Attribute name can not be null");
        }
        if (value == null) {
            value = "";
        }
        if (!(pair = this.elementToPath(e)).getName().booleanValue()) {
            return Result.PASSED;
        }
        for (XmlAttributeValueType attr : this.xml.getXmlattributevalue()) {
            if (!FileConfigurationImpl.matchesPath(attr.getElement(), pair.getValue()) || !attr.getAttribute().equals(name) || !this.validatorCheck(e, attr.getLocationValidator(), attr, attr.getProperties())) continue;
            if (!attr.getInclude().isEmpty()) {
                if (FileConfigurationImpl.matchesPathList(attr.getInclude(), value)) continue;
                return Util.attributeValueNotAllowed(value, name, pair.getValue(), attr);
            }
            if (attr.getExclude().isEmpty()) {
                return Util.attributeValueNotAllowed(value, name, pair.getValue(), attr);
            }
            if (!FileConfigurationImpl.matchesPathList(attr.getExclude(), value)) continue;
            return Util.attributeValueNotAllowed(value, name, pair.getValue(), attr);
        }
        return Result.PASSED;
    }

    private String elementToShortForm(Element name) {
        String prefix = null;
        if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) {
            prefix = this.nsToPrefixMap.get(name.getNamespaceURI());
            if (prefix == null) {
                prefix = "*";
            }
            return prefix + ":" + name.getLocalName();
        }
        return ":" + name.getLocalName();
    }

    private String rmNsFromShortForm(String shortName) {
        if (shortName == null) {
            return null;
        }
        int index = shortName.lastIndexOf(":");
        if (index < 0) {
            return shortName;
        }
        return shortName.substring(index + 1, shortName.length());
    }

    private String attributeToShortForm(Attr name) {
        String prefix = null;
        if (name.getNamespaceURI() != null && !name.getNamespaceURI().equals("")) {
            prefix = this.nsToPrefixMap.get(name.getNamespaceURI());
            if (prefix == null) {
                prefix = "*";
            }
            return prefix + ":" + name.getNodeName();
        }
        return name.getNodeName();
    }

    public NameValuePair<Boolean, String> elementToPath(Element elem) {
        String buf = "";
        boolean first = true;
        while (elem != null && elem.getLocalName() != null) {
            if (!first) {
                buf = "/" + buf;
            } else {
                first = false;
            }
            String shortform = this.elementToShortForm(elem);
            buf = shortform + buf;
            Node node = elem.getParentNode();
            if (node == null) {
                elem = null;
                continue;
            }
            if (Element.class.isAssignableFrom(node.getClass())) {
                elem = (Element)node;
                continue;
            }
            elem = null;
        }
        return new NameValuePair<Boolean, String>(Boolean.TRUE, "/" + buf);
    }

    @Override
    public List<MissingXMLNodeResult> checkMissingNodes(Element e) {
        ArrayList<MissingXMLNodeResult> list = new ArrayList<MissingXMLNodeResult>();
        this.checkXMLMustElementPresent(e, list);
        this.checkXMLMustAttributePresent(e, list);
        return list;
    }
}

