/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.cloud.scanning.api.config.IPropertyFileConfiguration;
import oracle.cloud.scanning.api.config.MissingPropertyResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.imp.ClassConfigurationImpl;
import oracle.cloud.scanning.config.imp.FileConfigurationImpl;
import oracle.cloud.scanning.types.PropertyKeyType;
import oracle.cloud.scanning.types.PropertySetType;

public class PropertyFileConfigurationImpl
implements IPropertyFileConfiguration {
    PropertySetType prop = null;

    public PropertyFileConfigurationImpl(PropertySetType prop) {
        this.prop = prop;
    }

    @Override
    public Result checkKey(String k) {
        for (PropertyKeyType key : this.prop.getProperty()) {
            if (!ClassConfigurationImpl.matchesClass(key.getKey(), k) || key.getValues() != null && (!key.getValues().getExclude().isEmpty() || !key.getValues().getInclude().isEmpty())) continue;
            return Util.keyNotAllowed(key.getValues() == null ? null : key.getValues().getMessageId(), key.getValues() == null ? null : key.getValues().getSeverity(), k);
        }
        return Result.PASSED;
    }

    @Override
    public List<MissingPropertyResult> checkMissingKeys(Collection<String> keys) {
        ArrayList<MissingPropertyResult> list = new ArrayList<MissingPropertyResult>();
        if (keys == null) {
            keys = new ArrayList<String>();
        }
        for (PropertyKeyType key : this.prop.getProperty()) {
            if (!key.getIncludeMust() || ClassConfigurationImpl.isAnyThingMatching(keys, key.getKey())) continue;
            list.add(Util.keyMissing(key.getKey(), key.getValues() == null ? null : key.getValues().getMessageId(), key.getValues() == null ? null : key.getValues().getSeverity()));
        }
        return list;
    }

    @Override
    public Result checkValue(String key, String val) {
        for (PropertyKeyType k : this.prop.getProperty()) {
            if (!ClassConfigurationImpl.matchesClass(k.getKey(), key)) continue;
            if (k.getValues() != null) {
                if (!k.getValues().getInclude().isEmpty()) {
                    if (FileConfigurationImpl.matchesPathList(k.getValues().getInclude(), val)) {
                        return Result.PASSED;
                    }
                    return Util.valueNotAllowed(k.getValues().getMessageId(), k.getValues().getSeverity(), key, val);
                }
                if (!k.getValues().getExclude().isEmpty()) {
                    if (FileConfigurationImpl.matchesPathList(k.getValues().getExclude(), val)) {
                        return Util.valueNotAllowed(k.getValues().getMessageId(), k.getValues().getSeverity(), key, val);
                    }
                    return Result.PASSED;
                }
                return Util.valueNotAllowed(k.getValues().getMessageId(), k.getValues().getSeverity(), key, val);
            }
            return Util.valueNotAllowed(null, null, key, val);
        }
        return Result.PASSED;
    }
}

