/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloud.scanning.api.config.IArchiveConfiguration;
import oracle.cloud.scanning.api.config.IFileConfiguration;
import oracle.cloud.scanning.api.config.IPropertyFileConfiguration;
import oracle.cloud.scanning.api.config.IXMLFileConfiguration;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.imp.ArchiveConfigurationImpl;
import oracle.cloud.scanning.config.imp.ConfigurationImpl;
import oracle.cloud.scanning.config.imp.IPropertyFinder;
import oracle.cloud.scanning.config.imp.PropertyFileConfigurationImpl;
import oracle.cloud.scanning.config.imp.XMLFileConfigurationImpl;
import oracle.cloud.scanning.types.ArchiveDescription;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.DefaultFileSetDescription;
import oracle.cloud.scanning.types.FileSetExcludeDescription;
import oracle.cloud.scanning.types.Filesetsdefinition;
import oracle.cloud.scanning.types.PropertySetType;
import oracle.cloud.scanning.types.XmlSetType;

public class FileConfigurationImpl
extends ConfigurationImpl
implements IFileConfiguration {
    private static final Map<String, SoftReference<Pattern>> compiledPathPatterns = new HashMap<String, SoftReference<Pattern>>();

    public FileConfigurationImpl(Configuration conf, IPropertyFinder pf) {
        super(conf, pf);
    }

    public static boolean matchesPath(String rx, String val) {
        SoftReference<Pattern> ref = compiledPathPatterns.get(rx);
        Pattern p = null;
        if (ref != null) {
            p = ref.get();
        }
        if (p == null) {
            p = Pattern.compile(rx);
            compiledPathPatterns.put(rx, new SoftReference<Pattern>(p));
        }
        return p.matcher(val).matches();
    }

    public static boolean matchesPathList(List<String> expressions, String val) {
        return FileConfigurationImpl.matchesPathList(null, expressions, val);
    }

    public static boolean matchesPathList(String prepend, List<String> expressions, String val) {
        if (prepend == null) {
            prepend = "";
        }
        for (String ex : expressions) {
            if (!FileConfigurationImpl.matchesPath(prepend + ex, val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IXMLFileConfiguration checkXMLFileConfiguration(String path) {
        if (path == null) {
            return null;
        }
        for (XmlSetType x : this.conf.getXmlsets().getXmlset()) {
            if (!FileConfigurationImpl.matchesPath(x.getPath(), path)) continue;
            XMLFileConfigurationImpl c = new XMLFileConfigurationImpl(x, this.conf);
            return c;
        }
        return null;
    }

    @Override
    public Result checkFilePath(String path) {
        String fileName = new File(path).getName();
        int index = fileName.lastIndexOf(".");
        String ext = null;
        ext = index > 0 ? fileName.substring(index + 1, fileName.length()) : "";
        Result r = this.checkExtension(ext);
        if (r.isAllowed()) {
            r = this.checkPath(path);
        }
        return r;
    }

    private Result checkExtension(String ext) {
        DefaultFileSetDescription fileset = this.conf.getFilesets().getDefaultFileSet();
        if (fileset == null) {
            return Result.PASSED;
        }
        if (!fileset.getInclude().isEmpty()) {
            for (String type : fileset.getInclude()) {
                if (!this.extensionBlongingTo(type, ext)) continue;
                return Result.PASSED;
            }
            return Util.extensionNotAllowed(fileset.getMessageId(), ext, fileset.getSeverity());
        }
        if (fileset.getExclude().isEmpty()) {
            return Result.PASSED;
        }
        for (FileSetExcludeDescription type : fileset.getExclude()) {
            if (!this.extensionBlongingTo(type.getValue(), ext)) continue;
            return Util.extensionNotAllowed(type.getMessageId() == null ? fileset.getMessageId() : type.getMessageId(), ext, type.getSeverity());
        }
        return Result.PASSED;
    }

    private Result checkPath(String path) {
        DefaultFileSetDescription fileset = this.conf.getFilesets().getDefaultFileSet();
        if (fileset == null) {
            return Result.PASSED;
        }
        if (!fileset.getInclude().isEmpty()) {
            for (String type : fileset.getInclude()) {
                if (!this.pathBlongingTo(type, path)) continue;
                return Result.PASSED;
            }
            return Util.pathNotAllowed(fileset.getMessageId(), path, fileset.getSeverity());
        }
        if (fileset.getExclude().isEmpty()) {
            return Result.PASSED;
        }
        for (FileSetExcludeDescription type : fileset.getExclude()) {
            if (!this.pathBlongingTo(type.getValue(), path)) continue;
            return Util.pathNotAllowed(type.getMessageId() == null ? fileset.getMessageId() : type.getMessageId(), path, type.getSeverity());
        }
        return Result.PASSED;
    }

    private boolean extensionBlongingTo(String type, String ext) {
        for (Filesetsdefinition.Fileset fs : this.conf.getFilesetsdefinition().getFileset()) {
            if (!fs.getName().equals(type) || fs.getExtensions() == null) continue;
            for (String x : fs.getExtensions().getExtension()) {
                if (!ext.equalsIgnoreCase(x)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pathBlongingTo(String type, String path) {
        for (Filesetsdefinition.Fileset fs : this.conf.getFilesetsdefinition().getFileset()) {
            if (!fs.getName().equals(type) || fs.getPaths() == null) continue;
            return FileConfigurationImpl.matchesPathList(fs.getPaths().getPath(), path);
        }
        return false;
    }

    @Override
    public IArchiveConfiguration checkArchiveConfiguration(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        for (ArchiveDescription arc : this.conf.getFilesets().getArchive()) {
            if (!FileConfigurationImpl.matchesPath(arc.getName(), resourcePath)) continue;
            return new ArchiveConfigurationImpl(arc, this.conf, resourcePath);
        }
        return null;
    }

    @Override
    public IPropertyFileConfiguration checkPropertyFileConfiguration(String resourcePath) {
        if (resourcePath == null) {
            return null;
        }
        for (PropertySetType p : this.conf.getPropertysets().getPropertyset()) {
            if (!FileConfigurationImpl.matchesPath(p.getPath(), resourcePath)) continue;
            PropertyFileConfigurationImpl c = new PropertyFileConfigurationImpl(p);
            return c;
        }
        return null;
    }
}

