/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cloud.scanning.ScanningUtil;
import oracle.cloud.scanning.api.config.IConfiguration;
import oracle.cloud.scanning.config.PropertyFinderAdapter;
import oracle.cloud.scanning.config.imp.IPropertyFinder;
import oracle.cloud.scanning.types.ApiSetExcludeDescription;
import oracle.cloud.scanning.types.ApiSetType;
import oracle.cloud.scanning.types.ApiSetsType;
import oracle.cloud.scanning.types.ArchiveDescription;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.DefaultFileSetDescription;
import oracle.cloud.scanning.types.Fields;
import oracle.cloud.scanning.types.FileSetExcludeDescription;
import oracle.cloud.scanning.types.FileSetIncludeMustDescription;
import oracle.cloud.scanning.types.Filesets;
import oracle.cloud.scanning.types.Filesetsdefinition;
import oracle.cloud.scanning.types.MethodExcludeDescription;
import oracle.cloud.scanning.types.MethodIncludeDescription;
import oracle.cloud.scanning.types.Methods;
import oracle.cloud.scanning.types.PropertyKeyType;
import oracle.cloud.scanning.types.PropertySetType;
import oracle.cloud.scanning.types.PropertyValueType;
import oracle.cloud.scanning.types.Propertysets;
import oracle.cloud.scanning.types.ScanSetType;
import oracle.cloud.scanning.types.ScanSetsType;
import oracle.cloud.scanning.types.Severity;
import oracle.cloud.scanning.types.XmlAttributeType;
import oracle.cloud.scanning.types.XmlAttributeValueType;
import oracle.cloud.scanning.types.XmlElementType;
import oracle.cloud.scanning.types.XmlElementValueType;
import oracle.cloud.scanning.types.XmlSetType;
import oracle.cloud.scanning.types.Xmlnamespaces;
import oracle.cloud.scanning.types.Xmlsets;

public class ConfigurationImpl
implements IConfiguration {
    protected Configuration conf = null;
    protected IPropertyFinder propFinder;
    private static String DOUBLE_STAR_ENCODED = "DOUBLE_STAR_ENCODED_TEMP";
    private static final Map<String, SoftReference<Pattern>> compiledClassPatterns = new HashMap<String, SoftReference<Pattern>>();

    public ConfigurationImpl(Configuration conf, IPropertyFinder pf) {
        this.conf = conf;
        this.propFinder = new PropertyFinderAdapter(pf, conf.getProperties());
        this.updateToRegularExpression();
    }

    private List<String> translateToRxClassAndClear(List<String> list) {
        ArrayList<String> l = new ArrayList<String>();
        if (list != null) {
            for (String s : list) {
                l.add(this.translateToRxClass(s));
            }
            list.clear();
        }
        return l;
    }

    public static String removeAllLastSlashes(String s) {
        if (s.endsWith("/")) {
            return ConfigurationImpl.removeAllLastSlashes(s.substring(0, s.length() - 1));
        }
        return s;
    }

    private List<String> translateToRxPathAndClear(List<String> list) {
        ArrayList<String> l = new ArrayList<String>();
        if (list != null) {
            for (String s : list) {
                l.add(this.translateToRxPath(s));
            }
            list.clear();
        }
        return l;
    }

    public String translateToRxPath(String ex) {
        String extemp = ex;
        try {
            if (ex == null) {
                ex = "**";
            }
            if ((ex = ScanningUtil.replace(ex, this.propFinder)).contains("***")) {
                throw new RuntimeException("*** together not allowed in the configuration file: The expression:" + ex + " not allowed");
            }
            if (ex.contains(DOUBLE_STAR_ENCODED)) {
                throw new RuntimeException(DOUBLE_STAR_ENCODED + " not allowed in the configuration file: The expression:" + ex + " not allowed");
            }
            ex = ex.trim();
            ex = ex.replaceAll("\\.", "\\\\.");
            ex = ex.replaceAll("\\*\\*", DOUBLE_STAR_ENCODED);
            ex = ex.replaceAll("\\*", "[^/]*");
            ex = ex.replaceAll(DOUBLE_STAR_ENCODED, ".*");
            return ex;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while processing expression:" + extemp, e);
        }
    }

    public String translateToRxClass(String ex) {
        return ConfigurationImpl.translateToRxClass(ex, this.propFinder);
    }

    public static String translateToRxClass(String ex, IPropertyFinder finder) {
        String extemp = ex;
        try {
            if (ex == null) {
                ex = "**";
            }
            if ((ex = ScanningUtil.replace(ex, finder)).contains("***")) {
                throw new RuntimeException("*** together not allowed in the configuration file: The expression:" + ex + " not allowed");
            }
            if (ex.contains(DOUBLE_STAR_ENCODED)) {
                throw new RuntimeException(DOUBLE_STAR_ENCODED + " not allowed in the configuration file: The expression:" + ex + " not allowed");
            }
            ex = ex.trim();
            ex = ex.replaceAll("\\.", "\\\\.");
            ex = ex.replaceAll("\\*\\*", DOUBLE_STAR_ENCODED);
            ex = ex.replaceAll("\\*", "[^.]*");
            ex = ex.replaceAll(DOUBLE_STAR_ENCODED, ".*");
            return ex;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while processing expression:" + extemp, e);
        }
    }

    public static Pattern getPattern(String rx) {
        SoftReference<Pattern> ref = compiledClassPatterns.get(rx);
        Pattern p = null;
        if (ref != null) {
            p = ref.get();
        }
        if (p == null) {
            p = Pattern.compile(rx);
            compiledClassPatterns.put(rx, new SoftReference<Pattern>(p));
        }
        return p;
    }

    public static boolean matchesClass(String rx, String val) {
        return ConfigurationImpl.getPattern(rx).matcher(val).matches();
    }

    /*
     * WARNING - void declaration
     */
    private void updateToRegularExpression() {
        if (this.conf.getApisets() != null) {
            for (ApiSetType ap : this.conf.getApisets().getApiset()) {
                ap.setName(this.translateToRxClass(ap.getName()));
                for (ApiSetExcludeDescription apiSetExcludeDescription : ap.getExclude()) {
                    apiSetExcludeDescription.setValue(this.translateToRxClass(apiSetExcludeDescription.getValue()));
                    if (apiSetExcludeDescription.getSeverity() == null) {
                        apiSetExcludeDescription.setSeverity(ap.getSeverity());
                    }
                    if (apiSetExcludeDescription.getWhenexempted() == null) {
                        apiSetExcludeDescription.setWhenexempted(ap.getWhenexempted());
                    }
                    if (apiSetExcludeDescription.getMessageId() != null) continue;
                    apiSetExcludeDescription.setMessageId(ap.getMessageId());
                }
                ap.getInclude().addAll(this.translateToRxClassAndClear(ap.getInclude()));
            }
            for (Fields cf : this.conf.getApisets().getFields()) {
                cf.setClassname(this.translateToRxClass(cf.getClassname()));
                cf.getExclude().addAll(this.translateToRxClassAndClear(cf.getExclude()));
                cf.getInclude().addAll(this.translateToRxClassAndClear(cf.getInclude()));
            }
            for (Methods cm : this.conf.getApisets().getMethods()) {
                if (cm.getSeverity() == null) {
                    cm.setSeverity(Severity.ERROR);
                }
                cm.setClassname(this.translateToRxClass(cm.getClassname()));
                for (MethodIncludeDescription methodIncludeDescription : cm.getInclude()) {
                    if (methodIncludeDescription.getMethodname() == null) {
                        methodIncludeDescription.setConstructor(Boolean.TRUE);
                        continue;
                    }
                    methodIncludeDescription.setMethodname(this.translateToRxClass(methodIncludeDescription.getMethodname()));
                }
                for (MethodExcludeDescription methodExcludeDescription : cm.getExclude()) {
                    if (methodExcludeDescription.getMethodname() == null) {
                        methodExcludeDescription.setConstructor(Boolean.TRUE);
                    } else {
                        methodExcludeDescription.setMethodname(this.translateToRxClass(methodExcludeDescription.getMethodname()));
                    }
                    if (methodExcludeDescription.getSeverity() != null) continue;
                    methodExcludeDescription.setSeverity(cm.getSeverity());
                }
            }
        } else {
            this.conf.setApisets(new ApiSetsType());
        }
        if (this.conf.getScansets() != null) {
            for (ScanSetType sc : this.conf.getScansets().getScanset()) {
                sc.setName(this.translateToRxClass(sc.getName()));
                sc.getExclude().addAll(this.translateToRxClassAndClear(sc.getExclude()));
                sc.getInclude().addAll(this.translateToRxClassAndClear(sc.getInclude()));
                sc.getExcludeDependency().addAll(this.translateToRxClassAndClear(sc.getExcludeDependency()));
            }
        } else {
            this.conf.setScansets(new ScanSetsType());
        }
        if (this.conf.getFilesets() != null) {
            for (ArchiveDescription fs : this.conf.getFilesets().getArchive()) {
                fs.setName(this.translateToRxPath(fs.getName()));
                for (FileSetIncludeMustDescription fileSetIncludeMustDescription : fs.getIncludeMust()) {
                    if (fileSetIncludeMustDescription.getValue() == null) {
                        fileSetIncludeMustDescription.setValue("");
                    }
                    fileSetIncludeMustDescription.setValue(fileSetIncludeMustDescription.getValue().trim());
                }
            }
            DefaultFileSetDescription def = this.conf.getFilesets().getDefaultFileSet();
            if (def != null) {
                for (FileSetExcludeDescription ex : def.getExclude()) {
                    if (ex.getValue() == null) {
                        ex.setValue("");
                    }
                    ex.setValue(ex.getValue().trim());
                }
                ArrayList<String> trimed = new ArrayList<String>();
                for (String string : def.getInclude()) {
                    void var4_13;
                    if (string == null) {
                        String string2 = "";
                    }
                    trimed.add(var4_13.trim());
                }
                def.getInclude().clear();
                def.getInclude().addAll(trimed);
            }
        } else {
            this.conf.setFilesets(new Filesets());
        }
        if (this.conf.getFilesetsdefinition() == null) {
            this.conf.setFilesetsdefinition(new Filesetsdefinition());
        } else {
            Filesetsdefinition filesetsdefinition = this.conf.getFilesetsdefinition();
            for (Filesetsdefinition.Fileset fs : filesetsdefinition.getFileset()) {
                if (fs.getPaths() == null) {
                    fs.setPaths(new Filesetsdefinition.Fileset.Paths());
                }
                fs.getPaths().getPath().addAll(this.translateToRxPathAndClear(fs.getPaths().getPath()));
            }
        }
        if (this.conf.getXmlsets() == null) {
            this.conf.setXmlsets(new Xmlsets());
        }
        if (this.conf.getXmlsets().getXmlnamespaces() == null) {
            this.conf.getXmlsets().setXmlnamespaces(new Xmlnamespaces());
        }
        for (XmlSetType xml : this.conf.getXmlsets().getXmlset()) {
            xml.setPath(this.translateToRxPath(xml.getPath()));
            for (XmlElementType xmlElementType : xml.getXmlelement()) {
                if (!xmlElementType.getXpath().endsWith("/")) {
                    xmlElementType.setXpath(xmlElementType.getXpath() + "/");
                }
                xmlElementType.setXpath(this.translateToRxPath(xmlElementType.getXpath()));
                xmlElementType.getExclude().addAll(this.translateToRxPathAndClear(xmlElementType.getExclude()));
                xmlElementType.getInclude().addAll(this.translateToRxPathAndClear(xmlElementType.getInclude()));
                xmlElementType.getIncludeMust().addAll(this.translateToRxPathAndClear(xmlElementType.getIncludeMust()));
            }
            for (XmlElementValueType xmlElementValueType : xml.getXmlelementvalue()) {
                xmlElementValueType.setElement(this.translateToRxPath(ConfigurationImpl.removeAllLastSlashes(xmlElementValueType.getElement())));
                xmlElementValueType.getExclude().addAll(this.translateToRxPathAndClear(xmlElementValueType.getExclude()));
                xmlElementValueType.getInclude().addAll(this.translateToRxPathAndClear(xmlElementValueType.getInclude()));
            }
            for (XmlAttributeType xmlAttributeType : xml.getXmlattribute()) {
                xmlAttributeType.setElement(this.translateToRxPath(ConfigurationImpl.removeAllLastSlashes(xmlAttributeType.getElement())));
                xmlAttributeType.getExclude().addAll(this.translateToRxPathAndClear(xmlAttributeType.getExclude()));
                xmlAttributeType.getInclude().addAll(this.translateToRxPathAndClear(xmlAttributeType.getInclude()));
                xmlAttributeType.getIncludeMust().addAll(this.translateToRxPathAndClear(xmlAttributeType.getIncludeMust()));
            }
            for (XmlAttributeValueType xmlAttributeValueType : xml.getXmlattributevalue()) {
                xmlAttributeValueType.setElement(this.translateToRxPath(ConfigurationImpl.removeAllLastSlashes(xmlAttributeValueType.getElement())));
                xmlAttributeValueType.setAttribute(this.translateToRxPath(xmlAttributeValueType.getAttribute()));
                xmlAttributeValueType.getExclude().addAll(this.translateToRxPathAndClear(xmlAttributeValueType.getExclude()));
                xmlAttributeValueType.getInclude().addAll(this.translateToRxPathAndClear(xmlAttributeValueType.getInclude()));
            }
        }
        if (this.conf.getPropertysets() == null) {
            this.conf.setPropertysets(new Propertysets());
        }
        for (PropertySetType set : this.conf.getPropertysets().getPropertyset()) {
            set.setPath(this.translateToRxPath(set.getPath()));
            for (PropertyKeyType propertyKeyType : set.getProperty()) {
                propertyKeyType.setKey(this.translateToRxClass(propertyKeyType.getKey()));
                if (propertyKeyType.getValues() == null) {
                    propertyKeyType.setValues(new PropertyValueType());
                }
                if (propertyKeyType.getIncludeMust() && propertyKeyType.getValues().getExclude().isEmpty() && propertyKeyType.getValues().getExclude().isEmpty()) {
                    throw new RuntimeException("Invalid configuration: key " + propertyKeyType.getKey() + " is to be included; but no possible value is specified for file:" + set.getPath());
                }
                propertyKeyType.getValues().getExclude().addAll(this.translateToRxPathAndClear(propertyKeyType.getValues().getExclude()));
                propertyKeyType.getValues().getInclude().addAll(this.translateToRxPathAndClear(propertyKeyType.getValues().getInclude()));
            }
        }
    }

    @Override
    public String getVersion() {
        return this.conf.getVersion();
    }
}

