/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.cloud.common.introspection.api.FailedReference;
import oracle.cloud.common.introspection.api.ref.InsideMethod;
import oracle.cloud.common.introspection.api.ref.OnAnnotation;
import oracle.cloud.common.introspection.api.ref.OnAnnotationValue;
import oracle.cloud.common.introspection.api.ref.OnClassSignature;
import oracle.cloud.common.introspection.api.ref.OnField;
import oracle.cloud.common.introspection.api.ref.OnMethod;
import oracle.cloud.common.introspection.api.ref.OnMethodArg;
import oracle.cloud.common.introspection.api.ref.OnMethodException;
import oracle.cloud.common.introspection.api.ref.OnMethodReturnType;
import oracle.cloud.common.introspection.api.ref.OnReference;
import oracle.cloud.common.introspection.api.ref.Reference;
import oracle.cloud.common.introspection.asm.visitor.ClassVisitorImpl;
import oracle.cloud.common.introspection.model.Annotation;
import oracle.cloud.common.introspection.model.Argument;
import oracle.cloud.common.introspection.model.Field;
import oracle.cloud.common.introspection.model.Method;
import oracle.cloud.common.introspection.model.Type;
import oracle.cloud.common.introspection.model.sig.Bound;
import oracle.cloud.common.introspection.model.sig.ClassSignature;
import oracle.cloud.common.introspection.model.sig.field.ArrayType;
import oracle.cloud.common.introspection.model.sig.field.ExtendsWildCardType;
import oracle.cloud.common.introspection.model.sig.field.FieldSignature;
import oracle.cloud.common.introspection.model.sig.field.FieldSignatureWrapper;
import oracle.cloud.common.introspection.model.sig.field.ParameterizedType;
import oracle.cloud.common.introspection.model.sig.field.SuperWildCardType;
import oracle.cloud.common.introspection.usage.impl.AbstractUsageImpl;
import oracle.cloud.common.introspection.usage.impl.FieldUsageImpl;
import oracle.cloud.common.introspection.usage.impl.MethodUsageImpl;
import oracle.cloud.common.introspection.usage.impl.TypeUsageImpl;
import oracle.cloud.common.introspection.usage.impl.VariableUsageImpl;
import oracle.cloud.common.introspection.value.AnnotationValued;
import oracle.cloud.common.introspection.value.EnumValued;
import oracle.cloud.common.introspection.value.SimpleValued;
import oracle.cloud.scanning.api.config.IClassConfiguration;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.IClassScanningConfiguration;
import oracle.cloud.scanning.config.imp.ClassConfigurationImpl;
import oracle.cloud.scanning.config.imp.IPropertyFinder;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.ScanSetType;
import org.objectweb.asm.ClassReader;

public class ClassScanningConfigurationImpl
extends ClassConfigurationImpl
implements IClassScanningConfiguration {
    public ClassScanningConfigurationImpl(Configuration conf, IPropertyFinder props) {
        super(conf, props);
    }

    protected Result checkClassToBeScannedCorrectClassName(String clazz) {
        for (ScanSetType api : this.conf.getScansets().getScanset()) {
            if (!ClassScanningConfigurationImpl.matchesClass(api.getName(), clazz)) continue;
            if (!api.getInclude().isEmpty()) {
                if (ClassScanningConfigurationImpl.isMatchingClass(api.getInclude(), clazz)) {
                    return Result.PASSED;
                }
                return Util.classNotToBeScanned(clazz, api.getExcludeDependency(), api.getSeverity());
            }
            if (api.getExclude().isEmpty()) {
                return Util.classNotToBeScanned(clazz, api.getExcludeDependency(), api.getSeverity());
            }
            if (ClassScanningConfigurationImpl.isMatchingClass(api.getExclude(), clazz)) {
                return Util.classNotToBeScanned(clazz, api.getExcludeDependency(), api.getSeverity());
            }
            return Result.PASSED;
        }
        return Result.PASSED;
    }

    @Override
    public Result checkClassToBeScanned(String clazz) {
        if (clazz == null) {
            throw new RuntimeException("clazz can not be null");
        }
        int index = (clazz = clazz.replaceAll("/", "\\.")).indexOf("[");
        if (index > 0) {
            clazz = clazz.substring(0, index);
        }
        return this.checkClassToBeScannedCorrectClassName(clazz);
    }

    @Override
    public List<FailedReference> scanClassFile(InputStream in) throws IOException {
        return this.scanType(this.parseClassFile(in));
    }

    @Override
    public List<FailedReference> scanType(Type modelType) {
        return this.scanType(modelType, this);
    }

    @Override
    public List<FailedReference> scanType(Type modelType, IClassConfiguration classConfig) {
        ArrayList<FailedReference> list = new ArrayList<FailedReference>();
        for (Annotation a : modelType.getAnnotations()) {
            ClassScanningConfigurationImpl.processAnnotation(a, list, null, classConfig);
        }
        ClassScanningConfigurationImpl.processClassName(modelType.getClassDescription().getFullyQualifiedClassName(), list, null, classConfig);
        OnClassSignature onClass = new OnClassSignature(modelType.getClassDescription().getFullyQualifiedClassName(), null);
        if (modelType.getSignature() != null) {
            ClassScanningConfigurationImpl.processSignature(modelType.getSignature(), list, onClass, classConfig);
        } else {
            if (modelType.getBaseType() != null) {
                ClassScanningConfigurationImpl.processBaseType(modelType.getBaseType(), list, onClass, classConfig);
            }
            if (modelType.getInterfaces() != null) {
                for (String in : modelType.getInterfaces()) {
                    ClassScanningConfigurationImpl.processBaseType(in, list, onClass, classConfig);
                }
            }
        }
        for (Field f : modelType.getFields()) {
            for (Annotation a : f.getAnnotations()) {
                ClassScanningConfigurationImpl.processAnnotation(a, list, new OnField("Annotation at field:" + f.getName(), f.getName()), classConfig);
            }
            ClassScanningConfigurationImpl.processFieldSignature(f.getSignature(), list, new OnField("Signature for field:" + f.getName(), f.getName()), classConfig);
        }
        for (Method m : modelType.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                ClassScanningConfigurationImpl.processAnnotation(a, list, new OnMethod("Annotation at method:" + m.getName(), m.getName(), m.getArgumentTypes()), classConfig);
            }
            ClassScanningConfigurationImpl.processFieldSignature(m.getReturnType().getSignature(), list, new OnMethodReturnType("Return type at method:" + m.getName(), m.getName(), m.getArgumentTypes()), classConfig);
            int count = 0;
            for (Argument ar : m.getArguments()) {
                for (Annotation a : ar.getAnnotations()) {
                    ClassScanningConfigurationImpl.processAnnotation(a, list, new OnMethodArg("Annotation on argument at index (starting with 0):" + count + " for method:" + m.getName(), m.getName(), m.getArgumentTypes(), count), classConfig);
                }
                ClassScanningConfigurationImpl.processFieldSignature(ar.getSignature(), list, new OnMethodArg("Argument signature at index (starting with 0):" + count + " for method:" + m.getName(), m.getName(), m.getArgumentTypes(), count), classConfig);
                ++count;
            }
            int usageCount = 0;
            for (AbstractUsageImpl u : m.getUsages()) {
                InsideMethod inmethod = new InsideMethod(u.getAsString(), m.getName(), m.getArgumentTypes(), u);
                ClassScanningConfigurationImpl.processUsage(list, inmethod, ++usageCount, classConfig);
            }
            for (Bound b : m.getParameters().values()) {
                if (b.getClassBound() != null) {
                    ClassScanningConfigurationImpl.processSignature(b.getClassBound(), list, new OnReference("Signature For Bound Class at:" + b.getFormalParameter(), new OnMethod("Parameters at method:" + m.getName(), m.getName(), m.getArgumentTypes())), classConfig);
                }
                for (ClassSignature bi : b.getInterfacesBound()) {
                    ClassScanningConfigurationImpl.processSignature(bi, list, new OnReference("Signature For Interfaces Bound at :" + b.getFormalParameter(), new OnMethod("Parameters at method:" + m.getName(), m.getName(), m.getArgumentTypes())), classConfig);
                }
            }
            int index = 0;
            for (FieldSignatureWrapper e : m.getExceptionClassNames()) {
                OnMethodException ome = new OnMethodException("Exceptions at method:" + m.getName(), m.getName(), m.getArgumentTypes(), index);
                ClassScanningConfigurationImpl.processClassName(e.getClassType(), list, ome, classConfig);
                if (e.getActual() != null) {
                    ClassScanningConfigurationImpl.processFieldSignature(e.getActual(), list, ome, classConfig);
                }
                ++index;
            }
        }
        return list;
    }

    public static void processUsage(List<FailedReference> list, InsideMethod in, int usageCount, IClassConfiguration config) {
        Result result = null;
        if (MethodUsageImpl.class.isAssignableFrom(in.getUsage().getClass())) {
            MethodUsageImpl m = (MethodUsageImpl)in.getUsage();
            result = config.checkMethodAllowed(m.getOwner().getFullyQualifiedClassName(), m.getName(), m.getArgumentClasses());
            if (!result.isAllowed()) {
                if (m.isConstructor() && in.isConstructor() && usageCount == 1) {
                    list.add(new FailedReference(new OnReference("Class Extension?..", in), result));
                } else {
                    list.add(new FailedReference(in, result));
                }
            }
        } else if (TypeUsageImpl.class.isAssignableFrom(in.getUsage().getClass())) {
            TypeUsageImpl t = (TypeUsageImpl)in.getUsage();
            result = config.checkClassAllowed(t.getType().getFullyQualifiedClassName());
            if (!result.isAllowed()) {
                list.add(new FailedReference(in, result));
            }
        } else if (FieldUsageImpl.class.isAssignableFrom(in.getUsage().getClass())) {
            FieldUsageImpl f = (FieldUsageImpl)in.getUsage();
            result = config.checkFieldAllowed(f.getOwner().getFullyQualifiedClassName(), f.getName());
            if (!result.isAllowed()) {
                list.add(new FailedReference(in, result));
            }
            ClassScanningConfigurationImpl.processFieldSignature(f.getSignature(), list, in, config);
        } else if (VariableUsageImpl.class.isAssignableFrom(in.getUsage().getClass())) {
            VariableUsageImpl v = (VariableUsageImpl)in.getUsage();
            ClassScanningConfigurationImpl.processFieldSignature(v.getSignature(), list, in, config);
        } else {
            throw new RuntimeException("Un-recognized usage:" + in.getUsage());
        }
    }

    public static void processFieldSignature(FieldSignature field, List<FailedReference> list, Reference parent, IClassConfiguration config) {
        if (field.getClassDescription() != null) {
            ClassScanningConfigurationImpl.processClassName(field.getClassDescription().getFullyQualifiedClassName(), list, parent, config);
        }
        if (ExtendsWildCardType.class.isAssignableFrom(field.getClass())) {
            ExtendsWildCardType ew = (ExtendsWildCardType)field;
            ClassScanningConfigurationImpl.processFieldSignature(ew.getLowerBound(), list, new OnReference("Lower bound", parent), config);
        } else if (SuperWildCardType.class.isAssignableFrom(field.getClass())) {
            SuperWildCardType ew = (SuperWildCardType)field;
            ClassScanningConfigurationImpl.processFieldSignature(ew.getUpperBound(), list, new OnReference("Upper bound", parent), config);
        } else if (ArrayType.class.isAssignableFrom(field.getClass())) {
            ArrayType ew = (ArrayType)field;
            ClassScanningConfigurationImpl.processFieldSignature(ew.getArrayComponentType(), list, new OnReference("Array component-type", parent), config);
        } else if (ParameterizedType.class.isAssignableFrom(field.getClass())) {
            ParameterizedType ew = (ParameterizedType)field;
            int count = 0;
            for (FieldSignature p : ew.getParameters()) {
                ClassScanningConfigurationImpl.processFieldSignature(p, list, new OnReference("Parameterized type at index(starting with 0):" + count, parent), config);
                ++count;
            }
        }
    }

    public static void processBaseType(String className, List<FailedReference> list, Reference parent, IClassConfiguration config) {
        Result result = config.checkClassAllowed(className);
        if (!result.isAllowed()) {
            list.add(new FailedReference(new OnReference("Base type", parent), result));
        }
    }

    public static void processClassName(String className, List<FailedReference> list, Reference parent, IClassConfiguration config) {
        Result result = config.checkClassAllowed(className);
        if (!result.isAllowed()) {
            list.add(new FailedReference(new OnClassSignature(className, parent), result));
        }
    }

    public static void processSignature(ClassSignature s, List<FailedReference> list, Reference parent, IClassConfiguration config) {
        if (s.getClassDescription() != null) {
            ClassScanningConfigurationImpl.processClassName(s.getClassDescription().getFullyQualifiedClassName(), list, parent, config);
        }
        if (s.getBase() != null) {
            ClassScanningConfigurationImpl.processSignature(s.getBase(), list, new OnReference("Signature For Base Type:", parent), config);
        }
        for (ClassSignature i : s.getInterfaces()) {
            ClassScanningConfigurationImpl.processSignature(i, list, new OnReference("Signature For Interfaces:", parent), config);
        }
        for (ClassSignature t : s.getTypeVariables()) {
            ClassScanningConfigurationImpl.processSignature(t, list, new OnReference("Signature For Type Variables:", parent), config);
        }
        for (Bound b : s.getParameters().values()) {
            if (b.getClassBound() != null) {
                ClassScanningConfigurationImpl.processSignature(b.getClassBound(), list, new OnReference("Signature For Bound Class at:" + b.getFormalParameter(), parent), config);
            }
            for (ClassSignature bi : b.getInterfacesBound()) {
                ClassScanningConfigurationImpl.processSignature(bi, list, new OnReference("Signature For Interfaces Bound at :" + b.getFormalParameter(), parent), config);
            }
        }
    }

    public static void processAnnotation(Annotation a, List<FailedReference> list, Reference parent, IClassConfiguration config) {
        Result result = config.checkClassAllowed(a.getClassName());
        if (!result.isAllowed()) {
            list.add(new FailedReference(new OnAnnotation(a.getClassName(), parent), result));
        }
        for (SimpleValued v : a.getVales()) {
            if (EnumValued.class.isAssignableFrom(v.getClass())) {
                EnumValued e = (EnumValued)v;
                Result resultEnum = config.checkClassAllowed(e.getClassName());
                if (resultEnum.isAllowed()) continue;
                list.add(new FailedReference(new OnAnnotationValue(new OnAnnotation(a.getClassName(), parent)), resultEnum));
                continue;
            }
            if (!AnnotationValued.class.isAssignableFrom(v.getClass())) continue;
            AnnotationValued an = (AnnotationValued)v;
            ClassScanningConfigurationImpl.processAnnotation(an.getValue(), list, new OnAnnotation(a.getClassName(), parent), config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FailedReference> scanClass(Class cls) throws IOException {
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader().getParent();
        }
        InputStream in = loader.getResourceAsStream(cls.getName().replace('.', '/') + ".class");
        List<FailedReference> all = null;
        try {
            all = this.scanClassFile(in);
        }
        finally {
            in.close();
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type parseClass(Class cls) throws IOException {
        ClassLoader loader = cls.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader().getParent();
        }
        InputStream in = loader.getResourceAsStream(cls.getName().replace('.', '/') + ".class");
        try {
            Type type = this.parseClassFile(in);
            return type;
        }
        finally {
            in.close();
        }
    }

    @Override
    public Type parseClassFile(InputStream in) throws IOException {
        ClassReader reader = new ClassReader(in);
        Type t = new Type();
        reader.accept(new ClassVisitorImpl(t), 0);
        return t;
    }
}

