/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.config.imp;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.cloud.scanning.api.config.IClassConfiguration;
import oracle.cloud.scanning.api.config.MethodInvocationResult;
import oracle.cloud.scanning.api.config.Result;
import oracle.cloud.scanning.api.config.Util;
import oracle.cloud.scanning.config.imp.FileConfigurationImpl;
import oracle.cloud.scanning.config.imp.IPropertyFinder;
import oracle.cloud.scanning.types.ApiSetExcludeDescription;
import oracle.cloud.scanning.types.ApiSetType;
import oracle.cloud.scanning.types.ArgTypeMatchPolicy;
import oracle.cloud.scanning.types.Configuration;
import oracle.cloud.scanning.types.Fields;
import oracle.cloud.scanning.types.MethodDescription;
import oracle.cloud.scanning.types.MethodExcludeDescription;
import oracle.cloud.scanning.types.MethodIncludeDescription;
import oracle.cloud.scanning.types.Methods;
import oracle.cloud.scanning.types.Severity;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.NameValuePair;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ClassConfigurationImpl
extends FileConfigurationImpl
implements IClassConfiguration {
    public ClassConfigurationImpl(Configuration conf, IPropertyFinder pf) {
        super(conf, pf);
    }

    public static boolean isMatchingClass(List<String> expressions, String val) {
        for (String ex : expressions) {
            if (!ClassConfigurationImpl.matchesClass(ex, val)) continue;
            return true;
        }
        return false;
    }

    public static ApiSetExcludeDescription isMatchingClassFromAPIExclude(List<ApiSetExcludeDescription> expressions, String val) {
        for (ApiSetExcludeDescription ex : expressions) {
            if (!ClassConfigurationImpl.matchesClass(ex.getValue(), val)) continue;
            return ex;
        }
        return null;
    }

    public static boolean isAnyThingMatching(Collection<String> values, String expression) {
        for (String val : values) {
            if (!ClassConfigurationImpl.matchesClass(expression, val)) continue;
            return true;
        }
        return false;
    }

    protected Result checkClassAllowedCorrectClassName(String clazz) {
        for (ApiSetType api : this.conf.getApisets().getApiset()) {
            if (!ClassConfigurationImpl.matchesClass(api.getName(), clazz)) continue;
            if (!api.getInclude().isEmpty()) {
                if (ClassConfigurationImpl.isMatchingClass(api.getInclude(), clazz)) {
                    return Result.PASSED;
                }
                return Util.classNotAllowed(api.getMessageId(), clazz, api.getSeverity(), api.getWhenexempted());
            }
            if (api.getExclude().isEmpty()) {
                return Util.classNotAllowed(api.getMessageId(), clazz, api.getSeverity(), api.getWhenexempted());
            }
            ApiSetExcludeDescription match = ClassConfigurationImpl.isMatchingClassFromAPIExclude(api.getExclude(), clazz);
            if (match != null) {
                return Util.classNotAllowed(api.getMessageId(), clazz, match.getSeverity(), match.getWhenexempted());
            }
            return Result.PASSED;
        }
        return Result.PASSED;
    }

    @Override
    public Result checkClassAllowed(String clazz) {
        if (clazz == null) {
            throw new RuntimeException("clazz can not be null.");
        }
        int index = (clazz = clazz.replaceAll("/", "\\.")).indexOf("[");
        if (index > 0) {
            clazz = clazz.substring(0, index);
        }
        return this.checkClassAllowedCorrectClassName(clazz);
    }

    @Override
    public Result checkFieldAllowed(String clazz, String field) {
        Result res = this.checkClassAllowed(clazz);
        if (!res.isAllowed()) {
            return res;
        }
        for (Fields cf : this.conf.getApisets().getFields()) {
            if (!ClassConfigurationImpl.matchesClass(cf.getClassname(), clazz)) continue;
            if (!cf.getInclude().isEmpty()) {
                if (ClassConfigurationImpl.isMatchingClass(cf.getInclude(), field)) {
                    return Result.PASSED;
                }
                return Util.fieldNotAllowed(cf.getMessageId(), clazz, field, cf.getSeverity());
            }
            if (cf.getExclude().isEmpty()) {
                return Util.fieldNotAllowed(cf.getMessageId(), clazz, field, cf.getSeverity());
            }
            if (!ClassConfigurationImpl.isMatchingClass(cf.getInclude(), field)) {
                return Result.PASSED;
            }
            return Util.fieldNotAllowed(cf.getMessageId(), clazz, field, cf.getSeverity());
        }
        return Result.PASSED;
    }

    @Override
    public Result checkMethodAllowed(String clazz, String method, List<String> arguments) {
        Result res;
        if (method != null && method.equals("<init>")) {
            method = null;
        }
        if (!(res = this.checkClassAllowed(clazz)).isAllowed()) {
            return res;
        }
        if (arguments == null) {
            arguments = Collections.emptyList();
        }
        boolean argCheck = true;
        for (Methods cm : this.conf.getApisets().getMethods()) {
            NameValuePair<Result, MethodDescription> ret;
            if (!ClassConfigurationImpl.matchesClass(cm.getClassname(), clazz)) continue;
            argCheck = cm.getCheckArgs();
            if (!cm.getInclude().isEmpty()) {
                ret = this.checkMethod(cm.getSeverity(), cm.getMessageId(), clazz, cm.getInclude(), true, method, arguments);
                if (!ret.getName().isAllowed()) {
                    return ret.getName();
                }
                argCheck = ((MethodIncludeDescription)ret.getValue()).getCheckArgs();
                break;
            }
            if (cm.getExclude().isEmpty()) {
                return Util.methodOrConstructorNotAllowed(cm.getMessageId(), clazz, cm.getSeverity());
            }
            ret = this.checkMethod(cm.getSeverity(), cm.getMessageId(), clazz, cm.getExclude(), false, method, arguments);
            if (ret.getName().isAllowed()) break;
            return ret.getName();
        }
        if (argCheck) {
            for (String a : arguments) {
                if (a == null) {
                    throw new RuntimeException("Argument type can not be null");
                }
                res = this.checkClassAllowed(a);
                if (res.isAllowed()) continue;
                return res;
            }
        }
        return Result.PASSED;
    }

    private NameValuePair<Result, MethodDescription> checkMethod(Severity sev, String messgageid, String clazz, List<? extends MethodDescription> list, boolean include, String method, List<String> args) {
        Logger.getDEFAULT().printlnDebug("Class:" + clazz + ":method:" + method);
        for (MethodDescription methodDescription : list) {
            Result res;
            if (method != null ? methodDescription.getConstructor() : !methodDescription.getConstructor()) continue;
            if (!methodDescription.getConstructor() && !ClassConfigurationImpl.matchesClass(methodDescription.getMethodname(), method) || (res = this.checkMethod(sev, messgageid, methodDescription, clazz, method, args)) == null) continue;
            return new NameValuePair<Result, MethodDescription>(res, methodDescription);
        }
        if (include) {
            if (method != null) {
                return new NameValuePair<MethodInvocationResult, Object>(Util.methodNotAllowed(messgageid, clazz, method + CloudUtil.getCommaSeparatedListOfString(args, "(", ")", false), sev), null);
            }
            return new NameValuePair<Result, Object>(Util.constructorNotAllowed(messgageid, clazz, CloudUtil.getCommaSeparatedListOfString(args, "(", ")", false), sev), null);
        }
        return new NameValuePair<Result, Object>(Result.PASSED, null);
    }

    private Result checkMethod(Severity sev, String messageid, MethodDescription sm, String clazz, String method, List<String> args) {
        Logger.getDEFAULT().printlnDebug("Class:" + clazz + ":method:" + method);
        boolean include = true;
        if (MethodExcludeDescription.class.isAssignableFrom(sm.getClass())) {
            include = false;
            if (((MethodExcludeDescription)sm).getMessageId() != null) {
                messageid = ((MethodExcludeDescription)sm).getMessageId();
            }
            sev = ((MethodExcludeDescription)sm).getSeverity();
        }
        if (sm.getAllOverloads()) {
            if (sm.getConstructor()) {
                if (include) {
                    return Result.PASSED;
                }
                return Util.instantiationNotAllowed(messageid, clazz, sev);
            }
            if (include) {
                return Result.PASSED;
            }
            return Util.methodNotAllowed(messageid, clazz, method, sev);
        }
        if (args.isEmpty()) {
            if (sm.getArg().isEmpty()) {
                if (sm.getConstructor()) {
                    if (include) {
                        return Result.PASSED;
                    }
                    return Util.instantiationNotAllowedThruNoArg(messageid, clazz, sev);
                }
                if (include) {
                    return Result.PASSED;
                }
                return Util.methodNotAllowed(messageid, clazz, method, sev);
            }
        } else if (!sm.getArg().isEmpty()) {
            int count = 0;
            boolean allMatched = true;
            for (String a : args) {
                if (sm.getArg().size() < count) {
                    if (sm.getArgsMatchPolicy() == ArgTypeMatchPolicy.PARTIAL) break;
                    allMatched = false;
                } else if (!ClassConfigurationImpl.matchesClass(sm.getArg().get(count), a)) {
                    allMatched = false;
                    break;
                }
                ++count;
            }
            if (allMatched) {
                if (sm.getConstructor()) {
                    if (include) {
                        return Result.PASSED;
                    }
                    return Util.constructorNotAllowed(messageid, clazz, CloudUtil.getCommaSeparatedListOfString(args), sev);
                }
                if (include) {
                    return Result.PASSED;
                }
                return Util.methodNotAllowed(messageid, clazz, method + CloudUtil.getCommaSeparatedListOfString(args, "(", ")", false), sev);
            }
        }
        return null;
    }
}

