/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.scanning.cli.command;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.cloud.scanning.WhitelistConnstants;
import oracle.cloud.scanning.api.LoggingListener;
import oracle.cloud.scanning.cli.CliPropertyFinder;
import oracle.cloud.scanning.config.IAllConfiguration;
import oracle.cloud.scanning.config.generator.IncrementalScansetAdapter;
import oracle.cloud.scanning.config.imp.AllConfigurationProvider;
import oracle.cloud.scanning.scanner.AbstractScanner;
import oracle.cloud.scanning.spi.config.factory.ConfigurationFactory;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.exception.CliException;
import oracle.cloudlogic.javaservice.common.clibase.executor.CliExecutor;
import oracle.cloudlogic.javaservice.common.clibase.nls.NLSUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.OrderedMap;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;

public class ApplicationScanner
implements CliExecutor,
WhitelistConnstants {
    protected CommandLine command;
    protected Logger out = null;
    private IAllConfiguration conf = null;
    protected List<String> files = null;
    OrderedMap<String, String> properties = null;
    protected LoggingListener listener = null;
    protected boolean summary = false;
    protected boolean grid = false;
    protected boolean failonwarning = false;
    protected boolean allTogether = false;
    protected int gridWidth = 180;

    @Override
    public void setCommandLine(CommandLine command) {
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() throws CliException {
        try {
            if (this.command.toEnableDebug()) {
                Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
                Logger.getDEFAULT().printlnDebug("Build:Tue Mar 12 13:29:09 PDT 2013");
            }
            this.failonwarning = this.command.getValueAsBoolean("failonwarning");
            this.grid = this.command.getValueAsBoolean("grid");
            this.summary = this.command.getValueAsBoolean("includesummary");
            if (this.grid) {
                try {
                    this.gridWidth = Integer.parseInt(this.command.getArgValue("gridwidth"));
                    if (this.gridWidth < 0) {
                        throw new NumberFormatException("gridwidth must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new CliException("Please enter valid value for gridwidth", e);
                }
            }
            String propSeparator = this.command.getArgValue("keyvaluepairseparator", ",");
            String props = this.command.getArgValue("properties");
            if (props != null) {
                this.properties = CloudUtil.parseCommandlineProperties(props, propSeparator);
            }
            ConfigurationFactory factory = ConfigurationFactory.getInstance();
            this.files = this.command.getExtraArgs();
            if (this.files == null || this.files.isEmpty()) {
                Logger.getDEFAULT().printlnTipI18n("NLS_TIP_INPUT_FILES_AT_END");
                throw new Exception("No input files. ");
            }
            for (String file : this.files) {
                try {
                    CloudUtil.validateInputPath(file);
                }
                catch (Exception e) {
                    try {
                        new URL(file);
                        if (CloudUtil.isHttpUrl(file) || CloudUtil.isHttpsUrl(file) || CloudUtil.isFtpUrl(file)) continue;
                        throw e;
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            String config = this.command.getArgValue("config");
            if (config == null) {
                this.conf = factory.getDefaultConfiguration(new AllConfigurationProvider(new CliPropertyFinder(this.properties)));
            } else {
                FileInputStream fin = new FileInputStream(CloudUtil.validateInputFile(config, "Config File"));
                try {
                    this.conf = factory.getConfiguration(fin, new AllConfigurationProvider(new CliPropertyFinder(this.properties)));
                }
                finally {
                    fin.close();
                }
            }
            String log = this.command.getArgValue("log");
            if (log == null) {
                this.out = Logger.getDEFAULT();
            } else {
                FileOutputStream fout = new FileOutputStream(CloudUtil.validateOutputFile(log, true));
                this.out = new Logger(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fout, "UTF-8"), true), true);
                this.out.setWrapEnabled(false);
            }
            if (this.command.toEnableDebug()) {
                this.out.addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
            }
        }
        catch (Exception e) {
            throw new CliException(NLSUtil.localizeMessage("NLS_ERR_VALIDATION_FAILED"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        IncrementalScansetAdapter adapter = null;
        HashSet<String> exemptedPackages = new HashSet<String>();
        try {
            if (this.listener == null) {
                this.listener = new LoggingListener(this.out, this.grid, this.gridWidth, this.summary);
            }
            if (this.allTogether) {
                adapter = new IncrementalScansetAdapter(this.conf);
            }
            this.listener.onInit();
            for (String f : this.files) {
                try {
                    if (!this.listener.onResourceStart(f)) continue;
                    if (!this.allTogether) {
                        adapter = new IncrementalScansetAdapter(this.conf);
                    }
                    AbstractScanner.process(null, f, this.listener, adapter);
                }
                finally {
                    this.listener.onResourceEnd();
                    if (this.allTogether) continue;
                    exemptedPackages.addAll(adapter.getUsagesRx());
                }
            }
        }
        finally {
            this.listener.onEnd();
            if (this.allTogether) {
                exemptedPackages.addAll(adapter.getUsagesRx());
            }
            long errors = this.listener.getTotalFailures();
            long warnings = this.listener.getTotalWarnings();
            this.out.flush();
            this.out.commit();
            if (this.out != Logger.getDEFAULT()) {
                this.out.close();
            }
            if (errors != 0L) {
                throw new Exception(NLSUtil.localizeMessage("NLS_INFO_ALL_NOT_SUCCEEDED", errors, warnings));
            }
            if (warnings != 0L && this.failonwarning) {
                throw new Exception(NLSUtil.localizeMessage("NLS_INFO_FAIL_AS_FAIL_ON_WARNING", warnings, "failonwarning"));
            }
            if (!exemptedPackages.isEmpty()) {
                HashSet<String> exemptedPackagesSet = new HashSet<String>();
                for (String pack : exemptedPackages) {
                    int index;
                    pack = pack.replaceAll("\\.\\*", "*");
                    if ((pack = pack.replaceAll("\\\\.", ".")).startsWith("java.") || pack.startsWith("javax.")) continue;
                    int dotCount = pack.length() - pack.replaceAll("\\.", "").length();
                    if (dotCount > 2 && (index = pack.indexOf(".", 15)) > 0) {
                        pack = pack.substring(0, index) + ".**";
                    }
                    exemptedPackagesSet.add(pack);
                }
                ArrayList exemptedPackagesList = new ArrayList(exemptedPackagesSet);
                exemptedPackages.clear();
                exemptedPackagesSet.clear();
                if (!exemptedPackagesList.isEmpty()) {
                    Collections.sort(exemptedPackagesList);
                    Logger.getDEFAULT().printlnInfoI18n("NLS_WARN_EXEMPTED_LIST");
                    OrderedMap<String, String> orderedMap = Logger.getDEFAULT().initMapText();
                    synchronized (orderedMap) {
                        Logger.getDEFAULT().setCaption("Whitelist-Trusted-API");
                        Logger.getDEFAULT().addMapText("------", "-----------------------------------------");
                        Logger.getDEFAULT().addMapText("S.NO", "                 Class Pattern");
                        Logger.getDEFAULT().addMapText("------", "-----------------------------------------");
                        for (int i = 0; i < exemptedPackagesList.size(); ++i) {
                            Logger.getDEFAULT().addMapText(String.valueOf(i + 1), exemptedPackagesList.get(i));
                        }
                        Logger.getDEFAULT().addMapText("------", "-----------------------------------------");
                    }
                    Logger.getDEFAULT().endMapText(120);
                    Logger.getDEFAULT().reSetCaption();
                }
            }
        }
    }
}

